/*
 * Decompiled with CFR 0.152.
 */
package com.huguesjohnson.dubbel.audio;

public abstract class AudioPlayer {
    public static final int INFINITE_LOOP = -1;
    protected int loop;
    protected String[] trackList;
    protected int trackIndex;

    public void play(String path) {
        this.loop = 0;
        this.trackIndex = 0;
        this.trackList = new String[1];
        this.trackList[0] = path;
    }

    public void play(String path, int loop) {
        this.loop = loop;
        this.trackIndex = 0;
        this.trackList = new String[1];
        this.trackList[0] = path;
    }

    public void play(String[] paths) {
        this.loop = 0;
        this.trackIndex = 0;
        int length = paths.length;
        this.trackList = new String[length];
        System.arraycopy(paths, 0, this.trackList, 0, length);
    }

    public void play(String[] paths, int loop) {
        this.loop = loop;
        this.trackIndex = 0;
        int length = paths.length;
        this.trackList = new String[length];
        System.arraycopy(paths, 0, this.trackList, 0, length);
    }

    public abstract void stop();

    public String toString() {
        StringBuffer tostring = new StringBuffer(this.getClass().getName());
        tostring.append("\n  loop=" + this.loop);
        tostring.append("\n  trackIndex=" + this.trackIndex);
        int length = this.trackList.length;
        int index = 0;
        while (index < length) {
            tostring.append("\n  trackList[" + index + "]=" + this.trackList[index]);
            ++index;
        }
        return tostring.toString();
    }
}

