/*
 * Decompiled with CFR 0.152.
 */
package com.huguesjohnson.dubbel.audio;

import com.huguesjohnson.dubbel.audio.AudioPlayer;
import java.io.File;
import java.io.IOException;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequencer;

public class MidiPlayer
extends AudioPlayer
implements MetaEventListener {
    private Sequencer sequencer;

    @Override
    public void play(String path) {
        super.play(path);
        this.startSequencer();
    }

    @Override
    public void play(String path, int loop) {
        super.play(path, loop);
        this.startSequencer();
    }

    @Override
    public void play(String[] paths) {
        super.play(paths);
        this.startSequencer();
    }

    @Override
    public void play(String[] paths, int loop) {
        super.play(paths, loop);
        this.startSequencer();
    }

    @Override
    public void stop() {
        if (this.sequencer != null && this.sequencer.isRunning()) {
            this.sequencer.stop();
        }
    }

    @Override
    public void meta(MetaMessage metaMessage) {
        if (metaMessage.getType() == 47) {
            ++this.trackIndex;
            try {
                if (this.trackIndex < this.trackList.length) {
                    this.sequencer.setSequence(MidiSystem.getSequence(new File(this.trackList[this.trackIndex])));
                    this.sequencer.start();
                } else if (this.loop > 0) {
                    this.trackIndex = 0;
                    if (this.loop > 0) {
                        --this.loop;
                    }
                    this.sequencer.setSequence(MidiSystem.getSequence(new File(this.trackList[0])));
                    this.sequencer.start();
                }
            }
            catch (InvalidMidiDataException imdx) {
                imdx.printStackTrace();
            }
            catch (IOException iox) {
                iox.printStackTrace();
            }
        }
    }

    private void startSequencer() {
        try {
            this.sequencer = MidiSystem.getSequencer();
            if (this.sequencer == null) {
                throw new Exception("Can't obtain a midi sequencer");
            }
            this.sequencer.addMetaEventListener(this);
            this.sequencer.open();
            this.sequencer.setSequence(MidiSystem.getSequence(new File(this.trackList[0])));
            this.sequencer.start();
        }
        catch (InvalidMidiDataException imdx) {
            imdx.printStackTrace();
        }
        catch (MidiUnavailableException mux) {
            mux.printStackTrace();
        }
        catch (IOException iox) {
            iox.printStackTrace();
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }
}

