/*
 * Decompiled with CFR 0.152.
 */
package com.huguesjohnson.dubbel.converters;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;

public abstract class BinToWav {
    private static final String SEPARATOR = File.separator;
    private static final float SAMPLE_RATE = 44100.0f;
    private static final int SAMPLE_BITS = 16;
    private static final int CHANNELS = 2;
    private static final boolean SIGNED = true;
    private static final boolean BIG_ENDIAN = false;
    private static final AudioFormat FORMAT = new AudioFormat(44100.0f, 16, 2, true, false);

    public static void binToWav(String cuePath, String outputPath) {
        block25: {
            BufferedReader cueReader = null;
            AudioInputStream audioIn = null;
            try {
                try {
                    File cueFile = new File(cuePath);
                    if (!cueFile.exists()) {
                        throw new Exception(String.valueOf(cuePath) + " doesn't appear to be a file that exists");
                    }
                    cueReader = new BufferedReader(new InputStreamReader(new FileInputStream(cueFile)));
                    String cueDir = cueFile.getPath();
                    cueDir = cueDir.substring(0, cueDir.lastIndexOf(SEPARATOR) + 1);
                    String outputDir = outputPath;
                    if (!outputDir.endsWith(SEPARATOR)) {
                        outputDir = String.valueOf(outputDir) + SEPARATOR;
                    }
                    if (!new File(outputDir).exists()) {
                        throw new Exception(String.valueOf(outputPath) + " doesn't appear to be a directory that exists");
                    }
                    String currentLine = null;
                    while ((currentLine = cueReader.readLine()) != null) {
                        String nextLine;
                        if (!currentLine.toUpperCase().startsWith("FILE") || !(nextLine = cueReader.readLine()).toUpperCase().endsWith("AUDIO")) continue;
                        String fileName = currentLine.substring(currentLine.indexOf("\"") + 1, currentLine.lastIndexOf("\""));
                        String binPath = String.valueOf(cueDir) + fileName;
                        byte[] bytes = Files.readAllBytes(Paths.get(binPath, new String[0]));
                        audioIn = new AudioInputStream(new ByteArrayInputStream(bytes), FORMAT, bytes.length / FORMAT.getFrameSize());
                        int indexOf = fileName.lastIndexOf(46);
                        if (indexOf > 0) {
                            fileName = fileName.substring(0, indexOf);
                        }
                        String outPath = String.valueOf(outputDir) + fileName + ".wav";
                        AudioSystem.write(audioIn, AudioFileFormat.Type.WAVE, new File(outPath));
                        audioIn.close();
                    }
                }
                catch (Exception x) {
                    x.printStackTrace();
                    if (cueReader != null) {
                        try {
                            cueReader.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (audioIn == null) break block25;
                    try {
                        audioIn.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (cueReader != null) {
                    try {
                        cueReader.close();
                    }
                    catch (Exception exception) {}
                }
                if (audioIn != null) {
                    try {
                        audioIn.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }
}

