/*
 * Decompiled with CFR 0.152.
 */
package com.huguesjohnson.dubbel.example;

import java.util.Arrays;

public abstract class SortAlgorithms {
    public static void insertionSort(int[] arrayToSort) {
        int l = arrayToSort.length;
        int testIndex = 1;
        while (testIndex < l) {
            int key = arrayToSort[testIndex];
            int prevIndex = testIndex - 1;
            while (prevIndex >= 0 && arrayToSort[prevIndex] > key) {
                arrayToSort[prevIndex + 1] = arrayToSort[prevIndex];
                --prevIndex;
            }
            arrayToSort[prevIndex + 1] = key;
            ++testIndex;
        }
    }

    public static void mergeSort(int[] arrayToSort) {
        int[] workingArray = Arrays.copyOf(arrayToSort, arrayToSort.length);
        SortAlgorithms.mergeSortRecursive(arrayToSort, 0, arrayToSort.length, workingArray);
    }

    private static void mergeSortRecursive(int[] arrayToSort, int minIndex, int maxIndex, int[] workingArray) {
        if (minIndex + 1 >= maxIndex) {
            return;
        }
        int midIndex = (maxIndex + minIndex) / 2;
        SortAlgorithms.mergeSortRecursive(workingArray, minIndex, midIndex, arrayToSort);
        SortAlgorithms.mergeSortRecursive(workingArray, midIndex, maxIndex, arrayToSort);
        SortAlgorithms.merge(arrayToSort, minIndex, midIndex, maxIndex, workingArray);
    }

    private static void merge(int[] arrayToSort, int minIndex, int midIndex, int maxIndex, int[] workingArray) {
        int min = minIndex;
        int mid = midIndex;
        int i = minIndex;
        while (i < maxIndex) {
            if (min < midIndex && (mid >= maxIndex || workingArray[min] <= workingArray[mid])) {
                arrayToSort[i] = workingArray[min];
                ++min;
            } else {
                arrayToSort[i] = workingArray[mid];
                ++mid;
            }
            ++i;
        }
    }
}

