/*
 * Decompiled with CFR 0.152.
 */
package com.huguesjohnson.dubbel.example;

public class TokenBucket {
    private long lastFillTime;
    private int availableTokens;
    private final long refillInterval;
    private final int maxTokens;

    public TokenBucket(int maxTokens, long refillInterval) throws IllegalArgumentException {
        if (maxTokens <= 0) {
            throw new IllegalArgumentException("maxTokens must be > 0");
        }
        if (refillInterval <= 0L) {
            throw new IllegalArgumentException("refillInterval must be > 0");
        }
        this.maxTokens = maxTokens;
        this.availableTokens = maxTokens;
        this.refillInterval = refillInterval;
        this.lastFillTime = System.currentTimeMillis();
    }

    public int getTokens(int numTokensRequested) {
        this.checkRefill();
        if (numTokensRequested <= 0) {
            return 0;
        }
        if (numTokensRequested >= this.availableTokens) {
            int tokensReturned = this.availableTokens;
            this.availableTokens = 0;
            return tokensReturned;
        }
        this.availableTokens -= numTokensRequested;
        return numTokensRequested;
    }

    public boolean hasAvailableTokens() {
        this.checkRefill();
        return this.availableTokens > 0;
    }

    private void checkRefill() {
        long currentTime = System.currentTimeMillis();
        long delta = currentTime - this.lastFillTime;
        if (delta >= this.refillInterval) {
            this.lastFillTime = currentTime;
            this.availableTokens = this.maxTokens;
        }
    }
}

