/*
 * Decompiled with CFR 0.152.
 */
package com.huguesjohnson.dubbel.example;

import java.util.ArrayList;
import java.util.List;

public class WildcardRouterExample {
    private SimpleCharTreeNode rootNode = new SimpleCharTreeNode('/');

    public void addRoute(String route, String response) throws Exception {
        char[] rarray;
        SimpleCharTreeNode currentNode = this.rootNode;
        char[] cArray = rarray = route.toCharArray();
        int n = rarray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            int branchIndex = currentNode.indexOfBranch(c);
            if (branchIndex < 0) {
                currentNode.branches.add(new SimpleCharTreeNode(c));
                currentNode = currentNode.branches.get(currentNode.branches.size() - 1);
            } else {
                currentNode = currentNode.branches.get(branchIndex);
            }
            ++n2;
        }
        if (currentNode.response != null) {
            throw new Exception("The route " + route + " already exists with response " + response);
        }
        currentNode.response = response;
    }

    public String doRoute(String route) throws Exception {
        char[] rarray;
        SimpleCharTreeNode currentNode = this.rootNode;
        char[] cArray = rarray = route.toCharArray();
        int n = rarray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            int branchIndex = currentNode.indexOfBranch(c);
            if (branchIndex < 0) {
                branchIndex = this.checkWildcardRoute(currentNode);
                return currentNode.branches.get((int)branchIndex).response;
            }
            currentNode = currentNode.branches.get(branchIndex);
            ++n2;
        }
        if (currentNode.response != null) {
            return currentNode.response;
        }
        int branchIndex = this.checkWildcardRoute(currentNode);
        return currentNode.branches.get((int)branchIndex).response;
    }

    private int checkWildcardRoute(SimpleCharTreeNode node) throws Exception {
        int branchIndex = node.indexOfBranch('*');
        if (branchIndex < 0) {
            throw new Exception("Wildcard match not found.");
        }
        return branchIndex;
    }

    class SimpleCharTreeNode {
        char c;
        String response;
        List<SimpleCharTreeNode> branches;

        SimpleCharTreeNode(char c) {
            this.c = c;
            this.response = null;
            this.branches = new ArrayList<SimpleCharTreeNode>();
        }

        int indexOfBranch(char c) {
            if (this.branches == null) {
                return -1;
            }
            int i = 0;
            while (i < this.branches.size()) {
                if (this.branches.get((int)i).c == c) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
    }
}

