/*
 * Decompiled with CFR 0.152.
 */
package com.huguesjohnson.dubbel.example.test;

import com.huguesjohnson.dubbel.example.TokenBucket;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestTokenBucket {
    TestTokenBucket() {
    }

    @Test
    void test() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new TokenBucket(0, 0L));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new TokenBucket(-1, -1L));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new TokenBucket(0, 1L));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new TokenBucket(-1, 1L));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new TokenBucket(1, 0L));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new TokenBucket(1, -1L));
        TokenBucket tb = null;
        try {
            tb = new TokenBucket(4, 100L);
        }
        catch (IllegalArgumentException x) {
            Assertions.fail((String)x.getMessage());
        }
        Assertions.assertNotNull((Object)tb);
        Assertions.assertTrue((boolean)tb.hasAvailableTokens());
        Assertions.assertEquals((int)0, (int)tb.getTokens(0));
        Assertions.assertEquals((int)4, (int)tb.getTokens(100));
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException x) {
            Assertions.fail((String)x.getMessage());
        }
        Assertions.assertTrue((boolean)tb.hasAvailableTokens());
        Assertions.assertEquals((int)1, (int)tb.getTokens(1));
        Assertions.assertEquals((int)1, (int)tb.getTokens(1));
        Assertions.assertEquals((int)1, (int)tb.getTokens(1));
        Assertions.assertEquals((int)1, (int)tb.getTokens(1));
        Assertions.assertEquals((int)0, (int)tb.getTokens(1));
        Assertions.assertFalse((boolean)tb.hasAvailableTokens());
        try {
            Thread.sleep(10L);
            Assertions.assertFalse((boolean)tb.hasAvailableTokens());
            Thread.sleep(90L);
            Assertions.assertTrue((boolean)tb.hasAvailableTokens());
        }
        catch (InterruptedException x) {
            Assertions.fail((String)x.getMessage());
        }
    }
}

