/*
 * Decompiled with CFR 0.152.
 */
package com.huguesjohnson.dubbel.example.test;

import com.huguesjohnson.dubbel.example.WildcardRouterExample;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestWildcardRouterExample {
    TestWildcardRouterExample() {
    }

    @Test
    void testAddRoute() {
        WildcardRouterExample example = new WildcardRouterExample();
        try {
            example.addRoute("/route1/", "response1");
            example.addRoute("/route2/", "response2");
            example.addRoute("/route3/", "response3");
            example.addRoute("/route4/", "response4");
            example.addRoute("/wildcard1*", "wildcardresponse1");
            example.addRoute("/wildcard2*", "wildcardresponse2");
            example.addRoute("/wildcard3*", "wildcardresponse3");
            example.addRoute("/wildcard4*", "wildcardresponse4");
        }
        catch (Exception x) {
            Assertions.fail((String)x.getMessage());
        }
        try {
            example.addRoute("/route1/", "response");
            Assertions.fail((String)"This request is supposed to fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            example.addRoute("/wildcard1*", "wildcardresponse");
            Assertions.fail((String)"This request is supposed to fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    void testDoRoute() {
        WildcardRouterExample example = new WildcardRouterExample();
        try {
            example.addRoute("/route1/", "response1");
            example.addRoute("/route2/", "response2");
            example.addRoute("/route3/", "response3");
            example.addRoute("/route4/", "response4");
            example.addRoute("/wildcard1*", "wildcardresponse1");
            example.addRoute("/wildcard2*", "wildcardresponse2");
            example.addRoute("/wildcard3*", "wildcardresponse3");
            example.addRoute("/wildcard4*", "wildcardresponse4");
            Assertions.assertEquals((Object)example.doRoute("/route1/"), (Object)"response1");
            Assertions.assertEquals((Object)example.doRoute("/route2/"), (Object)"response2");
            Assertions.assertEquals((Object)example.doRoute("/route3/"), (Object)"response3");
            Assertions.assertEquals((Object)example.doRoute("/route4/"), (Object)"response4");
            Assertions.assertEquals((Object)example.doRoute("/wildcard1/whatever"), (Object)"wildcardresponse1");
            Assertions.assertEquals((Object)example.doRoute("/wildcard2/whatever"), (Object)"wildcardresponse2");
            Assertions.assertEquals((Object)example.doRoute("/wildcard3/whatever"), (Object)"wildcardresponse3");
            Assertions.assertEquals((Object)example.doRoute("/wildcard4/whatever"), (Object)"wildcardresponse4");
        }
        catch (Exception x) {
            Assertions.fail((String)x.getMessage());
        }
        try {
            example.doRoute("/route5/");
            Assertions.fail((String)"This request is supposed to fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            example.doRoute("/wildcard");
            Assertions.fail((String)"This request is supposed to fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

