/*
 * Decompiled with CFR 0.152.
 */
package com.huguesjohnson.dubbel.file;

import com.huguesjohnson.dubbel.file.FilePathComparator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.UUID;

public abstract class FileUtils {
    public static final ArrayList<File> getAllFilesRecursive(File path, FileFilter filter) {
        ArrayList<File> files = new ArrayList<File>();
        File[] filelist = path.listFiles(filter);
        int l = filelist.length;
        int i = 0;
        while (i < l) {
            if (filelist[i].isDirectory()) {
                files.addAll(FileUtils.getAllFilesRecursive(filelist[i], filter));
            } else {
                files.add(filelist[i]);
            }
            ++i;
        }
        Collections.sort(files, new FilePathComparator());
        return files;
    }

    public static final ArrayList<File> getAllFilesRecursive(File path, ArrayList<FileFilter> filters) {
        ArrayList<File> files = new ArrayList<File>();
        ArrayList<File> fileList = new ArrayList<File>();
        for (FileFilter filter : filters) {
            fileList.addAll(Arrays.asList(path.listFiles(filter)));
        }
        for (File f : fileList) {
            if (f.isDirectory()) {
                files.addAll(FileUtils.getAllFilesRecursive(f, filters));
                continue;
            }
            files.add(f);
        }
        Collections.sort(files, new FilePathComparator());
        return files;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean compareFiles(File originalFile, File compareFile) {
        long fileLength = originalFile.length();
        if (fileLength != compareFile.length()) {
            return false;
        }
        boolean verified = true;
        FileInputStream fInOriginal = null;
        FileInputStream fInCompare = null;
        try {
            try {
                fInOriginal = new FileInputStream(originalFile);
                fInCompare = new FileInputStream(compareFile);
                int originalByte = fInOriginal.read();
                int compareByte = fInCompare.read();
                while (originalByte == compareByte) {
                    if (originalByte == -1) return verified;
                    if (!verified) {
                        return verified;
                    }
                    originalByte = fInOriginal.read();
                    verified = originalByte == (compareByte = fInCompare.read());
                }
                return verified;
            }
            catch (Exception x) {
                x.printStackTrace();
                verified = false;
                try {
                    if (fInOriginal != null) {
                        fInOriginal.close();
                    }
                }
                catch (Exception x2) {
                    x2.printStackTrace();
                }
                try {
                    if (fInCompare == null) return verified;
                    fInCompare.close();
                    return verified;
                }
                catch (Exception x3) {
                    x3.printStackTrace();
                    return verified;
                }
            }
        }
        finally {
            try {
                if (fInOriginal != null) {
                    fInOriginal.close();
                }
            }
            catch (Exception x) {
                x.printStackTrace();
            }
            try {
                if (fInCompare != null) {
                    fInCompare.close();
                }
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }

    public static byte[] readBytes(String path, int startByte, int length) throws IOException {
        File f = new File(path);
        FileInputStream fis = new FileInputStream(f);
        byte[] b = new byte[length];
        fis.skip(startByte);
        fis.read(b, 0, length);
        fis.close();
        return b;
    }

    public static ArrayList<String> readLines(String path) throws IOException {
        String line;
        File f = new File(path);
        BufferedReader br = new BufferedReader(new FileReader(f));
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = br.readLine()) != null) {
            lines.add(line);
        }
        br.close();
        return lines;
    }

    public static String getExtension(String path) {
        int lastIndexOf = path.lastIndexOf(46);
        if (lastIndexOf > 0) {
            return path.substring(lastIndexOf);
        }
        return "";
    }

    public static void uuidRenamer(String path, FileFilter filter, boolean preserveExtension) throws Exception {
        File[] files;
        File dir = new File(path);
        File[] fileArray = files = dir.listFiles(filter);
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File newFile;
            File file = fileArray[n2];
            String currentFileName = file.getName();
            String newFileName = UUID.randomUUID().toString().replace("-", "");
            if (preserveExtension) {
                newFileName = String.valueOf(newFileName) + FileUtils.getExtension(currentFileName);
            }
            if (!file.renameTo(newFile = new File(String.valueOf(path) + newFileName))) {
                throw new Exception("Exception trying to rename [" + currentFileName + "] to [" + newFileName + "]");
            }
            ++n2;
        }
    }
}

