/*
 * Decompiled with CFR 0.152.
 */
package com.huguesjohnson.dubbel.file;

import java.io.File;
import java.util.StringTokenizer;

public abstract class PathResolver {
    public static final String PARENT_PATH = "..";
    public static final String SELF_PATH = ".";
    public static final String SEPARATOR = File.separator;

    public static final String getRelativePath(String absolutePath1, String absolutePath2) {
        if (absolutePath1 == null) {
            if (absolutePath2 == null) {
                return null;
            }
            return absolutePath2;
        }
        if (absolutePath2 == null) {
            return absolutePath1;
        }
        StringBuffer relativePath = new StringBuffer();
        StringTokenizer tokenizer1 = new StringTokenizer(absolutePath1, SEPARATOR);
        StringTokenizer tokenizer2 = new StringTokenizer(absolutePath2, SEPARATOR);
        if (tokenizer1.hasMoreTokens() && tokenizer2.hasMoreTokens()) {
            String token2;
            String token1 = tokenizer1.nextToken();
            if (token1.equals(token2 = tokenizer2.nextToken())) {
                int parentCount = 0;
                boolean pathBroken = false;
                while (tokenizer1.hasMoreTokens() && tokenizer2.hasMoreTokens()) {
                    token1 = tokenizer1.nextToken();
                    if (token1.equals(token2 = tokenizer2.nextToken()) && !pathBroken) continue;
                    pathBroken = true;
                    relativePath.append(SEPARATOR);
                    relativePath.append(token2);
                    ++parentCount;
                }
                if (tokenizer1.hasMoreTokens()) {
                    parentCount += tokenizer1.countTokens();
                } else if (tokenizer2.hasMoreTokens()) {
                    while (tokenizer2.hasMoreTokens()) {
                        relativePath.append(SEPARATOR);
                        relativePath.append(tokenizer2.nextToken());
                    }
                }
                if (parentCount > 0) {
                    int index = 0;
                    while (index < parentCount - 1) {
                        relativePath.insert(0, PARENT_PATH);
                        relativePath.insert(0, SEPARATOR);
                        ++index;
                    }
                    relativePath.insert(0, PARENT_PATH);
                } else {
                    relativePath.insert(0, SELF_PATH);
                }
                if (absolutePath2.endsWith(SEPARATOR)) {
                    relativePath.append(SEPARATOR);
                }
            } else {
                return absolutePath2;
            }
        }
        return relativePath.toString();
    }

    public static final String getAbsolutePath(String absolutePath, String relativePath) {
        if (absolutePath == null) {
            if (relativePath == null) {
                return null;
            }
            return relativePath;
        }
        if (relativePath == null) {
            return absolutePath;
        }
        StringBuffer finalPath = new StringBuffer(absolutePath);
        StringTokenizer tokenizer = new StringTokenizer(relativePath, SEPARATOR);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals(PARENT_PATH)) {
                int lastIndex = finalPath.length() - 1;
                int indexOf = finalPath.substring(0, lastIndex).lastIndexOf(SEPARATOR);
                if (indexOf <= 0) continue;
                finalPath.delete(indexOf, lastIndex);
                continue;
            }
            if (token.equals(SELF_PATH)) continue;
            finalPath.append(token);
            finalPath.append(SEPARATOR);
        }
        String returnPath = finalPath.toString();
        if (!relativePath.endsWith(SEPARATOR) && returnPath.endsWith(SEPARATOR)) {
            returnPath = returnPath.substring(0, returnPath.length() - SEPARATOR.length());
        }
        return returnPath;
    }
}

