/*
 * Decompiled with CFR 0.152.
 */
package com.huguesjohnson.dubbel.retailclerk.build;

import com.huguesjohnson.dubbel.retailclerk.build.BaseBuilder;
import com.huguesjohnson.dubbel.retailclerk.build.objects.ActionTableEntry;
import com.huguesjohnson.dubbel.retailclerk.build.parameters.ActionTableParameters;
import com.huguesjohnson.dubbel.util.NumberFormatters;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;

public class BuildActionTable
extends BaseBuilder {
    public static void build(String basePath, ActionTableParameters actionTable, HashMap<Integer, String> sceneIDMap) throws Exception {
        OutputStreamWriter writer = null;
        try {
            HashMap<String, Integer> actionIdMap = new HashMap<String, Integer>();
            int actionId = 0;
            while (actionId < actionTable.actions.length) {
                actionIdMap.put(actionTable.actions[actionId], actionId);
                ++actionId;
            }
            writer = new FileWriter(String.valueOf(basePath) + actionTable.filePath);
            writer.write("; generated by build tools");
            writer.write(newLine);
            writer.write(newLine);
            writer.write(";---------------------------------------------------------------------------");
            writer.write(newLine);
            writer.write("; action table constants");
            writer.write(newLine);
            writer.write(";---------------------------------------------------------------------------");
            writer.write(newLine);
            StringBuilder builder = new StringBuilder();
            builder.append("SCENE_COUNT=");
            builder.append(NumberFormatters.toHexWord(actionTable.sceneCount));
            builder.append(" ; total number of scenes");
            builder.append(newLine);
            builder.append("ACTION_COUNT=");
            builder.append(NumberFormatters.toHexWord(actionTable.actions.length));
            builder.append(" ; total number of actions");
            builder.append(newLine);
            builder.append("DAY_COUNT=");
            builder.append(NumberFormatters.toHexWord(actionTable.dayCount));
            builder.append(" ; total number of days");
            builder.append(newLine);
            builder.append("ACTION_COUNT_X4=(ACTION_COUNT*4)");
            builder.append(newLine);
            builder.append("SCENE_COUNT_X_ACTION_COUNT_X4=(SCENE_COUNT*ACTION_COUNT_X4)");
            builder.append(newLine);
            builder.append("DAY_COUNT_X4=(DAY_COUNT*4)");
            builder.append(newLine);
            builder.append(newLine);
            writer.write(builder.toString());
            writer.write("ActionTableStart:");
            writer.write(newLine);
            ArrayList<ActionTableEntry> entries = new ArrayList<ActionTableEntry>();
            entries.ensureCapacity(actionTable.entries.length);
            ActionTableEntry[] actionTableEntryArray = actionTable.entries;
            int n = actionTable.entries.length;
            int n2 = 0;
            while (n2 < n) {
                ActionTableEntry a = actionTableEntryArray[n2];
                entries.add(a);
                ++n2;
            }
            int day = 0;
            while (day < actionTable.dayCount) {
                writer.write(";---------------------------------------------------------------------------");
                writer.write(newLine);
                writer.write("; day ");
                writer.write(String.valueOf(day));
                writer.write(newLine);
                writer.write(";---------------------------------------------------------------------------");
                writer.write(newLine);
                int scene = 0;
                while (scene < actionTable.sceneCount) {
                    Integer sceneId = scene;
                    writer.write("; scene ");
                    writer.write(String.valueOf(scene));
                    writer.write(newLine);
                    int action = 0;
                    while (action < actionTable.actions.length) {
                        writer.write("\tdc.l\t");
                        ActionTableEntry a = new ActionTableEntry();
                        a.day = day;
                        a.scene = sceneIDMap.get(sceneId);
                        a.action = actionTable.actions[action];
                        int indexof = entries.indexOf(a);
                        if (indexof >= 0) {
                            writer.write(((ActionTableEntry)entries.get((int)indexof)).label);
                        } else {
                            writer.write(actionTable.defaultLabels[action]);
                        }
                        writer.write(" ; ");
                        writer.write(actionTable.actions[action]);
                        writer.write(newLine);
                        ++action;
                    }
                    ++scene;
                }
                writer.write(newLine);
                ++day;
            }
            writer.write("ActionTableEnd:");
        }
        finally {
            try {
                if (writer != null) {
                    writer.flush();
                    writer.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

