/*
 * Decompiled with CFR 0.152.
 */
package com.huguesjohnson.dubbel.retailclerk.build;

import com.huguesjohnson.dubbel.file.PathResolver;
import com.huguesjohnson.dubbel.retailclerk.build.BaseBuilder;
import com.huguesjohnson.dubbel.retailclerk.build.parameters.CollisionDataParameters;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Map;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;

public abstract class BuildCollisionData
extends BaseBuilder {
    public static void build(String basePath, CollisionDataParameters parameters) throws Exception {
        Map<String, String> sourceDestinationMap = parameters.collisionMap;
        String includeFilePath = String.valueOf(basePath) + parameters.includeFilePath;
        OutputStreamWriter collisionDataWriter = null;
        FileWriter includeDataWriter = null;
        String sourceFilePath = null;
        ArrayList<String> labels = new ArrayList<String>();
        try {
            try {
                includeDataWriter = new FileWriter(includeFilePath);
                includeDataWriter.write("; generated by build tools");
                includeDataWriter.write(newLine);
                includeDataWriter.write(newLine);
                for (Map.Entry<String, String> entry : sourceDestinationMap.entrySet()) {
                    sourceFilePath = String.valueOf(basePath) + entry.getKey();
                    String outputFilePath = String.valueOf(basePath) + entry.getValue();
                    File sourceFile = new File(sourceFilePath);
                    BufferedImage image = ImageIO.read(sourceFile);
                    int width = image.getWidth();
                    if (width != 64) {
                        throw new Exception("generateCollisionData: image width is " + width + ", expected value is 64, sourceFilePath=" + sourceFilePath);
                    }
                    int height = image.getHeight();
                    if (height != 32) {
                        throw new Exception("generateCollisionData: image height is " + height + ", expected value is 32, sourceFilePath=" + sourceFilePath);
                    }
                    int rowCounter = 0;
                    int colCounter = 0;
                    collisionDataWriter = new FileWriter(outputFilePath);
                    collisionDataWriter.write("; generated by build tools");
                    collisionDataWriter.write(newLine);
                    collisionDataWriter.write(newLine);
                    int y = 0;
                    while (y < height) {
                        long longValue = 0L;
                        int power = 0;
                        int x = 0;
                        while (x < width) {
                            int color = image.getRGB(x, y);
                            if (color != Color.WHITE.getRGB()) {
                                longValue = (long)((double)longValue + Math.pow(2.0, power));
                            }
                            if (power == 31) {
                                StringBuffer hexValue = new StringBuffer(Long.toHexString(longValue).toUpperCase());
                                int pad = 8 - hexValue.length();
                                int i = 0;
                                while (i < pad) {
                                    hexValue.insert(0, '0');
                                    ++i;
                                }
                                hexValue.insert(0, "\tdc.l\t$");
                                hexValue.append("\t; ");
                                hexValue.append("row[");
                                hexValue.append(rowCounter);
                                hexValue.append("] col[");
                                hexValue.append(colCounter);
                                hexValue.append("]");
                                if (colCounter == 0) {
                                    ++colCounter;
                                } else {
                                    colCounter = 0;
                                    ++rowCounter;
                                }
                                hexValue.append(newLine);
                                collisionDataWriter.write(hexValue.toString());
                                longValue = 0L;
                                power = 0;
                            } else {
                                ++power;
                            }
                            ++x;
                        }
                        ++y;
                    }
                    String includePathRel = PathResolver.getRelativePath(includeFilePath, outputFilePath);
                    if (includePathRel.startsWith("..")) {
                        includePathRel = includePathRel.substring(3);
                    }
                    StringBuffer includeString = new StringBuffer();
                    String label = includePathRel.substring(includePathRel.lastIndexOf(File.separator) + 1, includePathRel.lastIndexOf(46));
                    if (labels.contains(label)) {
                        throw new Exception("BuildCollisionData - Duplicate label: " + label);
                    }
                    labels.add(label);
                    includeString.append(label);
                    includeString.append("Start:");
                    includeString.append(newLine);
                    includeString.append("\tinclude '");
                    includeString.append(includePathRel);
                    includeString.append("'");
                    includeString.append(newLine);
                    includeString.append(label);
                    includeString.append("End:");
                    includeString.append(newLine);
                    includeString.append(newLine);
                    includeDataWriter.write(includeString.toString());
                }
            }
            catch (IIOException iiox) {
                if (sourceFilePath == null) {
                    System.err.println("BuildCollisionData error - sourceFilePath==null");
                } else {
                    System.err.println("BuildCollisionData error - sourceFilePath=" + sourceFilePath);
                }
                throw iiox;
            }
            catch (Exception x) {
                if (sourceFilePath == null) {
                    System.err.println("BuildCollisionData error - sourceFilePath==null");
                } else {
                    System.err.println("BuildCollisionData error - sourceFilePath=" + sourceFilePath);
                }
                throw x;
            }
        }
        finally {
            try {
                if (collisionDataWriter != null) {
                    collisionDataWriter.flush();
                    collisionDataWriter.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (includeDataWriter != null) {
                    includeDataWriter.flush();
                    includeDataWriter.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

