/*
 * Decompiled with CFR 0.152.
 */
package com.huguesjohnson.dubbel.retailclerk.build;

import com.huguesjohnson.dubbel.file.PathResolver;
import com.huguesjohnson.dubbel.retailclerk.build.BaseBuilder;
import com.huguesjohnson.dubbel.retailclerk.build.parameters.ConstantFileParameters;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Map;
import javax.imageio.IIOException;

public class BuildConstants
extends BaseBuilder {
    public static void build(String basePath, ConstantFileParameters parameters) throws Exception {
        if (parameters.fileMap == null || parameters.fileMap.size() < 1) {
            return;
        }
        OutputStreamWriter constantFileWriter = null;
        OutputStreamWriter includeDataWriter = null;
        BufferedReader bufferedReader = null;
        String sourceFilePath = null;
        String currentLine = null;
        ArrayList<String> names = new ArrayList<String>();
        try {
            try {
                String includeFilePath = String.valueOf(basePath) + parameters.includeFilePath;
                includeDataWriter = new FileWriter(includeFilePath);
                includeDataWriter.write("; generated by build tools");
                includeDataWriter.write(newLine);
                includeDataWriter.write(newLine);
                for (Map.Entry<String, String> entry : parameters.fileMap.entrySet()) {
                    sourceFilePath = String.valueOf(basePath) + entry.getKey();
                    bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(new File(sourceFilePath))));
                    String outputFilePath = String.valueOf(basePath) + entry.getValue();
                    constantFileWriter = new FileWriter(new File(outputFilePath));
                    constantFileWriter.write("; generated by build tools");
                    constantFileWriter.write(newLine);
                    constantFileWriter.write(newLine);
                    while ((currentLine = bufferedReader.readLine()) != null) {
                        StringBuffer stringBuffer = new StringBuffer();
                        if (currentLine.startsWith(";")) {
                            stringBuffer.append(currentLine);
                        } else if (currentLine.startsWith("[IF")) {
                            stringBuffer.append("\tif\t");
                            stringBuffer.append(currentLine.substring(4, currentLine.length() - 1));
                        } else if (currentLine.startsWith("[ELSE]")) {
                            stringBuffer.append("\telse");
                        } else if (currentLine.startsWith("[ENDIF]")) {
                            stringBuffer.append("\tendif");
                        } else {
                            String[] split = currentLine.split(",");
                            if (split != null && split.length > 1) {
                                String name = split[0];
                                if (names.contains(name)) {
                                    throw new Exception("BuildConstants - Duplicate constant name: " + name);
                                }
                                names.add(name);
                                stringBuffer.append(split[0]);
                                stringBuffer.append("=");
                                stringBuffer.append(split[1]);
                                if (split.length > 2) {
                                    stringBuffer.append(" ; ");
                                    stringBuffer.append(split[2]);
                                }
                            }
                        }
                        stringBuffer.append(newLine);
                        constantFileWriter.write(stringBuffer.toString());
                    }
                    String includePathRel = PathResolver.getRelativePath(includeFilePath, outputFilePath);
                    if (includePathRel.startsWith("..")) {
                        includePathRel = includePathRel.substring(3);
                    }
                    StringBuffer includeString = new StringBuffer();
                    includeString.append("\tinclude '");
                    includeString.append(includePathRel);
                    includeString.append("'");
                    includeString.append(newLine);
                    includeString.append(newLine);
                    includeDataWriter.write(includeString.toString());
                }
            }
            catch (IIOException iiox) {
                if (sourceFilePath == null) {
                    System.err.println("BuildConstants error - sourceFilePath==null");
                } else {
                    System.err.println("BuildConstants error in sourceFilePath=" + sourceFilePath);
                }
                throw iiox;
            }
            catch (Exception x) {
                if (sourceFilePath == null) {
                    System.err.println("BuildConstants error - sourceFilePath==null");
                } else {
                    System.err.println("BuildConstants error in sourceFilePath=" + sourceFilePath);
                }
                if (currentLine == null) {
                    System.err.println("currentLine==null");
                } else {
                    System.err.println("currentLine=" + currentLine);
                }
                throw x;
            }
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (constantFileWriter != null) {
                    constantFileWriter.flush();
                    constantFileWriter.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (includeDataWriter != null) {
                    includeDataWriter.flush();
                    includeDataWriter.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

