/*
 * Decompiled with CFR 0.152.
 */
package com.huguesjohnson.dubbel.retailclerk.build;

import com.huguesjohnson.dubbel.retailclerk.build.BaseBuilder;
import com.huguesjohnson.dubbel.retailclerk.build.parameters.HeaderParameters;
import com.huguesjohnson.dubbel.util.DateUtil;
import java.io.FileWriter;
import java.io.OutputStreamWriter;

public abstract class BuildHeader
extends BaseBuilder {
    public static void build(String basePath, HeaderParameters header) throws Exception {
        OutputStreamWriter headerWriter = null;
        try {
            try {
                String year = DateUtil.now(DateUtil.DF_Year);
                String version = DateUtil.now(DateUtil.DF_MDVersion);
                headerWriter = new FileWriter(String.valueOf(basePath) + header.filePath);
                headerWriter.write("; generated by build tools");
                headerWriter.write(newLine);
                headerWriter.write(newLine);
                headerWriter.write("\tdc.b\t'SEGA GENESIS    '\t; console name");
                headerWriter.write(newLine);
                headerWriter.write("\tdc.b\t");
                headerWriter.write(header.copyright);
                headerWriter.write("\t; copyright");
                headerWriter.write(newLine);
                headerWriter.write("\tdc.b\t'");
                headerWriter.write(year);
                headerWriter.write(BuildHeader.getMonthString(DateUtil.getCurrentMonth()));
                headerWriter.write("'\t; date");
                headerWriter.write(newLine);
                headerWriter.write("\tdc.b\t");
                headerWriter.write(header.cartName);
                headerWriter.write("\t; cart name");
                headerWriter.write(newLine);
                headerWriter.write("\tdc.b\t");
                headerWriter.write(header.cartName);
                headerWriter.write("\t; cart name (alt)");
                headerWriter.write(newLine);
                headerWriter.write("\tdc.b\t'GM ");
                headerWriter.write(version);
                headerWriter.write("'\t; program type / serial number / version");
                headerWriter.write(newLine);
                headerWriter.write("\tdc.w\t$0000\t; ROM checksum");
                headerWriter.write(newLine);
                headerWriter.write("\tdc.b\t'J               '\t; I/O device support (unused)");
                headerWriter.write(newLine);
                headerWriter.write("\tdc.l\t");
                headerWriter.write(header.romStart);
                headerWriter.write("\t; address of ROM start");
                headerWriter.write(newLine);
                headerWriter.write("\tdc.l\t");
                headerWriter.write(header.romEnd);
                headerWriter.write("\t; address of ROM end");
                headerWriter.write(newLine);
                headerWriter.write("\tdc.l\t");
                headerWriter.write(header.ramStartEnd);
                headerWriter.write("\t; RAM start/end");
                headerWriter.write(newLine);
                headerWriter.write("\tdc.b\t");
                headerWriter.write(header.sramType);
                headerWriter.write("\t; SRAM type");
                headerWriter.write(newLine);
                headerWriter.write("\tdc.l\t");
                headerWriter.write(header.sramStart);
                headerWriter.write("\t; SRAM start address");
                headerWriter.write(newLine);
                headerWriter.write("\tdc.l\t");
                headerWriter.write(header.sramEnd);
                headerWriter.write("\t; SRAM endaddress");
                headerWriter.write(newLine);
                headerWriter.write("\tdc.b\t'            '\t; modem info");
                headerWriter.write(newLine);
                headerWriter.write("\tdc.b\t");
                headerWriter.write(header.comment);
                headerWriter.write("\t; comment");
                headerWriter.write(newLine);
                headerWriter.write("\tdc.b\t'JUE             '\t; regions allowed");
            }
            catch (Exception x) {
                x.printStackTrace();
                try {
                    if (headerWriter != null) {
                        headerWriter.flush();
                        headerWriter.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (headerWriter != null) {
                    headerWriter.flush();
                    headerWriter.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private static final String getMonthString(int month) {
        if (month == 0) {
            return ".JAN";
        }
        if (month == 1) {
            return ".FEB";
        }
        if (month == 2) {
            return ".MAR";
        }
        if (month == 3) {
            return ".APR";
        }
        if (month == 4) {
            return ".MAY";
        }
        if (month == 5) {
            return ".JUN";
        }
        if (month == 6) {
            return ".JUL";
        }
        if (month == 7) {
            return ".AUG";
        }
        if (month == 8) {
            return ".SEP";
        }
        if (month == 9) {
            return ".OCT";
        }
        if (month == 10) {
            return ".NOV";
        }
        return ".DEC";
    }
}

