/*
 * Decompiled with CFR 0.152.
 */
package com.huguesjohnson.dubbel.retailclerk.build;

import com.huguesjohnson.dubbel.retailclerk.build.BaseBuilder;
import com.huguesjohnson.dubbel.retailclerk.build.parameters.MemoryMapParameters;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.util.ArrayList;

public abstract class BuildMemoryMap
extends BaseBuilder {
    public static void build(String basePath, MemoryMapParameters parameters) throws Exception {
        String destinationFile = String.valueOf(basePath) + parameters.destinationFile;
        String baseAddress = parameters.baseAddress;
        BufferedReader bufferedReader = null;
        FileWriter outputStreamWriter = null;
        int lineNumber = 0;
        String currentLine = null;
        String sourceFile = null;
        ArrayList<String> names = new ArrayList<String>();
        try {
            try {
                outputStreamWriter = new FileWriter(new File(destinationFile));
                outputStreamWriter.write("; generated by build tools");
                outputStreamWriter.write(newLine);
                outputStreamWriter.write(newLine);
                outputStreamWriter.write("MEM_START=$" + baseAddress + newLine);
                String currentAddressHex = baseAddress;
                long currentAddressInt = Long.valueOf(currentAddressHex, 16);
                int fileIndex = 0;
                while (fileIndex < parameters.sourceFiles.length) {
                    sourceFile = String.valueOf(basePath) + parameters.sourceFiles[fileIndex];
                    bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(new File(sourceFile))));
                    String address = baseAddress;
                    while ((currentLine = bufferedReader.readLine()) != null) {
                        ++lineNumber;
                        StringBuffer stringBuffer = new StringBuffer();
                        if (currentLine.startsWith(";")) {
                            stringBuffer.append(currentLine);
                        } else {
                            String[] split = currentLine.split(",");
                            if (split.length != 3) {
                                throw new Exception("Invalid length in line " + lineNumber + " expected 3 actual " + split.length);
                            }
                            String name = split[0];
                            if (names.contains(name)) {
                                throw new Exception("BuildMemoryMap - Duplicate constant name: " + name);
                            }
                            names.add(name);
                            stringBuffer.append(split[0]);
                            stringBuffer.append("=$");
                            address = Long.toHexString(currentAddressInt).toUpperCase();
                            stringBuffer.append(address);
                            stringBuffer.append("\t; ");
                            stringBuffer.append(split[2]);
                            int size = Integer.parseInt(split[1]);
                            currentAddressInt += (long)size;
                        }
                        stringBuffer.append(newLine);
                        outputStreamWriter.write(stringBuffer.toString());
                    }
                    ++fileIndex;
                }
                outputStreamWriter.write("MEM_END=$" + Long.toHexString(currentAddressInt).toUpperCase() + newLine);
            }
            catch (Exception x) {
                if (lineNumber > 0) {
                    System.err.println("BuildMemoryMap error in line: " + lineNumber);
                }
                if (currentLine == null) {
                    System.err.println("currentLine==null");
                } else {
                    System.err.println("currentLine=" + currentLine);
                }
                if (sourceFile == null) {
                    System.err.println("sourceFile==null");
                } else {
                    System.err.println("sourceFile=" + sourceFile);
                }
                throw x;
            }
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (outputStreamWriter != null) {
                    outputStreamWriter.flush();
                    outputStreamWriter.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

