/*
 * Decompiled with CFR 0.152.
 */
package com.huguesjohnson.dubbel.retailclerk.build;

import com.google.gson.Gson;
import com.huguesjohnson.dubbel.retailclerk.build.BaseBuilder;
import com.huguesjohnson.dubbel.retailclerk.build.objects.Direction;
import com.huguesjohnson.dubbel.retailclerk.build.objects.MovementPattern;
import com.huguesjohnson.dubbel.retailclerk.build.parameters.SimpleSourceDestinationParameters;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;

public class BuildMovementPatterns
extends BaseBuilder {
    public static void build(String basePath, SimpleSourceDestinationParameters parameters) throws Exception {
        OutputStreamWriter writer = null;
        MovementPattern[] patterns = null;
        int patternIndex = -1;
        ArrayList<String> patternNames = new ArrayList<String>();
        try {
            try {
                writer = new FileWriter(String.valueOf(basePath) + parameters.destinationFile);
                writer.write("; generated by build tools");
                writer.write(newLine);
                writer.write(newLine);
                String textJson = Files.readString(Paths.get(String.valueOf(basePath) + parameters.sourceFile, new String[0]));
                patterns = (MovementPattern[])new Gson().fromJson(textJson, MovementPattern[].class);
                patternIndex = 0;
                while (patternIndex < patterns.length) {
                    String patternName = patterns[patternIndex].name;
                    if (patternNames.contains(patternName)) {
                        throw new Exception("BuildMovementPatterns- Duplicate pattern name: " + patternName);
                    }
                    patternNames.add(patternName);
                    writer.write(String.valueOf(patternName) + "Start:");
                    writer.write(newLine);
                    Direction[] steps = patterns[patternIndex].steps;
                    int stepIndex = 0;
                    while (stepIndex < steps.length) {
                        StringBuilder line = new StringBuilder();
                        line.append("\tdc.w\t");
                        line.append(steps[stepIndex].toString());
                        line.append(newLine);
                        writer.write(line.toString());
                        ++stepIndex;
                    }
                    writer.write(String.valueOf(patterns[patternIndex].name) + "End:");
                    writer.write(newLine);
                    writer.write(newLine);
                    ++patternIndex;
                }
            }
            catch (Exception x) {
                System.err.println("Error in BuildMovementPatterns");
                if (patterns == null) {
                    System.err.println("patterns==null");
                } else {
                    System.err.println("patternIndex=" + patternIndex);
                    if (patternIndex < 0) {
                        System.err.println("patternIndex<0 (which you already know)");
                    } else if (patternIndex >= patterns.length) {
                        System.err.println("patternIndex>=patterns.length");
                        System.err.println("patterns.length=" + patterns.length);
                    } else if (patterns[patternIndex] == null) {
                        System.err.println("patterns[patternIndex]==null");
                    } else {
                        System.err.println("patterns[patternIndex].name=" + patterns[patternIndex].name);
                    }
                }
                throw x;
            }
        }
        finally {
            try {
                if (writer != null) {
                    writer.flush();
                    writer.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

