/*
 * Decompiled with CFR 0.152.
 */
package com.huguesjohnson.dubbel.retailclerk.build;

import com.huguesjohnson.dubbel.file.PathResolver;
import com.huguesjohnson.dubbel.retailclerk.build.BaseBuilder;
import com.huguesjohnson.dubbel.retailclerk.build.objects.PaletteMap;
import com.huguesjohnson.dubbel.retailclerk.build.parameters.PaletteParameters;
import com.huguesjohnson.dubbel.util.GenesisColorUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;

public abstract class BuildPalette
extends BaseBuilder {
    public static HashMap<String, PaletteMap> build(String basePath, PaletteParameters parameters) throws Exception {
        PaletteMap[] paletteMap = parameters.paletteMap;
        String includeFilePath = String.valueOf(basePath) + parameters.includeFilePath;
        HashMap<String, PaletteMap> returnMap = new HashMap<String, PaletteMap>();
        OutputStreamWriter paletteWriter = null;
        FileWriter includeWriter = null;
        String sourceFilePath = null;
        String outputFilePath = null;
        try {
            includeWriter = new FileWriter(includeFilePath);
            includeWriter.write("; generated by build tools");
            includeWriter.write(newLine);
            includeWriter.write(newLine);
            PaletteMap[] paletteMapArray = paletteMap;
            int n = paletteMap.length;
            int n2 = 0;
            while (n2 < n) {
                PaletteMap entry = paletteMapArray[n2];
                sourceFilePath = String.valueOf(basePath) + entry.sourceFilePath;
                outputFilePath = String.valueOf(basePath) + entry.destinationFilePath;
                paletteWriter = new FileWriter(outputFilePath);
                paletteWriter.write("; generated by build tools");
                paletteWriter.write(newLine);
                paletteWriter.write("; extracted from: " + entry.sourceFilePath);
                paletteWriter.write(newLine);
                File sourceFile = new File(sourceFilePath);
                BufferedImage image = ImageIO.read(sourceFile);
                int width = image.getWidth();
                int height = image.getHeight();
                entry.colorsGenesisRGB = new ArrayList();
                entry.colorsHex = new ArrayList();
                int row = 0;
                while (row < height) {
                    int col = 0;
                    while (col < width) {
                        int color = image.getRGB(col, row);
                        String hexString = Integer.toHexString(color);
                        int index = -1;
                        if (entry.allowDuplicateColors == null || !entry.allowDuplicateColors.equalsIgnoreCase("true")) {
                            index = entry.colorsHex.indexOf(hexString);
                        }
                        if (index < 0) {
                            entry.colorsHex.add(hexString);
                            String genesisRGBStr = GenesisColorUtil.rgbStringToGenesisRgbString(hexString);
                            entry.colorsGenesisRGB.add(genesisRGBStr);
                            if (entry.colorsGenesisRGB.size() > 16) {
                                throw new Exception("More than 16 colors found in: " + entry.sourceFilePath);
                            }
                            StringBuffer line = new StringBuffer();
                            line.append("\tdc.w\t%");
                            line.append(genesisRGBStr);
                            line.append(" ; ~");
                            line.append(hexString);
                            line.append(newLine);
                            paletteWriter.write(line.toString());
                        }
                        ++col;
                    }
                    ++row;
                }
                int size = entry.colorsGenesisRGB.size();
                if (size < 16) {
                    int i = size;
                    while (i < 16) {
                        paletteWriter.write("\tdc.w\t%0000000000000000");
                        paletteWriter.write(newLine);
                        ++i;
                    }
                }
                if (entry.exclude == null || !entry.exclude.equalsIgnoreCase("true")) {
                    String includePathRel = PathResolver.getRelativePath(includeFilePath, outputFilePath);
                    if (includePathRel.startsWith("..")) {
                        includePathRel = includePathRel.substring(3);
                    }
                    StringBuffer includeString = new StringBuffer();
                    includeString.append(entry.name);
                    includeString.append(":");
                    includeString.append(newLine);
                    includeString.append("\tinclude '");
                    includeString.append(includePathRel);
                    includeString.append("'");
                    includeString.append(newLine);
                    includeString.append(newLine);
                    includeWriter.write(includeString.toString());
                }
                returnMap.put(entry.name, entry);
                ++n2;
            }
            HashMap<String, PaletteMap> hashMap = returnMap;
            return hashMap;
        }
        catch (IIOException iiox) {
            System.err.println("Error in BuildPalette");
            if (sourceFilePath == null) {
                System.err.println("sourceFilePath==null");
            } else {
                System.err.println("sourceFilePath=" + sourceFilePath);
            }
            if (outputFilePath == null) {
                System.err.println("outputFilePath==null");
            } else {
                System.err.println("outputFilePath=" + outputFilePath);
            }
            throw iiox;
        }
        catch (Exception x) {
            System.err.println("Error in BuildPalette");
            if (sourceFilePath == null) {
                System.err.println("sourceFilePath==null");
            } else {
                System.err.println("sourceFilePath=" + sourceFilePath);
            }
            if (outputFilePath == null) {
                System.err.println("outputFilePath==null");
            } else {
                System.err.println("outputFilePath=" + outputFilePath);
            }
            throw x;
        }
        finally {
            try {
                if (paletteWriter != null) {
                    paletteWriter.flush();
                    paletteWriter.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (includeWriter != null) {
                    includeWriter.flush();
                    includeWriter.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

