/*
 * Decompiled with CFR 0.152.
 */
package com.huguesjohnson.dubbel.retailclerk.build;

import com.huguesjohnson.dubbel.file.PathResolver;
import com.huguesjohnson.dubbel.retailclerk.build.BaseBuilder;
import com.huguesjohnson.dubbel.retailclerk.build.objects.PaletteMap;
import com.huguesjohnson.dubbel.retailclerk.build.objects.PatternFromTileset;
import com.huguesjohnson.dubbel.retailclerk.build.objects.Tile8x8;
import com.huguesjohnson.dubbel.retailclerk.build.objects.Tileset;
import com.huguesjohnson.dubbel.retailclerk.build.parameters.PatternFromTilesetParameters;
import com.huguesjohnson.dubbel.util.GenesisColorUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import javax.imageio.ImageIO;

public class BuildPatternsFromTilesets
extends BaseBuilder {
    public static void build(String basePath, PatternFromTilesetParameters parameters, HashMap<String, Tileset> tileMap, HashMap<String, PaletteMap> paletteMap) throws Exception {
        String includeFilePath = String.valueOf(basePath) + parameters.patternIncludeFilePath;
        OutputStreamWriter patternWriter = null;
        FileWriter includeWriter = null;
        String currentPatternName = null;
        ArrayList<String> patternNames = new ArrayList<String>();
        try {
            try {
                includeWriter = new FileWriter(includeFilePath, true);
                includeWriter.write(newLine);
                includeWriter.write("\t;---------------------------------------------------------------------------");
                includeWriter.write(newLine);
                includeWriter.write("\t; patterns generated from tilesets");
                includeWriter.write(newLine);
                includeWriter.write("\t;---------------------------------------------------------------------------");
                includeWriter.write(newLine);
                PatternFromTileset[] patternFromTilesetArray = parameters.patterns;
                int n = parameters.patterns.length;
                int n2 = 0;
                while (n2 < n) {
                    PatternFromTileset pattern = patternFromTilesetArray[n2];
                    currentPatternName = pattern.name;
                    if (patternNames.contains(currentPatternName)) {
                        throw new Exception("BuildPatternsFromTilesets - Duplicate pattern name: " + currentPatternName);
                    }
                    patternNames.add(currentPatternName);
                    String patternPath = String.valueOf(basePath) + pattern.destinationFilePath;
                    patternWriter = new FileWriter(patternPath);
                    patternWriter.write("Pattern" + pattern.name + ":");
                    patternWriter.write(newLine);
                    String sourceFilePath = String.valueOf(basePath) + pattern.sourceFilePath;
                    File sourceFile = new File(sourceFilePath);
                    BufferedImage image = ImageIO.read(sourceFile);
                    int width = image.getWidth();
                    if (width % 8 != 0) {
                        throw new Exception("Image width must be a multiple of 8 - sourceFile=" + sourceFile);
                    }
                    int height = image.getHeight();
                    if (height % 8 != 0) {
                        throw new Exception("Image width must be a multiple of 8 - sourceFile=" + sourceFile);
                    }
                    int rowCount = height / 8;
                    patternWriter.write("\tdc.w\t$" + Integer.toHexString(rowCount - 1).toUpperCase() + "\t; " + rowCount + " rows");
                    patternWriter.write(newLine);
                    int colCount = width / 8;
                    patternWriter.write("\tdc.w\t$" + Integer.toHexString(colCount - 1).toUpperCase() + "\t; " + colCount + " columns");
                    patternWriter.write(newLine);
                    PaletteMap palette = paletteMap.get(pattern.paletteName);
                    ArrayList<Tile8x8> baseTiles = tileMap.get((Object)pattern.tilesetName).tiles;
                    int row = 0;
                    while (row < height) {
                        int col = 0;
                        while (col < width) {
                            Tile8x8 tile8x8 = new Tile8x8();
                            int x = col;
                            while (x < col + 8) {
                                int y = row;
                                while (y < row + 8) {
                                    int index;
                                    int color = image.getRGB(x, y);
                                    String hexString = Integer.toHexString(color);
                                    tile8x8.pixels[y - row][x - col] = index = GenesisColorUtil.findNearestColor(palette.colorsHex, hexString);
                                    ++y;
                                }
                                ++x;
                            }
                            int tileIndex = baseTiles.indexOf(tile8x8);
                            if (tileIndex < 0) {
                                throw new Exception("tile not found in base tileset - col=" + col + " row=" + row);
                            }
                            patternWriter.write("\tdc.w\t$" + Integer.toHexString(tileIndex).toUpperCase());
                            patternWriter.write(newLine);
                            col += 8;
                        }
                        row += 8;
                    }
                    patternWriter.flush();
                    patternWriter.close();
                    String includePathRel = PathResolver.getRelativePath(includeFilePath.substring(0, includeFilePath.lastIndexOf(File.separator)), patternPath);
                    if (includePathRel.startsWith("..")) {
                        includePathRel = includePathRel.substring("..".length() + 1);
                    }
                    if (includePathRel.startsWith(".")) {
                        includePathRel = includePathRel.substring(".".length() + 1);
                    }
                    StringBuffer includeString = new StringBuffer();
                    includeString.append("\tinclude '");
                    includeString.append(includePathRel);
                    includeString.append("'");
                    includeString.append(newLine);
                    includeString.append(newLine);
                    includeWriter.write(includeString.toString());
                    ++n2;
                }
            }
            catch (Exception x) {
                if (currentPatternName == null) {
                    System.err.println("Error in BuildPatternsFromTilesets - currentPatternName==null");
                } else {
                    System.err.println("Error in BuildPatternsFromTilesets - currentPatternName=" + currentPatternName);
                }
                throw x;
            }
        }
        finally {
            try {
                if (patternWriter != null) {
                    patternWriter.flush();
                    patternWriter.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (includeWriter != null) {
                    includeWriter.flush();
                    includeWriter.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

