/*
 * Decompiled with CFR 0.152.
 */
package com.huguesjohnson.dubbel.retailclerk.build;

import com.google.gson.Gson;
import com.huguesjohnson.dubbel.file.PathResolver;
import com.huguesjohnson.dubbel.retailclerk.build.BaseBuilder;
import com.huguesjohnson.dubbel.retailclerk.build.objects.Scene;
import com.huguesjohnson.dubbel.retailclerk.build.objects.SceneNpcLocation;
import com.huguesjohnson.dubbel.retailclerk.build.objects.SceneObject;
import com.huguesjohnson.dubbel.retailclerk.build.objects.SceneScenery;
import com.huguesjohnson.dubbel.retailclerk.build.objects.SceneText;
import com.huguesjohnson.dubbel.retailclerk.build.objects.Tileset;
import com.huguesjohnson.dubbel.retailclerk.build.parameters.SceneParameters;
import com.huguesjohnson.dubbel.util.NumberFormatters;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class BuildScenes
extends BaseBuilder {
    public static HashMap<Integer, String> build(String basePath, SceneParameters parameters, HashMap<String, Tileset> tileMap) throws Exception {
        HashMap<Integer, String> sceneIDMap = new HashMap<Integer, String>();
        String includeFilePath = String.valueOf(basePath) + parameters.includeFilePath;
        String lookupTablePath = String.valueOf(basePath) + parameters.lookupTablePath;
        OutputStreamWriter includeWriter = null;
        OutputStreamWriter tableWriter = null;
        OutputStreamWriter sceneWriter = null;
        String currentSceneName = null;
        String scenePath = null;
        ArrayList<String> labels = new ArrayList<String>();
        try {
            int length = parameters.scenePaths.length;
            Scene[] scenes = new Scene[length];
            int i = 0;
            while (i < length) {
                scenePath = String.valueOf(basePath) + parameters.scenePaths[i];
                String sceneJson = Files.readString(Paths.get(scenePath, new String[0]));
                scenes[i] = (Scene)new Gson().fromJson(sceneJson, Scene.class);
                ++i;
            }
            includeWriter = new FileWriter(includeFilePath);
            includeWriter.write("; generated by build tools");
            includeWriter.write(newLine);
            includeWriter.write(newLine);
            tableWriter = new FileWriter(lookupTablePath);
            tableWriter.write("; generated by build tools");
            tableWriter.write(newLine);
            tableWriter.write(newLine);
            tableWriter.write(";-------------------------------------------------------------------------------");
            tableWriter.write(newLine);
            tableWriter.write("; scene definition table");
            tableWriter.write(newLine);
            tableWriter.write(";-------------------------------------------------------------------------------");
            tableWriter.write(newLine);
            tableWriter.write("SceneDefinitionTable:");
            tableWriter.write(newLine);
            int sceneIndex = 0;
            while (sceneIndex < scenes.length) {
                String column;
                String row;
                String patternString;
                sceneIDMap.put(sceneIndex, scenes[sceneIndex].id);
                currentSceneName = scenes[sceneIndex].name;
                String outputFilePath = String.valueOf(basePath) + scenes[sceneIndex].destinationFilePath;
                sceneWriter = new FileWriter(outputFilePath);
                sceneWriter.write("; generated by build tools");
                sceneWriter.write(newLine);
                sceneWriter.write(newLine);
                sceneWriter.write("\t;---------------------------------------------------------------------------");
                sceneWriter.write(newLine);
                sceneWriter.write("\t; scene ID");
                sceneWriter.write(newLine);
                sceneWriter.write("\t;---------------------------------------------------------------------------");
                sceneWriter.write(newLine);
                sceneWriter.write("\tdc.w\t" + scenes[sceneIndex].id);
                sceneWriter.write(newLine);
                sceneWriter.write(newLine);
                sceneWriter.write("\t;---------------------------------------------------------------------------");
                sceneWriter.write(newLine);
                sceneWriter.write("\t; tiles");
                sceneWriter.write(newLine);
                sceneWriter.write("\t;---------------------------------------------------------------------------");
                sceneWriter.write(newLine);
                String[] tilesetNames = scenes[sceneIndex].tilesetNames;
                sceneWriter.write("\tdc.w\t" + NumberFormatters.toHexWord(tilesetNames.length - 1) + " ; tileset count - 1");
                sceneWriter.write(newLine);
                sceneWriter.write(newLine);
                int[] tileOffsets = new int[tilesetNames.length];
                int currentOffset = 0;
                int tsIndex = 0;
                while (tsIndex < tilesetNames.length) {
                    tileOffsets[tsIndex] = currentOffset;
                    String tilesetName = scenes[sceneIndex].tilesetNames[tsIndex];
                    Tileset tileset = tileMap.get(tilesetName);
                    if (tileset == null) {
                        throw new Exception("Tileset [" + tilesetName + "] not found while building scene [" + scenes[sceneIndex].name + "]");
                    }
                    length = tileset.tiles.size();
                    sceneWriter.write("\t; tileset " + Integer.toHexString(tsIndex).toUpperCase() + " - tiles start at [" + Integer.toHexString(currentOffset).toUpperCase() + "] - tileset length [" + Integer.toHexString(length).toUpperCase() + "]");
                    sceneWriter.write(newLine);
                    currentOffset += tileset.tiles.size();
                    sceneWriter.write("\tdc.l\t" + tilesetName + "TilesStart");
                    sceneWriter.write(newLine);
                    sceneWriter.write("\tdc.l\t" + tilesetName + "TilesEnd");
                    sceneWriter.write(newLine);
                    sceneWriter.write(newLine);
                    ++tsIndex;
                }
                sceneWriter.write("\t;---------------------------------------------------------------------------");
                sceneWriter.write(newLine);
                sceneWriter.write("\t; palettes");
                sceneWriter.write(newLine);
                sceneWriter.write("\t;---------------------------------------------------------------------------");
                sceneWriter.write(newLine);
                int numPalettes = scenes[sceneIndex].paletteNames.length;
                int paletteIndex = 0;
                while (paletteIndex < numPalettes) {
                    sceneWriter.write("\tdc.l\t" + scenes[sceneIndex].paletteNames[paletteIndex]);
                    sceneWriter.write(newLine);
                    ++paletteIndex;
                }
                while (numPalettes < 4) {
                    sceneWriter.write("\tdc.l\tPaletteBlack");
                    sceneWriter.write(newLine);
                    ++numPalettes;
                }
                sceneWriter.write(newLine);
                sceneWriter.write("\t;---------------------------------------------------------------------------");
                sceneWriter.write(newLine);
                sceneWriter.write("\t; scenery");
                sceneWriter.write(newLine);
                sceneWriter.write("\t;---------------------------------------------------------------------------");
                sceneWriter.write(newLine);
                SceneScenery[] scenery = scenes[sceneIndex].scenery;
                if (scenery == null || scenery.length == 0) {
                    sceneWriter.write("\tdc.w\t$FFFF ; no scenery");
                    sceneWriter.write(newLine);
                    sceneWriter.write(newLine);
                } else {
                    sceneWriter.write("\tdc.w\t" + NumberFormatters.toHexWord(scenery.length - 1) + " ; scenery count - 1");
                    sceneWriter.write(newLine);
                    sceneWriter.write(newLine);
                    int sceneryIndex = 0;
                    while (sceneryIndex < scenery.length) {
                        String comment = scenery[sceneryIndex].comment;
                        if (comment != null && comment.length() > 0) {
                            sceneWriter.write("\t; " + scenery[sceneryIndex].comment);
                            sceneWriter.write(newLine);
                        }
                        sceneWriter.write("\tdc.l\t" + scenery[sceneryIndex].patternName);
                        sceneWriter.write(newLine);
                        sceneWriter.write("\t;\t\t%pccvhnnnnnnnnnnn");
                        sceneWriter.write(newLine);
                        int offset = tileOffsets[scenery[sceneryIndex].tilesetIndex];
                        if (scenery[sceneryIndex].tilesetOffset > 0) {
                            offset += scenery[sceneryIndex].tilesetOffset;
                        }
                        patternString = BuildScenes.buildPatternString(offset, scenery[sceneryIndex].paletteNumber, scenery[sceneryIndex].highPriority);
                        sceneWriter.write("\tdc.w\t%" + patternString + " ; vdp pattern");
                        sceneWriter.write(newLine);
                        sceneWriter.write("\tdc.w\t" + NumberFormatters.toHexWord(scenery[sceneryIndex].repeat) + " ; repeat=" + scenery[sceneryIndex].repeat);
                        sceneWriter.write(newLine);
                        row = BuildScenes.buildRowColumnString(scenery[sceneryIndex].row);
                        column = BuildScenes.buildRowColumnString(scenery[sceneryIndex].column);
                        sceneWriter.write("\tdc.l\t" + scenery[sceneryIndex].layer + "+$" + column + "+$" + row + " ; initial drawing location");
                        sceneWriter.write(newLine);
                        sceneWriter.write(newLine);
                        ++sceneryIndex;
                    }
                }
                sceneWriter.write("\t;---------------------------------------------------------------------------");
                sceneWriter.write(newLine);
                sceneWriter.write("\t; text");
                sceneWriter.write(newLine);
                sceneWriter.write("\t;---------------------------------------------------------------------------");
                sceneWriter.write(newLine);
                SceneText[] text = scenes[sceneIndex].text;
                if (text == null || text.length == 0) {
                    sceneWriter.write("\tdc.w\t$FFFF ; no text");
                    sceneWriter.write(newLine);
                    sceneWriter.write(newLine);
                } else {
                    sceneWriter.write("\tdc.w\t" + NumberFormatters.toHexWord(text.length - 1) + " ; text count");
                    sceneWriter.write(newLine);
                    sceneWriter.write(newLine);
                    int textIndex = 0;
                    while (textIndex < text.length) {
                        String comment = text[textIndex].comment;
                        if (comment != null && comment.length() > 0) {
                            sceneWriter.write("\t; " + text[textIndex].comment);
                            sceneWriter.write(newLine);
                        }
                        sceneWriter.write("\tdc.l\t" + text[textIndex].stringLabel);
                        sceneWriter.write(newLine);
                        patternString = BuildScenes.buildPatternString(0, text[textIndex].paletteNumber, false);
                        if (text[textIndex].highPriority) {
                            sceneWriter.write("\tdc.w\tFONT_BASE_TILE+%" + patternString + " ; vdp pattern");
                        } else {
                            sceneWriter.write("\tdc.w\tFONT_BASE_TILE_LOW+%" + patternString + " ; vdp pattern");
                        }
                        sceneWriter.write(newLine);
                        row = BuildScenes.buildRowColumnString(text[textIndex].row);
                        column = BuildScenes.buildRowColumnString(text[textIndex].column);
                        sceneWriter.write("\tdc.l\t" + text[textIndex].layer + "+$" + column + "+$" + row + " ; initial drawing location");
                        sceneWriter.write(newLine);
                        sceneWriter.write(newLine);
                        ++textIndex;
                    }
                }
                sceneWriter.write("\t;---------------------------------------------------------------------------");
                sceneWriter.write(newLine);
                sceneWriter.write("\t; objects");
                sceneWriter.write(newLine);
                sceneWriter.write("\t;---------------------------------------------------------------------------");
                sceneWriter.write(newLine);
                sceneWriter.write("\tdc.w\tOBJ_LIST_LENGTH-1 ; object count");
                sceneWriter.write(newLine);
                sceneWriter.write(newLine);
                sceneWriter.write("\t;---------------------------------------------------------------------------");
                sceneWriter.write(newLine);
                sceneWriter.write("\t; word0=Object ID (0-65535)");
                sceneWriter.write(newLine);
                sceneWriter.write("\t; word1[0-8]=x0 (0-511)");
                sceneWriter.write(newLine);
                sceneWriter.write("\t; word1[9-15]=width (0-127)");
                sceneWriter.write(newLine);
                sceneWriter.write("\t; word2[0-8]=y0 (0-512)");
                sceneWriter.write(newLine);
                sceneWriter.write("\t; word2[9-15]=height (0-127)");
                sceneWriter.write(newLine);
                sceneWriter.write("\t;---------------------------------------------------------------------------");
                sceneWriter.write(newLine);
                sceneWriter.write(newLine);
                SceneObject[] objects = scenes[sceneIndex].objects;
                int objLength = 0;
                if (objects != null) {
                    objLength = objects.length;
                }
                int objIndex = 0;
                while (objIndex < objLength) {
                    if (objects[objIndex] == null) {
                        sceneWriter.write("\tdc.w\tOBJ_NOTHING");
                        sceneWriter.write(newLine);
                        sceneWriter.write("\t;\t\t%wwwwwwwxxxxxxxxx");
                        sceneWriter.write(newLine);
                        sceneWriter.write("\tdc.w\t%0000000000000000");
                        sceneWriter.write(newLine);
                        sceneWriter.write("\t;\t\t%hhhhhhhyyyyyyyyy");
                        sceneWriter.write(newLine);
                        sceneWriter.write("\tdc.w\t%0000000000000000");
                        sceneWriter.write(newLine);
                        sceneWriter.write(newLine);
                    } else {
                        sceneWriter.write("\tdc.w\t" + objects[objIndex].id);
                        sceneWriter.write(newLine);
                        sceneWriter.write("\t;\t\t%wwwwwwwxxxxxxxxx");
                        sceneWriter.write(newLine);
                        sceneWriter.write("\tdc.w\t%" + BuildScenes.buildWHXYString(objects[objIndex].width, objects[objIndex].x));
                        sceneWriter.write(newLine);
                        sceneWriter.write("\t;\t\t%hhhhhhhyyyyyyyyy");
                        sceneWriter.write(newLine);
                        sceneWriter.write("\tdc.w\t%" + BuildScenes.buildWHXYString(objects[objIndex].height, objects[objIndex].y));
                        sceneWriter.write(newLine);
                        sceneWriter.write(newLine);
                    }
                    ++objIndex;
                }
                int i2 = objLength;
                while (i2 < 10) {
                    sceneWriter.write("\tdc.w\tOBJ_NOTHING");
                    sceneWriter.write(newLine);
                    sceneWriter.write("\tdc.w\t$0000");
                    sceneWriter.write(newLine);
                    sceneWriter.write("\tdc.w\t$0000");
                    sceneWriter.write(newLine);
                    sceneWriter.write(newLine);
                    ++i2;
                }
                sceneWriter.write("\t;---------------------------------------------------------------------------");
                sceneWriter.write(newLine);
                sceneWriter.write("\t; collision data");
                sceneWriter.write(newLine);
                sceneWriter.write("\t;---------------------------------------------------------------------------");
                sceneWriter.write(newLine);
                if (scenes[sceneIndex].collisionDataName == null) {
                    sceneWriter.write("\tdc.l\t$00000000");
                } else {
                    sceneWriter.write("\tdc.l\t" + scenes[sceneIndex].collisionDataName + " ; location of collision data");
                }
                sceneWriter.write(newLine);
                sceneWriter.write(newLine);
                sceneWriter.write("\t;---------------------------------------------------------------------------");
                sceneWriter.write(newLine);
                sceneWriter.write("\t; exits: 0=south,1=north,2=west,3=east");
                sceneWriter.write(newLine);
                sceneWriter.write("\t;---------------------------------------------------------------------------");
                sceneWriter.write(newLine);
                String[] exits = scenes[sceneIndex].exitIds;
                int exitsLength = 0;
                if (exits != null) {
                    exitsLength = exits.length;
                }
                int exitsIndex = 0;
                while (exitsIndex < exitsLength) {
                    sceneWriter.write("\tdc.w\t" + exits[exitsIndex]);
                    sceneWriter.write(newLine);
                    ++exitsIndex;
                }
                int i3 = exitsLength;
                while (i3 < 4) {
                    sceneWriter.write("\tdc.w\t$FFFF");
                    sceneWriter.write(newLine);
                    ++i3;
                }
                sceneWriter.write(newLine);
                sceneWriter.write("\t;---------------------------------------------------------------------------");
                sceneWriter.write(newLine);
                sceneWriter.write("\t; npc locations");
                sceneWriter.write(newLine);
                sceneWriter.write("\t;---------------------------------------------------------------------------");
                sceneWriter.write(newLine);
                SceneNpcLocation[] npcs = scenes[sceneIndex].npcLocations;
                if (npcs == null || npcs.length == 0) {
                    sceneWriter.write("\tdc.w\t$FFFF ; no npcs");
                    sceneWriter.write(newLine);
                    sceneWriter.write(newLine);
                } else {
                    sceneWriter.write("\tdc.w\t" + NumberFormatters.toHexWord(npcs.length - 1) + " ; npc count - 1");
                    sceneWriter.write(newLine);
                    sceneWriter.write(newLine);
                    int npcIndex = 0;
                    while (npcIndex < npcs.length) {
                        if (npcs[npcIndex] == null) {
                            sceneWriter.write("\tdc.w\t$0000");
                            sceneWriter.write(newLine);
                            sceneWriter.write("\tdc.w\t$0000");
                            sceneWriter.write(newLine);
                            sceneWriter.write("\tdc.w\tDIRECTION_DOWN");
                            sceneWriter.write(newLine);
                            sceneWriter.write("\tdc.w\t$FFFF");
                            sceneWriter.write(newLine);
                            sceneWriter.write("\tdc.l\tNullMovementStart");
                            sceneWriter.write(newLine);
                            sceneWriter.write("\tdc.w\t(NullMovementEnd-NullMovementStart-1)");
                            sceneWriter.write(newLine);
                            sceneWriter.write(newLine);
                        } else {
                            sceneWriter.write("\tdc.w\t" + NumberFormatters.toHexWord(npcs[npcIndex].x) + " ; starting x location of npc" + npcIndex);
                            sceneWriter.write(newLine);
                            sceneWriter.write("\tdc.w\t" + NumberFormatters.toHexWord(npcs[npcIndex].y) + " ; starting y location of npc" + npcIndex);
                            sceneWriter.write(newLine);
                            sceneWriter.write("\tdc.w\t" + npcs[npcIndex].direction + " ; starting direction of npc" + npcIndex);
                            sceneWriter.write(newLine);
                            sceneWriter.write("\tdc.w\t" + NumberFormatters.toHexWord(npcs[npcIndex].movementFrequency) + " ; movement frequency of npc" + npcIndex);
                            sceneWriter.write(newLine);
                            String movementPattern = npcs[npcIndex].movementPatternName;
                            sceneWriter.write("\tdc.l\t" + movementPattern + "Start ; location of movement pattern for npc" + npcIndex);
                            sceneWriter.write(newLine);
                            sceneWriter.write("\tdc.w\t(" + movementPattern + "End-" + movementPattern + "Start-1) ; movement pattern length");
                            sceneWriter.write(newLine);
                            sceneWriter.write(newLine);
                        }
                        ++npcIndex;
                    }
                }
                sceneWriter.write("\t;---------------------------------------------------------------------------");
                sceneWriter.write(newLine);
                sceneWriter.write("\t; bgm");
                sceneWriter.write(newLine);
                sceneWriter.write("\t;---------------------------------------------------------------------------");
                sceneWriter.write(newLine);
                if (scenes[sceneIndex].bgmName == null) {
                    sceneWriter.write("\tdc.l\t$00000000");
                } else {
                    sceneWriter.write("\tdc.l\t" + scenes[sceneIndex].bgmName + " ; location of background music");
                }
                sceneWriter.write(newLine);
                String includePathRel = PathResolver.getRelativePath(includeFilePath, outputFilePath);
                if (includePathRel.startsWith("..")) {
                    includePathRel = includePathRel.substring(3);
                }
                sceneWriter.flush();
                sceneWriter.close();
                StringBuffer includeString = new StringBuffer();
                String label = scenes[sceneIndex].name;
                if (labels.contains(label)) {
                    throw new Exception("BuildScenes - Duplicate label: " + label);
                }
                labels.add(label);
                includeString.append(label);
                includeString.append(":");
                includeString.append(newLine);
                includeString.append("\tinclude '");
                includeString.append(includePathRel);
                includeString.append("'");
                includeString.append(newLine);
                includeString.append(newLine);
                includeWriter.write(includeString.toString());
                StringBuilder lookupTableString = new StringBuilder();
                lookupTableString.append("\tdc.l\t");
                lookupTableString.append(scenes[sceneIndex].name);
                lookupTableString.append(newLine);
                tableWriter.write(lookupTableString.toString());
                ++sceneIndex;
            }
            tableWriter.write(newLine);
            tableWriter.write("SceneDefinitionTableEnd:");
            tableWriter.write(newLine);
            tableWriter.write(newLine);
            tableWriter.write(";-------------------------------------------------------------------------------");
            tableWriter.write(newLine);
            tableWriter.write("; scene id constants");
            tableWriter.write(newLine);
            tableWriter.write(";-------------------------------------------------------------------------------");
            tableWriter.write(newLine);
            for (Map.Entry entry : sceneIDMap.entrySet()) {
                StringBuffer constantString = new StringBuffer();
                constantString.append((String)entry.getValue());
                constantString.append("=");
                constantString.append(NumberFormatters.toHexWord((Integer)entry.getKey()));
                constantString.append(newLine);
                tableWriter.write(constantString.toString());
            }
            tableWriter.write("MAX_SCENE_ID=" + NumberFormatters.toHexWord(sceneIDMap.size() - 1));
            HashMap<Integer, String> hashMap = sceneIDMap;
            return hashMap;
        }
        catch (Exception x) {
            System.err.println("Error in BuildScenes");
            if (currentSceneName == null) {
                System.err.println("currentSceneName==null");
            } else {
                System.err.println("currentSceneName=" + currentSceneName);
            }
            if (scenePath == null) {
                System.err.println("scenePath==null");
            } else {
                System.err.println("scenePath=" + scenePath);
            }
            throw x;
        }
        finally {
            try {
                if (includeWriter != null) {
                    includeWriter.flush();
                    includeWriter.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (sceneWriter != null) {
                    sceneWriter.flush();
                    sceneWriter.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (tableWriter != null) {
                    tableWriter.flush();
                    tableWriter.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static final String buildPatternString(int offset, int palette, boolean highPriority) {
        StringBuilder patternString = new StringBuilder(Integer.toBinaryString(offset));
        while (patternString.length() < 16) {
            patternString.insert(0, '0');
        }
        if (palette == 1) {
            patternString.setCharAt(2, '1');
        } else if (palette == 2) {
            patternString.setCharAt(1, '1');
        } else if (palette == 3) {
            patternString.setCharAt(2, '1');
            patternString.setCharAt(1, '1');
        }
        if (highPriority) {
            patternString.setCharAt(0, '1');
        }
        return patternString.toString();
    }

    public static String buildRowColumnString(String rowColString) {
        if (rowColString == null) {
            rowColString = "00000000";
        }
        while (rowColString.length() < 8) {
            rowColString = "0" + rowColString;
        }
        return rowColString;
    }

    public static String buildWHXYString(int wh, int xy) {
        StringBuilder whxyString = new StringBuilder(Integer.toBinaryString(xy));
        while (whxyString.length() < 9) {
            whxyString.insert(0, '0');
        }
        whxyString.insert(0, Integer.toBinaryString(wh));
        while (whxyString.length() < 16) {
            whxyString.insert(0, '0');
        }
        return whxyString.toString();
    }
}

