/*
 * Decompiled with CFR 0.152.
 */
package com.huguesjohnson.dubbel.retailclerk.build;

import com.google.gson.Gson;
import com.huguesjohnson.dubbel.retailclerk.build.BaseBuilder;
import com.huguesjohnson.dubbel.retailclerk.build.objects.ScriptedEvent;
import com.huguesjohnson.dubbel.retailclerk.build.objects.ScriptedEventAction;
import com.huguesjohnson.dubbel.retailclerk.build.parameters.SimpleSourceDestinationParameters;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;

public class BuildScriptedEvents
extends BaseBuilder {
    public static void build(String basePath, SimpleSourceDestinationParameters parameters) throws Exception {
        OutputStreamWriter writer = null;
        ScriptedEvent[] events = null;
        int scriptedEventIndex = -1;
        int actionIndex = -1;
        ArrayList<String> labels = new ArrayList<String>();
        try {
            try {
                writer = new FileWriter(String.valueOf(basePath) + parameters.destinationFile);
                writer.write("; generated by build tools");
                writer.write(newLine);
                writer.write(newLine);
                String textJson = Files.readString(Paths.get(String.valueOf(basePath) + parameters.sourceFile, new String[0]));
                events = (ScriptedEvent[])new Gson().fromJson(textJson, ScriptedEvent[].class);
                scriptedEventIndex = 0;
                while (scriptedEventIndex < events.length) {
                    String label = events[scriptedEventIndex].name;
                    if (labels.contains(label)) {
                        throw new Exception("BuildScriptedEvents - Duplicate label: " + label);
                    }
                    labels.add(label);
                    writer.write(String.valueOf(label) + "Start:");
                    writer.write(newLine);
                    ScriptedEventAction[] actions = events[scriptedEventIndex].actions;
                    actionIndex = 0;
                    while (actionIndex < actions.length) {
                        StringBuilder sb;
                        ScriptedEventAction action = actions[actionIndex];
                        if (action.comment != null && action.comment.length() > 0) {
                            writer.write("\t; " + action.comment);
                            writer.write(newLine);
                        }
                        if (action.command != null) {
                            writer.write("\tdc.w\t" + action.command.toString());
                            writer.write(newLine);
                        }
                        if (action.direction != null) {
                            writer.write("\tdc.w\t" + action.direction.toString());
                            writer.write(newLine);
                        }
                        if (action.sceneId != null && action.sceneId.length() > 0) {
                            writer.write("\tdc.w\t" + action.sceneId);
                            writer.write(newLine);
                        }
                        if (action.intValue != null) {
                            sb = new StringBuilder(Integer.toHexString(action.intValue).toUpperCase());
                            while (sb.length() < 4) {
                                sb.insert(0, '0');
                            }
                            sb.insert(0, "\tdc.w\t$");
                            writer.write(sb.toString());
                            writer.write(newLine);
                        }
                        if (action.longValue != null) {
                            sb = new StringBuilder(Integer.toHexString(action.longValue).toUpperCase());
                            while (sb.length() < 8) {
                                sb.insert(0, '0');
                            }
                            sb.insert(0, "\tdc.l\t$");
                            writer.write(sb.toString());
                            writer.write(newLine);
                        }
                        if (action.intConst != null && action.intConst.length() > 0) {
                            writer.write("\tdc.w\t" + action.intConst);
                            writer.write(newLine);
                        }
                        if (action.label != null && action.label.length() > 0) {
                            writer.write("\tdc.l\t" + action.label);
                            writer.write(newLine);
                        }
                        ++actionIndex;
                    }
                    writer.write(String.valueOf(events[scriptedEventIndex].name) + "End:");
                    writer.write(newLine);
                    writer.write(newLine);
                    ++scriptedEventIndex;
                }
            }
            catch (Exception x) {
                System.err.println("Error in BuildScripted Events");
                System.err.println("parameters.sourceFile=" + parameters.sourceFile);
                System.err.println("parameters.destinationFile=" + parameters.destinationFile);
                if (events == null) {
                    System.err.println("events==null");
                } else {
                    System.err.println("scriptedEventIndex=" + scriptedEventIndex);
                    System.err.println("actionIndex=" + actionIndex);
                    if (scriptedEventIndex < 0) {
                        System.err.println("scriptedEventIndex<0 (which you already know)");
                    } else if (scriptedEventIndex >= events.length) {
                        System.err.println("scriptedEventIndex>=events.length");
                        System.err.println("events.length=" + events.length);
                    } else if (events[scriptedEventIndex] == null) {
                        System.err.println("events[scriptedEventIndex]==null");
                    } else {
                        System.err.println("events[scriptedEventIndex].name=" + events[scriptedEventIndex].name);
                    }
                }
                throw x;
            }
        }
        finally {
            try {
                if (writer != null) {
                    writer.flush();
                    writer.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

