/*
 * Decompiled with CFR 0.152.
 */
package com.huguesjohnson.dubbel.retailclerk.build;

import com.huguesjohnson.dubbel.file.PathResolver;
import com.huguesjohnson.dubbel.retailclerk.build.BaseBuilder;
import com.huguesjohnson.dubbel.retailclerk.build.objects.PaletteMap;
import com.huguesjohnson.dubbel.retailclerk.build.objects.Sprite;
import com.huguesjohnson.dubbel.retailclerk.build.parameters.SpriteParameters;
import com.huguesjohnson.dubbel.util.GenesisColorUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import javax.imageio.ImageIO;

public abstract class BuildSprites
extends BaseBuilder {
    public static void build(String basePath, SpriteParameters sprites, HashMap<String, PaletteMap> paletteMap) throws Exception {
        PaletteMap palette = paletteMap.get(sprites.palette);
        int id = Integer.parseInt(sprites.baseId, 16);
        OutputStreamWriter includeWriter = null;
        OutputStreamWriter definitionWriter = null;
        OutputStreamWriter constantWriter = null;
        OutputStreamWriter tileWriter = null;
        Sprite currentSprite = null;
        ArrayList<String> spriteNames = new ArrayList<String>();
        try {
            try {
                String includeFilePath = String.valueOf(basePath) + sprites.includeFilePath;
                includeWriter = new FileWriter(includeFilePath);
                includeWriter.write("; generated by build tools");
                includeWriter.write(newLine);
                includeWriter.write(newLine);
                String definitionFilePath = String.valueOf(basePath) + sprites.characterDefinitionFilePath;
                definitionWriter = new FileWriter(definitionFilePath);
                definitionWriter.write("; generated by build tools");
                definitionWriter.write(newLine);
                definitionWriter.write(newLine);
                definitionWriter.write("CharacterDefinitionStart:");
                definitionWriter.write(newLine);
                definitionWriter.write(newLine);
                String constantFilePath = String.valueOf(basePath) + sprites.constantDefinitionPath;
                constantWriter = new FileWriter(constantFilePath);
                constantWriter.write("; generated by build tools");
                constantWriter.write(newLine);
                constantWriter.write(newLine);
                constantWriter.write("OBJ_NPC_BASE=$" + sprites.baseId.toUpperCase());
                constantWriter.write(newLine);
                int i = 0;
                while (i < sprites.sprites.length) {
                    ++id;
                    currentSprite = sprites.sprites[i];
                    String spriteName = currentSprite.name.replace(" ", "");
                    if (spriteNames.contains(spriteName)) {
                        throw new Exception("BuildSprites - Duplicate sprite name: " + spriteName);
                    }
                    spriteNames.add(spriteName);
                    String hexId = Integer.toHexString(id);
                    String sourceFilePath = String.valueOf(basePath) + currentSprite.sourceFilePath;
                    String outputFilePath = String.valueOf(basePath) + currentSprite.destinationFilePath;
                    tileWriter = new FileWriter(outputFilePath);
                    tileWriter.write("; generated by build tools");
                    tileWriter.write(newLine);
                    tileWriter.write(newLine);
                    File sourceFile = new File(sourceFilePath);
                    BufferedImage image = ImageIO.read(sourceFile);
                    int width = image.getWidth();
                    if (width % 8 != 0) {
                        throw new Exception("Image width must be a multiple of 8");
                    }
                    int height = image.getHeight();
                    if (height % 8 != 0) {
                        throw new Exception("Image width must be a multiple of 8");
                    }
                    int totalFrames = 12;
                    int currentFrame = 0;
                    while (currentFrame < totalFrames) {
                        tileWriter.write(newLine);
                        tileWriter.write(String.valueOf(spriteName) + "_Frame" + currentFrame + "Start:");
                        tileWriter.write(newLine);
                        tileWriter.write(newLine);
                        int col = 0;
                        while (col <= 1) {
                            int row = 0;
                            while (row <= 3) {
                                int y = 0;
                                while (y < 8) {
                                    StringBuffer line = new StringBuffer();
                                    line.append("\tdc.l\t$");
                                    int x = 0;
                                    while (x < 8) {
                                        int pixelX = col * 8 + x;
                                        int pixelY = row * 8 + currentFrame * 32 + y;
                                        int color = image.getRGB(pixelX, pixelY);
                                        String hexString = Integer.toHexString(color |= 0xFF000000);
                                        int index = GenesisColorUtil.findNearestColor(palette.colorsHex, hexString);
                                        line.append(Integer.toHexString(index).toUpperCase());
                                        ++x;
                                    }
                                    line.append(newLine);
                                    tileWriter.write(line.toString());
                                    ++y;
                                }
                                tileWriter.write(newLine);
                                ++row;
                            }
                            ++col;
                        }
                        tileWriter.write(String.valueOf(spriteName) + "_Frame" + currentFrame + "End:");
                        tileWriter.write(newLine);
                        ++currentFrame;
                    }
                    tileWriter.flush();
                    tileWriter.close();
                    StringBuffer constLine = new StringBuffer("OBJ_NPC_");
                    constLine.append(spriteName.toUpperCase());
                    constLine.append("=$");
                    constLine.append(hexId.toUpperCase());
                    constLine.append(newLine);
                    constantWriter.write(constLine.toString());
                    String includePathRel = PathResolver.getRelativePath(includeFilePath, outputFilePath);
                    if (includePathRel.startsWith("..")) {
                        includePathRel = includePathRel.substring(3);
                    }
                    StringBuffer includeString = new StringBuffer();
                    String label = String.valueOf(spriteName) + "SpriteTiles";
                    includeString.append(label);
                    includeString.append("Start:");
                    includeString.append(newLine);
                    includeString.append("\tinclude '");
                    includeString.append(includePathRel);
                    includeString.append("'");
                    includeString.append(newLine);
                    includeString.append(label);
                    includeString.append("End:");
                    includeString.append(newLine);
                    includeString.append(newLine);
                    includeWriter.write(includeString.toString());
                    StringBuffer line = new StringBuffer("; ");
                    line.append(hexId);
                    line.append(" - ");
                    line.append(currentSprite.name);
                    line.append(newLine);
                    definitionWriter.write(line.toString());
                    line = new StringBuffer("CharacterDefinition");
                    line.append(spriteName);
                    line.append("Start:");
                    line.append(newLine);
                    definitionWriter.write(line.toString());
                    line = new StringBuffer("\tdc.l\t");
                    line.append(spriteName);
                    line.append("SpriteTilesStart");
                    line.append(newLine);
                    definitionWriter.write(line.toString());
                    line = new StringBuffer("CharacterDefinition");
                    line.append(spriteName);
                    line.append("End:");
                    line.append(newLine);
                    line.append(newLine);
                    definitionWriter.write(line.toString());
                    line = new StringBuffer("\tdc.l\t");
                    line.append("CharacterName");
                    line.append(spriteName);
                    line.append(newLine);
                    line = new StringBuffer("CharacterName");
                    line.append(spriteName);
                    line.append(":");
                    line.append(newLine);
                    line.append("\tdc.b\t\"");
                    line.append(currentSprite.name);
                    line.append("\",NPCNAMEEND");
                    line.append(newLine);
                    line.append(newLine);
                    ++i;
                }
                definitionWriter.write("CharacterDefinitionEnd:");
                definitionWriter.write(newLine);
            }
            catch (Exception x) {
                if (currentSprite == null) {
                    System.err.println("Error in BuildSprites - currentSprite==null");
                } else {
                    System.err.println("Error in BuildSprites - currentSprite.name=" + currentSprite.name);
                }
                throw x;
            }
        }
        finally {
            try {
                if (includeWriter != null) {
                    includeWriter.flush();
                    includeWriter.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (definitionWriter != null) {
                    definitionWriter.flush();
                    definitionWriter.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (constantWriter != null) {
                    constantWriter.flush();
                    constantWriter.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (tileWriter != null) {
                    tileWriter.flush();
                    tileWriter.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

