/*
 * Decompiled with CFR 0.152.
 */
package com.huguesjohnson.dubbel.retailclerk.build;

import com.google.gson.Gson;
import com.huguesjohnson.dubbel.retailclerk.build.BaseBuilder;
import com.huguesjohnson.dubbel.retailclerk.build.objects.StringCollection;
import com.huguesjohnson.dubbel.retailclerk.build.objects.TextLine;
import com.huguesjohnson.dubbel.retailclerk.build.parameters.TextParameters;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;

public class BuildText
extends BaseBuilder {
    public static void build(String basePath, TextParameters parameters) throws Exception {
        OutputStreamWriter tableFileWriter = null;
        OutputStreamWriter textFileWriter = null;
        StringCollection stringCollection = null;
        TextLine textLine = null;
        ArrayList<String> tableNames = new ArrayList<String>();
        ArrayList<String> keys = new ArrayList<String>();
        try {
            try {
                tableFileWriter = new FileWriter(String.valueOf(basePath) + parameters.tableFilePath);
                tableFileWriter.write("; generated by build tools");
                tableFileWriter.write(newLine);
                textFileWriter = new FileWriter(String.valueOf(basePath) + parameters.textFilePath);
                textFileWriter.write("; generated by build tools");
                textFileWriter.write(newLine);
                int fileIndex = 0;
                while (fileIndex < parameters.filePaths.length) {
                    String textJson = Files.readString(Paths.get(String.valueOf(basePath) + parameters.filePaths[fileIndex], new String[0]));
                    stringCollection = (StringCollection)new Gson().fromJson(textJson, StringCollection.class);
                    boolean skipTable = false;
                    if (stringCollection.skipTable != null && stringCollection.skipTable.equals("true")) {
                        skipTable = true;
                    }
                    if (!skipTable) {
                        tableFileWriter.write(newLine);
                        tableFileWriter.write(";-------------------------------------------------------------------------------");
                        tableFileWriter.write(newLine);
                        tableFileWriter.write("; " + stringCollection.name);
                        tableFileWriter.write(newLine);
                        if (stringCollection.description != null && stringCollection.description.length() > 0) {
                            tableFileWriter.write("; " + stringCollection.description);
                            tableFileWriter.write(newLine);
                        }
                        tableFileWriter.write(";-------------------------------------------------------------------------------");
                        tableFileWriter.write(newLine);
                        String tableName = stringCollection.name;
                        if (tableNames.contains(tableName)) {
                            throw new Exception("BuildText - Duplicate table name: " + tableName);
                        }
                        tableNames.add(tableName);
                        tableFileWriter.write(String.valueOf(tableName) + "TableStart:");
                        tableFileWriter.write(newLine);
                    }
                    textFileWriter.write(newLine);
                    textFileWriter.write(";-------------------------------------------------------------------------------");
                    textFileWriter.write(newLine);
                    textFileWriter.write("; " + stringCollection.name);
                    textFileWriter.write(newLine);
                    if (stringCollection.description != null && stringCollection.description.length() > 0) {
                        textFileWriter.write("; " + stringCollection.description);
                        textFileWriter.write(newLine);
                    }
                    textFileWriter.write(";-------------------------------------------------------------------------------");
                    textFileWriter.write(newLine);
                    boolean realign = false;
                    for (String key : stringCollection.lines.keySet()) {
                        String text;
                        char nextPageChar;
                        textLine = stringCollection.lines.get(key);
                        String terminator = stringCollection.defaultTerminator;
                        if (textLine.terminator != null && textLine.terminator.length() > 0) {
                            terminator = textLine.terminator;
                        }
                        String lineFeed = stringCollection.defaultLineFeed;
                        if (textLine.lineFeed != null && textLine.lineFeed.length() > 0) {
                            lineFeed = textLine.lineFeed;
                        }
                        String formFeed = stringCollection.defaultFormFeed;
                        if (textLine.formFeed != null && textLine.formFeed.length() > 0) {
                            formFeed = textLine.formFeed;
                        }
                        if (textLine.nextPageChar != (nextPageChar = stringCollection.defaultNextPageChar)) {
                            nextPageChar = textLine.nextPageChar;
                        }
                        if (!skipTable) {
                            tableFileWriter.write("\tdc.l\t" + key);
                            tableFileWriter.write(newLine);
                        }
                        if (realign) {
                            textFileWriter.write("\talign 2");
                            textFileWriter.write(newLine);
                            realign = false;
                        }
                        if (textLine.comment != null && textLine.comment.length() > 0) {
                            textFileWriter.write("; " + textLine.comment);
                            textFileWriter.write(newLine);
                        }
                        if (keys.contains(key)) {
                            throw new Exception("BuildText - Duplicate key (label really): " + key);
                        }
                        keys.add(key);
                        textFileWriter.write(String.valueOf(key) + ":");
                        textFileWriter.write(newLine);
                        if (textLine.dialogTitle != null && textLine.dialogTitle.length() > 0) {
                            realign = true;
                            textFileWriter.write("\tdc.w\t" + textLine.dialogTitle);
                            textFileWriter.write(newLine);
                        }
                        if ((text = textLine.text).length() <= 0) continue;
                        StringBuffer sb = new StringBuffer(text);
                        int lineCount = 0;
                        while (sb.length() > stringCollection.lineLength) {
                            int lastIndex = sb.substring(0, stringCollection.lineLength).indexOf(stringCollection.defaultLineBreakChar);
                            if (lastIndex < 1) {
                                lastIndex = sb.substring(0, stringCollection.lineLength).lastIndexOf(32);
                            }
                            if (lastIndex < 1) {
                                lastIndex = stringCollection.lineLength;
                            }
                            if (lineCount < stringCollection.formLines) {
                                textFileWriter.write("\tdc.b\t\"" + sb.substring(0, lastIndex) + "\",");
                                textFileWriter.write(lineFeed);
                                ++lineCount;
                            } else {
                                StringBuffer subSb = new StringBuffer(sb.substring(0, lastIndex));
                                subSb.append(nextPageChar);
                                textFileWriter.write("\tdc.b\t\"" + subSb.toString() + "\",");
                                textFileWriter.write(formFeed);
                                lineCount = 0;
                            }
                            textFileWriter.write(newLine);
                            sb.delete(0, lastIndex);
                            while (sb.length() > 0 && (sb.charAt(0) == ' ' || sb.charAt(0) == stringCollection.defaultLineBreakChar)) {
                                sb.deleteCharAt(0);
                            }
                        }
                        textFileWriter.write("\tdc.b\t\"" + sb.toString() + "\"," + terminator);
                        textFileWriter.write(newLine);
                    }
                    if (realign) {
                        textFileWriter.write("\talign 2");
                        textFileWriter.write(newLine);
                    }
                    if (!skipTable) {
                        tableFileWriter.write(String.valueOf(stringCollection.name) + "TableEnd:");
                        tableFileWriter.write(newLine);
                    }
                    ++fileIndex;
                }
                textFileWriter.write(newLine);
                textFileWriter.write("\talign 2");
            }
            catch (Exception x) {
                System.err.println("Error in BuildText");
                if (stringCollection == null) {
                    System.err.println("stringCollection==null");
                } else {
                    System.err.println("stringCollection.name=" + stringCollection.name);
                    if (textLine != null) {
                        System.err.println("textLine.text=" + textLine.text);
                    }
                }
                throw x;
            }
        }
        finally {
            try {
                if (tableFileWriter != null) {
                    tableFileWriter.flush();
                    tableFileWriter.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (textFileWriter != null) {
                    textFileWriter.flush();
                    textFileWriter.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

