/*
 * Decompiled with CFR 0.152.
 */
package com.huguesjohnson.dubbel.retailclerk.build;

import com.huguesjohnson.dubbel.file.PathResolver;
import com.huguesjohnson.dubbel.retailclerk.build.BaseBuilder;
import com.huguesjohnson.dubbel.retailclerk.build.objects.PaletteMap;
import com.huguesjohnson.dubbel.retailclerk.build.objects.Tile8x8;
import com.huguesjohnson.dubbel.retailclerk.build.objects.Tileset;
import com.huguesjohnson.dubbel.retailclerk.build.parameters.TilesetParameters;
import com.huguesjohnson.dubbel.util.GenesisColorUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import javax.imageio.ImageIO;

public class BuildTiles
extends BaseBuilder {
    public static HashMap<String, Tileset> build(String basePath, TilesetParameters tiles, HashMap<String, PaletteMap> paletteMap) throws Exception {
        HashMap<String, Tileset> returnMap = new HashMap<String, Tileset>();
        OutputStreamWriter tileIncludeWriter = null;
        OutputStreamWriter tileWriter = null;
        OutputStreamWriter patternWriter = null;
        OutputStreamWriter patternIncludeWriter = null;
        Tileset currentEntry = null;
        int row = -1;
        int col = -1;
        try {
            String tileIncludeFilePath = String.valueOf(basePath) + tiles.tileIncludeFilePath;
            tileIncludeWriter = new FileWriter(tileIncludeFilePath);
            tileIncludeWriter.write("; generated by build tools");
            tileIncludeWriter.write(newLine);
            tileIncludeWriter.write(newLine);
            String patternIncludeFilePath = String.valueOf(basePath) + tiles.patternIncludeFilePath;
            patternIncludeWriter = new FileWriter(patternIncludeFilePath);
            patternIncludeWriter.write("; generated by build tools");
            patternIncludeWriter.write(newLine);
            patternIncludeWriter.write(newLine);
            Tileset[] tilesetArray = tiles.tilesets;
            int n = tiles.tilesets.length;
            int n2 = 0;
            while (n2 < n) {
                String sourceFilePath;
                File sourceFile;
                BufferedImage image;
                int width;
                Tileset entry;
                currentEntry = entry = tilesetArray[n2];
                PaletteMap palette = paletteMap.get(entry.palette);
                if (palette == null) {
                    throw new Exception("Palette [" + entry.palette + "] not found.");
                }
                boolean allowDuplicateTiles = false;
                if (entry.allowDuplicateTiles != null && entry.allowDuplicateTiles.equalsIgnoreCase("TRUE")) {
                    allowDuplicateTiles = true;
                }
                boolean createPattern = false;
                if (entry.patternFilePath != null && !entry.patternFilePath.isBlank()) {
                    createPattern = true;
                }
                String tileOutputPath = String.valueOf(basePath) + entry.destinationFilePath;
                tileWriter = new FileWriter(tileOutputPath);
                tileWriter.write("; generated by build tools");
                tileWriter.write(newLine);
                tileWriter.write(newLine);
                String patternOutputPath = null;
                if (createPattern) {
                    patternOutputPath = String.valueOf(basePath) + entry.patternFilePath;
                    patternWriter = new FileWriter(patternOutputPath);
                }
                if ((width = (image = ImageIO.read(sourceFile = new File(sourceFilePath = String.valueOf(basePath) + entry.sourceFilePath))).getWidth()) % 8 != 0) {
                    throw new Exception("Image width must be a multiple of 8 - sourceFile=" + sourceFile);
                }
                int height = image.getHeight();
                if (height % 8 != 0) {
                    throw new Exception("Image width must be a multiple of 8 - sourceFile=" + sourceFile);
                }
                if (createPattern) {
                    patternWriter.write("; generated by build tools");
                    StringBuilder patternName = new StringBuilder();
                    patternWriter.write(newLine);
                    patternName.append("Pattern");
                    patternName.append(entry.name);
                    patternName.append(":");
                    patternName.append(newLine);
                    patternWriter.write(patternName.toString());
                    int rowCount = height / 8;
                    patternWriter.write("\tdc.w\t$" + Integer.toHexString(rowCount - 1).toUpperCase() + "\t; " + rowCount + " rows");
                    patternWriter.write(newLine);
                    int colCount = width / 8;
                    patternWriter.write("\tdc.w\t$" + Integer.toHexString(colCount - 1).toUpperCase() + "\t; " + colCount + " columns");
                    patternWriter.write(newLine);
                }
                ArrayList<Tile8x8> uniqueTiles = new ArrayList<Tile8x8>();
                row = 0;
                while (row < height) {
                    col = 0;
                    while (col < width) {
                        Tile8x8 tile8x8 = new Tile8x8();
                        int x = col;
                        while (x < col + 8) {
                            int y = row;
                            while (y < row + 8) {
                                int index;
                                int color = image.getRGB(x, y);
                                String hexString = Integer.toHexString(color);
                                tile8x8.pixels[y - row][x - col] = index = GenesisColorUtil.findNearestColor(palette.colorsHex, hexString);
                                ++y;
                            }
                            ++x;
                        }
                        int tileIndex = -1;
                        boolean addTile = allowDuplicateTiles;
                        if (!addTile) {
                            tileIndex = uniqueTiles.indexOf(tile8x8);
                            boolean bl = addTile = tileIndex < 0;
                        }
                        if (addTile) {
                            uniqueTiles.add(tile8x8);
                            tileIndex = uniqueTiles.size() - 1;
                            String indexStr = "\t; " + Integer.toHexString(tileIndex).toUpperCase();
                            tileWriter.write(indexStr);
                            tileWriter.write(newLine);
                            tileWriter.write(tile8x8.toAsmLines());
                            tileWriter.write(newLine);
                        }
                        if (createPattern) {
                            patternWriter.write("\tdc.w\t$" + Integer.toHexString(tileIndex).toUpperCase());
                            patternWriter.write(newLine);
                        }
                        col += 8;
                    }
                    row += 8;
                }
                String includePathRel = PathResolver.getRelativePath(tileIncludeFilePath, tileOutputPath);
                if (includePathRel.startsWith("..")) {
                    includePathRel = includePathRel.substring("..".length() + 1);
                }
                StringBuffer includeString = new StringBuffer();
                includeString.append(entry.name);
                includeString.append("TilesStart:");
                includeString.append(newLine);
                includeString.append("\tinclude '");
                includeString.append(includePathRel);
                includeString.append("'");
                includeString.append(newLine);
                includeString.append(entry.name);
                includeString.append("TilesEnd:");
                includeString.append(newLine);
                includeString.append(newLine);
                tileIncludeWriter.write(includeString.toString());
                tileWriter.flush();
                tileWriter.close();
                if (createPattern) {
                    includePathRel = PathResolver.getRelativePath(patternIncludeFilePath, patternOutputPath);
                    if (includePathRel.startsWith("..")) {
                        includePathRel = includePathRel.substring(3);
                    }
                    includeString = new StringBuffer();
                    includeString.append("\tinclude '");
                    includeString.append(includePathRel);
                    includeString.append("'");
                    includeString.append(newLine);
                    includeString.append(newLine);
                    patternIncludeWriter.write(includeString.toString());
                    patternWriter.flush();
                    patternWriter.close();
                }
                entry.tiles = uniqueTiles;
                returnMap.put(entry.name, entry);
                ++n2;
            }
            HashMap<String, Tileset> hashMap = returnMap;
            return hashMap;
        }
        catch (Exception x) {
            if (currentEntry == null) {
                System.err.println("Error in BuildTiles - currentEntry==null");
            } else {
                System.err.println("Error in BuildTiles - currentEntry.name=" + currentEntry.name);
            }
            System.err.println("row=" + row);
            System.err.println("col=" + col);
            throw x;
        }
        finally {
            try {
                if (tileIncludeWriter != null) {
                    tileIncludeWriter.flush();
                    tileIncludeWriter.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (patternIncludeWriter != null) {
                    patternIncludeWriter.flush();
                    patternIncludeWriter.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (tileWriter != null) {
                    tileWriter.flush();
                    tileWriter.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (patternWriter != null) {
                    patternWriter.flush();
                    patternWriter.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

