/*
 * Decompiled with CFR 0.152.
 */
package com.huguesjohnson.dubbel.retailclerk.build;

import com.google.gson.Gson;
import com.huguesjohnson.dubbel.file.PathResolver;
import com.huguesjohnson.dubbel.retailclerk.build.BuildActionTable;
import com.huguesjohnson.dubbel.retailclerk.build.BuildCollisionData;
import com.huguesjohnson.dubbel.retailclerk.build.BuildConstants;
import com.huguesjohnson.dubbel.retailclerk.build.BuildHeader;
import com.huguesjohnson.dubbel.retailclerk.build.BuildMemoryMap;
import com.huguesjohnson.dubbel.retailclerk.build.BuildMovementPatterns;
import com.huguesjohnson.dubbel.retailclerk.build.BuildPalette;
import com.huguesjohnson.dubbel.retailclerk.build.BuildPatternsFromTilesets;
import com.huguesjohnson.dubbel.retailclerk.build.BuildScenes;
import com.huguesjohnson.dubbel.retailclerk.build.BuildScriptedEvents;
import com.huguesjohnson.dubbel.retailclerk.build.BuildSprites;
import com.huguesjohnson.dubbel.retailclerk.build.BuildText;
import com.huguesjohnson.dubbel.retailclerk.build.BuildTiles;
import com.huguesjohnson.dubbel.retailclerk.build.objects.BuildInstructions;
import com.huguesjohnson.dubbel.retailclerk.build.objects.PaletteMap;
import com.huguesjohnson.dubbel.retailclerk.build.objects.Tileset;
import com.huguesjohnson.dubbel.util.DateUtil;
import com.huguesjohnson.dubbel.util.ZipUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;

public class MainBuild {
    public static void main(String[] args) {
        try {
            int i;
            if (args == null || args.length == 0) {
                throw new Exception("No build file specified, how about you try including one.");
            }
            String json = Files.readString(Paths.get(args[0], new String[0]));
            BuildInstructions instructions = (BuildInstructions)new Gson().fromJson(json, BuildInstructions.class);
            String basePath = instructions.basePath;
            if (basePath.startsWith(".")) {
                String localPath = null;
                int index = args[0].lastIndexOf(File.separator);
                localPath = index < 0 ? System.getProperty("user.dir") : args[0].substring(0, index);
                if (!localPath.endsWith(File.separator)) {
                    localPath = String.valueOf(localPath) + File.separator;
                }
                if (!(basePath = PathResolver.getAbsolutePath(localPath, basePath)).endsWith(File.separator)) {
                    basePath = String.valueOf(basePath) + File.separator;
                }
            }
            if (instructions.backupPath != null && instructions.backupPath.length() > 0) {
                File f;
                boolean backupPathExists;
                String fullBackupPath = PathResolver.getAbsolutePath(basePath, instructions.backupPath);
                if (!fullBackupPath.endsWith(File.separator)) {
                    fullBackupPath = String.valueOf(fullBackupPath) + File.separator;
                }
                if (!(backupPathExists = (f = new File(fullBackupPath)).exists())) {
                    backupPathExists = f.mkdirs();
                }
                if (backupPathExists) {
                    int index = basePath.lastIndexOf(File.separator, basePath.length() - 2) + 1;
                    String name = basePath.substring(index, basePath.length() - 1);
                    String now = DateUtil.now(DateUtil.DF_YearMonthDayHourMinuteSecondMillisecond);
                    name = String.valueOf(name) + "_" + now + ".tar.gz";
                    String command = "tar --exclude='" + name + "' " + " --exclude='*.git' -zcvf " + name + " " + ".";
                    ProcessBuilder pb = new ProcessBuilder("sh", "-c", command);
                    pb.directory(new File(basePath));
                    Process p = pb.start();
                    p.waitFor();
                    BufferedReader sErr = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                    String line = null;
                    while ((line = sErr.readLine()) != null) {
                        System.out.println(line);
                    }
                    command = "mv -v '" + name + "' '" + fullBackupPath + "'";
                    pb = new ProcessBuilder("sh", "-c", command);
                    pb.directory(new File(basePath));
                    p = pb.start();
                    p.waitFor();
                    sErr = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                    line = null;
                    while ((line = sErr.readLine()) != null) {
                        System.out.println(line);
                    }
                }
            } else {
                System.out.println("backupPath not defined, skipping task.");
            }
            if (instructions.memoryMap != null) {
                BuildMemoryMap.build(basePath, instructions.memoryMap);
            } else {
                System.out.println("memoryMap not defined, skipping task.");
            }
            if (instructions.constants != null) {
                BuildConstants.build(basePath, instructions.constants);
            } else {
                System.out.println("constants not defined, skipping task.");
            }
            if (instructions.collision != null) {
                BuildCollisionData.build(basePath, instructions.collision);
            } else {
                System.out.println("collision not defined, skipping task.");
            }
            if (instructions.scriptedEvents != null) {
                BuildScriptedEvents.build(basePath, instructions.scriptedEvents);
            } else {
                System.out.println("scriptedEvents not defined, skipping task.");
            }
            HashMap<String, PaletteMap> paletteMap = new HashMap();
            if (instructions.palettes != null) {
                paletteMap = BuildPalette.build(basePath, instructions.palettes);
            } else {
                System.out.println("palettes not defined, skipping task.");
            }
            HashMap<String, Tileset> tileMap = new HashMap();
            if (instructions.tiles != null) {
                tileMap = BuildTiles.build(basePath, instructions.tiles, paletteMap);
            } else {
                System.out.println("tiles not defined, skipping task.");
            }
            if (instructions.patterns != null) {
                BuildPatternsFromTilesets.build(basePath, instructions.patterns, tileMap, paletteMap);
            } else {
                System.out.println("patterns not defined, skipping task.");
            }
            if (instructions.movementPatterns != null) {
                BuildMovementPatterns.build(basePath, instructions.movementPatterns);
            } else {
                System.out.println("movementPatterns not defined, skipping task.");
            }
            if (instructions.sprites != null) {
                BuildSprites.build(basePath, instructions.sprites, paletteMap);
            } else {
                System.out.println("sprites not defined, skipping task.");
            }
            HashMap<Integer, String> sceneIDMap = new HashMap();
            if (instructions.scenes != null) {
                sceneIDMap = BuildScenes.build(basePath, instructions.scenes, tileMap);
            } else {
                System.out.println("scenes not defined, skipping task.");
            }
            if (instructions.text != null) {
                BuildText.build(basePath, instructions.text);
            } else {
                System.out.println("text not defined, skipping task.");
            }
            if (instructions.actionTable != null) {
                BuildActionTable.build(basePath, instructions.actionTable, sceneIDMap);
            } else {
                System.out.println("actionTable not defined, skipping task.");
            }
            if (instructions.header != null) {
                BuildHeader.build(basePath, instructions.header);
            } else {
                System.out.println("header not defined, skipping task.");
            }
            if (instructions.assembly != null) {
                i = 0;
                while (i < instructions.assembly.length) {
                    ProcessBuilder pb = new ProcessBuilder("sh", "-c", instructions.assembly[i].arguments);
                    pb.directory(new File(String.valueOf(basePath) + instructions.assembly[i].assemblerPath));
                    Process p = pb.start();
                    p.waitFor();
                    BufferedReader sErr = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                    String line = null;
                    while ((line = sErr.readLine()) != null) {
                        System.out.println(line);
                    }
                    ++i;
                }
            } else {
                System.out.println("assembly not defined, skipping task.");
            }
            if (instructions.packageParameters != null) {
                i = 0;
                while (i < instructions.packageParameters.length) {
                    ZipUtil.zip(basePath, instructions.packageParameters[i].includeFilePaths, instructions.packageParameters[i].packagePath);
                    ++i;
                }
            } else {
                System.out.println("package not defined, skipping task.");
            }
            System.out.println("Build finished, have a nice day or whatever.");
        }
        catch (Exception x) {
            System.err.println("\nFatal build error: " + x.getMessage() + "\n");
            x.printStackTrace();
        }
    }
}

