/*
 * Decompiled with CFR 0.152.
 */
package com.huguesjohnson.dubbel.retailclerk.build.test;

import com.google.gson.Gson;
import com.huguesjohnson.dubbel.retailclerk.build.BuildScenes;
import com.huguesjohnson.dubbel.retailclerk.build.objects.ActionTableEntry;
import com.huguesjohnson.dubbel.retailclerk.build.objects.BuildInstructions;
import com.huguesjohnson.dubbel.retailclerk.build.objects.PaletteMap;
import com.huguesjohnson.dubbel.retailclerk.build.objects.PatternFromTileset;
import com.huguesjohnson.dubbel.retailclerk.build.objects.Sprite;
import com.huguesjohnson.dubbel.retailclerk.build.objects.Tileset;
import com.huguesjohnson.dubbel.retailclerk.build.parameters.ActionTableParameters;
import com.huguesjohnson.dubbel.retailclerk.build.parameters.AssemblyParameters;
import com.huguesjohnson.dubbel.retailclerk.build.parameters.CollisionDataParameters;
import com.huguesjohnson.dubbel.retailclerk.build.parameters.ConstantFileParameters;
import com.huguesjohnson.dubbel.retailclerk.build.parameters.HeaderParameters;
import com.huguesjohnson.dubbel.retailclerk.build.parameters.MemoryMapParameters;
import com.huguesjohnson.dubbel.retailclerk.build.parameters.PackageParameters;
import com.huguesjohnson.dubbel.retailclerk.build.parameters.PaletteParameters;
import com.huguesjohnson.dubbel.retailclerk.build.parameters.PatternFromTilesetParameters;
import com.huguesjohnson.dubbel.retailclerk.build.parameters.SceneParameters;
import com.huguesjohnson.dubbel.retailclerk.build.parameters.SimpleSourceDestinationParameters;
import com.huguesjohnson.dubbel.retailclerk.build.parameters.SpriteParameters;
import com.huguesjohnson.dubbel.retailclerk.build.parameters.TextParameters;
import com.huguesjohnson.dubbel.retailclerk.build.parameters.TilesetParameters;
import com.huguesjohnson.dubbel.util.GenesisColorUtil;
import com.huguesjohnson.dubbel.util.NumberFormatters;
import java.util.ArrayList;
import java.util.HashMap;
import junit.framework.TestCase;
import org.junit.jupiter.api.Test;

class TestBuildStuff
extends TestCase {
    TestBuildStuff() {
    }

    @Test
    void testColorUtils() {
        String s = GenesisColorUtil.hexStringToGenesisRgb("ff");
        TestBuildStuff.assertEquals((String)"111", (String)s);
        s = GenesisColorUtil.rgbStringToGenesisRgbString("ffe0a040");
        TestBuildStuff.assertEquals((String)"0000010010101110", (String)s);
        s = GenesisColorUtil.genesisRgbStringToHexString("%" + s);
        TestBuildStuff.assertEquals((String)"ffe0a040", (String)s);
        s = GenesisColorUtil.genesisRgbStringToHexString("dc.w\t%0000010010101110 ; blah1075872328");
        TestBuildStuff.assertEquals((String)"ffe0a040", (String)s);
        ArrayList<String> colors = new ArrayList<String>();
        colors.add("ffe000e0");
        colors.add("ff000000");
        colors.add("ff806440");
        colors.add("ffe0c8a0");
        colors.add("ff80a8c0");
        colors.add("ff604020");
        colors.add("ffc0a880");
        colors.add("ffa06420");
        colors.add("ff608440");
        colors.add("ff802080");
        colors.add("ffc0c8c0");
        colors.add("ffc06420");
        colors.add("ffc00000");
        colors.add("ffe0e8e0");
        colors.add("ffe0c820");
        colors.add("ff6084a0");
        TestBuildStuff.assertEquals((int)0, (int)GenesisColorUtil.findNearestColor(colors, "ffe000e0"));
        TestBuildStuff.assertEquals((int)1, (int)GenesisColorUtil.findNearestColor(colors, "ff000000"));
        TestBuildStuff.assertEquals((int)2, (int)GenesisColorUtil.findNearestColor(colors, "ff806440"));
        TestBuildStuff.assertEquals((int)3, (int)GenesisColorUtil.findNearestColor(colors, "ffe0c8a0"));
        TestBuildStuff.assertEquals((int)4, (int)GenesisColorUtil.findNearestColor(colors, "ff80a8c0"));
        TestBuildStuff.assertEquals((int)5, (int)GenesisColorUtil.findNearestColor(colors, "ff604020"));
        TestBuildStuff.assertEquals((int)6, (int)GenesisColorUtil.findNearestColor(colors, "ffc0a880"));
        TestBuildStuff.assertEquals((int)7, (int)GenesisColorUtil.findNearestColor(colors, "ffa06420"));
        TestBuildStuff.assertEquals((int)8, (int)GenesisColorUtil.findNearestColor(colors, "ff608440"));
        TestBuildStuff.assertEquals((int)9, (int)GenesisColorUtil.findNearestColor(colors, "ff802080"));
        TestBuildStuff.assertEquals((int)10, (int)GenesisColorUtil.findNearestColor(colors, "ffc0c8c0"));
        TestBuildStuff.assertEquals((int)11, (int)GenesisColorUtil.findNearestColor(colors, "ffc06420"));
        TestBuildStuff.assertEquals((int)12, (int)GenesisColorUtil.findNearestColor(colors, "ffc00000"));
        TestBuildStuff.assertEquals((int)13, (int)GenesisColorUtil.findNearestColor(colors, "ffe0e8e0"));
        TestBuildStuff.assertEquals((int)14, (int)GenesisColorUtil.findNearestColor(colors, "ffe0c820"));
        TestBuildStuff.assertEquals((int)15, (int)GenesisColorUtil.findNearestColor(colors, "ff6084a0"));
        TestBuildStuff.assertEquals((int)0, (int)GenesisColorUtil.findNearestColor(colors, "ffe000e8"));
        TestBuildStuff.assertEquals((int)1, (int)GenesisColorUtil.findNearestColor(colors, "ff200000"));
        TestBuildStuff.assertEquals((int)2, (int)GenesisColorUtil.findNearestColor(colors, "ff806040"));
        TestBuildStuff.assertEquals((int)3, (int)GenesisColorUtil.findNearestColor(colors, "ffe0c0a0"));
        TestBuildStuff.assertEquals((int)4, (int)GenesisColorUtil.findNearestColor(colors, "ff80a0c0"));
        TestBuildStuff.assertEquals((int)5, (int)GenesisColorUtil.findNearestColor(colors, "ff602020"));
        TestBuildStuff.assertEquals((int)6, (int)GenesisColorUtil.findNearestColor(colors, "ffa0a880"));
        TestBuildStuff.assertEquals((int)7, (int)GenesisColorUtil.findNearestColor(colors, "ffa06400"));
        TestBuildStuff.assertEquals((int)8, (int)GenesisColorUtil.findNearestColor(colors, "ff608420"));
        TestBuildStuff.assertEquals((int)9, (int)GenesisColorUtil.findNearestColor(colors, "ff800080"));
        TestBuildStuff.assertEquals((int)10, (int)GenesisColorUtil.findNearestColor(colors, "ffc0c0c0"));
        TestBuildStuff.assertEquals((int)11, (int)GenesisColorUtil.findNearestColor(colors, "ffc06820"));
        TestBuildStuff.assertEquals((int)12, (int)GenesisColorUtil.findNearestColor(colors, "ffc00020"));
        TestBuildStuff.assertEquals((int)13, (int)GenesisColorUtil.findNearestColor(colors, "ffe0e8c0"));
        TestBuildStuff.assertEquals((int)14, (int)GenesisColorUtil.findNearestColor(colors, "ffe0c800"));
        TestBuildStuff.assertEquals((int)15, (int)GenesisColorUtil.findNearestColor(colors, "ff6080a0"));
    }

    @Test
    void testToHexWord() {
        TestBuildStuff.assertEquals((String)"$0000", (String)NumberFormatters.toHexWord(0));
        TestBuildStuff.assertEquals((String)"$000D", (String)NumberFormatters.toHexWord(13));
        TestBuildStuff.assertEquals((String)"$029A", (String)NumberFormatters.toHexWord(666));
        TestBuildStuff.assertEquals((String)"$FFFF", (String)NumberFormatters.toHexWord(65535));
    }

    @Test
    void testBuildPatternString() {
        TestBuildStuff.assertEquals((String)"0000000000000001", (String)BuildScenes.buildPatternString(1, 0, false));
        TestBuildStuff.assertEquals((String)"1000000000001001", (String)BuildScenes.buildPatternString(9, 0, true));
        TestBuildStuff.assertEquals((String)"0010000000011101", (String)BuildScenes.buildPatternString(29, 1, false));
        TestBuildStuff.assertEquals((String)"1100000000101101", (String)BuildScenes.buildPatternString(45, 2, true));
        TestBuildStuff.assertEquals((String)"0110000010000010", (String)BuildScenes.buildPatternString(130, 3, false));
    }

    @Test
    void testBuildRowColumnString() {
        TestBuildStuff.assertEquals((String)"00000000", (String)BuildScenes.buildRowColumnString(null));
        TestBuildStuff.assertEquals((String)"00000000", (String)BuildScenes.buildRowColumnString("0"));
        TestBuildStuff.assertEquals((String)"03800000", (String)BuildScenes.buildRowColumnString("03800000"));
        TestBuildStuff.assertEquals((String)"03800000", (String)BuildScenes.buildRowColumnString("3800000"));
    }

    @Test
    void testBuildWHXYString() {
        TestBuildStuff.assertEquals((String)"1000111010001000", (String)BuildScenes.buildWHXYString(71, 136));
        TestBuildStuff.assertEquals((String)"0101000100001000", (String)BuildScenes.buildWHXYString(40, 264));
    }

    @Test
    void testActionTableEntry() {
        ActionTableEntry e1 = new ActionTableEntry();
        e1.action = "action1";
        e1.day = 2;
        e1.scene = "scene3";
        ActionTableEntry e2 = new ActionTableEntry();
        e2.action = "action1";
        e2.day = 2;
        e2.scene = "scene3";
        ActionTableEntry e3 = new ActionTableEntry();
        e3.action = "scene666";
        e3.day = 13;
        e3.scene = "scene8964";
        TestBuildStuff.assertTrue((boolean)e1.equals(e2));
        TestBuildStuff.assertTrue((boolean)e2.equals(e1));
        TestBuildStuff.assertTrue((e1.hashCode() == e2.hashCode() ? 1 : 0) != 0);
        TestBuildStuff.assertFalse((boolean)e1.equals(e3));
        TestBuildStuff.assertFalse((boolean)e2.equals(e3));
        TestBuildStuff.assertFalse((boolean)e3.equals(e1));
        TestBuildStuff.assertFalse((boolean)e3.equals(e2));
        TestBuildStuff.assertFalse((e1.hashCode() == e3.hashCode() ? 1 : 0) != 0);
        TestBuildStuff.assertFalse((e2.hashCode() == e3.hashCode() ? 1 : 0) != 0);
    }

    @Test
    void testBuildInstructions() {
        BuildInstructions instructions = new BuildInstructions();
        instructions.basePath = ".";
        instructions.memoryMap = new MemoryMapParameters();
        instructions.memoryMap.sourceFiles = new String[2];
        instructions.memoryMap.sourceFiles[0] = "src/MemoryMapRCBase.csv";
        instructions.memoryMap.sourceFiles[1] = "src/MemoryMapRC90.csv";
        instructions.memoryMap.destinationFile = "src/const_MemoryMap.X68";
        instructions.memoryMap.baseAddress = "FFFF0000";
        instructions.constants = new ConstantFileParameters();
        instructions.constants.includeFilePath = "src/inc_Constants.X68";
        instructions.constants.fileMap = new HashMap<String, String>();
        instructions.constants.fileMap.put("design/constants/test.csv", "src/const_test.X68");
        instructions.collision = new CollisionDataParameters();
        instructions.collision.includeFilePath = "src/inc_CollisionMaps.X68";
        instructions.collision.collisionMap = new HashMap<String, String>();
        instructions.collision.collisionMap.put("design/collision/store-00-512x512.bmp", "src/collision-maps/map_Store00Collision.X68");
        instructions.palettes = new PaletteParameters();
        instructions.palettes.includeFilePath = "src/inc_Palettes.X68";
        instructions.palettes.paletteMap = new PaletteMap[2];
        instructions.palettes.paletteMap[0] = new PaletteMap();
        instructions.palettes.paletteMap[0].sourceFilePath = "design/img/swatches/people.png";
        instructions.palettes.paletteMap[0].destinationFilePath = "src/palettes/People.X68";
        instructions.palettes.paletteMap[1] = new PaletteMap();
        instructions.palettes.paletteMap[1].sourceFilePath = "design/img/swatches/people1.png";
        instructions.palettes.paletteMap[1].destinationFilePath = "src/palettes/People1.X68";
        instructions.palettes.paletteMap[1].exclude = "true";
        instructions.tiles = new TilesetParameters();
        instructions.tiles.tileIncludeFilePath = "src/inc_SpriteTiles.X68";
        instructions.tiles.patternIncludeFilePath = "src/inc_PatternsGenerated.X68";
        instructions.tiles.tilesets = new Tileset[2];
        instructions.tiles.tilesets[0] = new Tileset();
        instructions.tiles.tilesets[0].name = "DialogFrame";
        instructions.tiles.tilesets[0].palette = "src/palettes/People.X68";
        instructions.tiles.tilesets[0].sourceFilePath = "design/img/font-dialog-tiles/frame.png";
        instructions.tiles.tilesets[0].destinationFilePath = "src/tiles/font-tiles/dialog-frame.X68";
        instructions.tiles.tilesets[1] = new Tileset();
        instructions.tiles.tilesets[1].name = "Font";
        instructions.tiles.tilesets[1].palette = "src/palettes/People.X68";
        instructions.tiles.tilesets[1].sourceFilePath = "design/img/font-dialog-tiles/font.png";
        instructions.tiles.tilesets[1].destinationFilePath = "src/tiles/font-tiles/dwf.X68";
        instructions.patterns = new PatternFromTilesetParameters();
        instructions.patterns.patternIncludeFilePath = "src/inc_PatternsGenerated.X68";
        instructions.patterns.patterns = new PatternFromTileset[1];
        instructions.patterns.patterns[0] = new PatternFromTileset();
        instructions.patterns.patterns[0].name = "FrameNWOpen";
        instructions.patterns.patterns[0].destinationFilePath = "src/patterns/frame-nw-open.X68";
        instructions.patterns.patterns[0].paletteName = "PaletteFrameRect";
        instructions.patterns.patterns[0].sourceFilePath = "design/img/scene-tiles/frame-nw-open.png";
        instructions.patterns.patterns[0].tilesetName = "FrameRect";
        SpriteParameters sprites = new SpriteParameters();
        sprites.palette = "src/palettes/People.X68";
        sprites.includeFilePath = "src/inc_SpriteTiles.X68";
        sprites.characterDefinitionFilePath = "src/data_CharacterDefinitions.X68";
        sprites.constantDefinitionPath = "src/const_CharacterIDs.X68";
        sprites.baseId = "2000";
        sprites.sprites = new Sprite[2];
        sprites.sprites[0] = new Sprite();
        sprites.sprites[0].name = "Eryn";
        sprites.sprites[0].sourceFilePath = "design/img/sprite-tiles/pc-eryn.png";
        sprites.sprites[0].destinationFilePath = "src/tiles/sprite-tiles/pc-eryn.X68";
        sprites.sprites[1] = new Sprite();
        sprites.sprites[1].name = "Carl";
        sprites.sprites[1].sourceFilePath = "design/img/sprite-tiles/pc-carl.png";
        sprites.sprites[1].destinationFilePath = "src/tiles/sprite-tiles/pc-carl.X68";
        instructions.sprites = sprites;
        SceneParameters scenes = new SceneParameters();
        scenes.includeFilePath = "src/inc_Scenes_Generated.X68";
        scenes.scenePaths = new String[1];
        scenes.scenePaths[0] = "/design/scene-json/tbooks.json";
        instructions.scenes = scenes;
        TextParameters text = new TextParameters();
        text.tableFilePath = "src/text/table_text_gen.X68";
        text.textFilePath = "src/text/en-us/strings_gen.X68";
        text.filePaths = new String[1];
        text.filePaths[0] = "design/text/characternames.json";
        instructions.text = text;
        SimpleSourceDestinationParameters mpp = new SimpleSourceDestinationParameters();
        mpp.sourceFile = "design/data/movementpatterns.json";
        mpp.destinationFile = "src/data_SpriteMovementPatterns.X68";
        instructions.movementPatterns = mpp;
        SimpleSourceDestinationParameters se = new SimpleSourceDestinationParameters();
        se.sourceFile = "design/data/scriptedevents.json";
        se.destinationFile = "src/data_ScriptedEvents.X68";
        instructions.scriptedEvents = se;
        ActionTableParameters actionTable = new ActionTableParameters();
        actionTable.dayCount = 1;
        actionTable.sceneCount = 4;
        actionTable.defaultLabels = new String[4];
        actionTable.defaultLabels[0] = "ActionScriptDefaultInteract";
        actionTable.defaultLabels[1] = "ActionScriptNullEvent";
        actionTable.defaultLabels[2] = "DefaultExitScene";
        actionTable.defaultLabels[3] = "DefaultEnterScene";
        actionTable.entries = new ActionTableEntry[1];
        actionTable.entries[0] = new ActionTableEntry();
        actionTable.entries[0].action = "TestAction";
        actionTable.entries[0].day = 0;
        actionTable.entries[0].scene = "TestScene";
        actionTable.filePath = "src/table_Actions.X68";
        instructions.actionTable = actionTable;
        HeaderParameters header = new HeaderParameters();
        header.filePath = "src/init_Header.X68";
        header.copyright = "'(C)HUJO '";
        header.cartName = "'Retail Clerk 90                                 '";
        header.romStart = "$00000000";
        header.romEnd = "RomEnd";
        header.ramStartEnd = "$FFFF0000,$FFFFFFFF";
        header.sramType = "'RA',$F8,$20";
        header.sramStart = "SRAM_START";
        header.sramEnd = "SRAM_END";
        header.comment = "'http://huguesjohnson.com/               '";
        instructions.header = header;
        AssemblyParameters assembly = new AssemblyParameters();
        instructions.assembly = new AssemblyParameters[3];
        assembly.assemblerPath = "src/";
        assembly.arguments = "vasmm68k_mot -o ../build/RetailClerk90.bin -Fbin -spaces -D_DEBUG_=0 -D_ATGAMES_HACKS_=0 RetailClerk90.X68";
        instructions.assembly[0] = assembly;
        assembly.arguments = "vasmm68k_mot -o ../build/RetailClerk90_DEBUG.bin -Fbin -spaces -D_DEBUG_=1 -D_ATGAMES_HACKS_=0 RetailClerk90.X68";
        instructions.assembly[1] = assembly;
        assembly.arguments = "vasmm68k_mot -o ../build/RetailClerk90_ATGAMES.bin -Fbin -spaces -D_DEBUG_=0 -D_ATGAMES_HACKS_=1 RetailClerk90.X68";
        instructions.assembly[2] = assembly;
        PackageParameters[] packageParameters = new PackageParameters[3];
        packageParameters[0] = new PackageParameters();
        packageParameters[0].packagePath = "/build/RetailClerk90.zip";
        packageParameters[0].includeFilePaths = new String[4];
        packageParameters[0].includeFilePaths[0] = "/build/RetailClerk90.bin";
        packageParameters[0].includeFilePaths[1] = "CREDITS";
        packageParameters[0].includeFilePaths[2] = "LICENSE";
        packageParameters[0].includeFilePaths[3] = "README.md";
        packageParameters[1] = new PackageParameters();
        packageParameters[1].packagePath = "/build/RetailClerk90_DEBUG.zip";
        packageParameters[1].includeFilePaths = new String[4];
        packageParameters[1].includeFilePaths[0] = "/build/RetailClerk90_DEBUG.bin";
        packageParameters[1].includeFilePaths[1] = "CREDITS";
        packageParameters[1].includeFilePaths[2] = "LICENSE";
        packageParameters[1].includeFilePaths[3] = "README.md";
        packageParameters[2] = new PackageParameters();
        packageParameters[2].packagePath = "/build/RetailClerk90_ATGAMES.zip";
        packageParameters[2].includeFilePaths = new String[4];
        packageParameters[2].includeFilePaths[0] = "/build/RetailClerk90_ATGAMES.bin";
        packageParameters[2].includeFilePaths[1] = "CREDITS";
        packageParameters[2].includeFilePaths[2] = "LICENSE";
        packageParameters[2].includeFilePaths[3] = "README.md";
        instructions.packageParameters = packageParameters;
        String json = new Gson().toJson((Object)instructions);
        System.out.println(json);
    }
}

