/*
 * Decompiled with CFR 0.152.
 */
package com.huguesjohnson.dubbel.util;

import java.io.File;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class AsciiStringFinder {
    public static final Map<String, String> findInFile(String filePath, int minStringLength, boolean acceptLetters, boolean acceptNum, boolean acceptSpecial, byte[] acceptCustom) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        AcceptByte ab = new AcceptByte(acceptLetters, acceptNum, acceptSpecial, acceptCustom);
        try {
            byte[] f = Files.readAllBytes(new File(filePath).toPath());
            int i = 0;
            while (i < f.length) {
                if (ab.acceptByte(f[i])) {
                    int end = i;
                    while (end < f.length && ab.acceptByte(f[end])) {
                        ++end;
                    }
                    if (end - i >= minStringLength) {
                        byte[] sub = Arrays.copyOfRange(f, i, end);
                        map.put("0x" + Integer.toHexString(i), new String(sub).toString());
                        i = end;
                    }
                }
                ++i;
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        return map;
    }

    protected static class AcceptByte {
        final boolean acceptLetters;
        final boolean acceptNum;
        final boolean acceptSpecial;
        final byte[] acceptCustom;

        AcceptByte(boolean acceptLetters, boolean acceptNum, boolean acceptSpecial, byte[] acceptCustom) {
            this.acceptLetters = acceptLetters;
            this.acceptNum = acceptNum;
            this.acceptSpecial = acceptSpecial;
            this.acceptCustom = acceptCustom;
        }

        protected boolean acceptByte(byte b) {
            if (this.acceptLetters) {
                if (b >= 65 && b <= 90) {
                    return true;
                }
                if (b >= 97 && b <= 122) {
                    return true;
                }
            }
            if (this.acceptNum && b >= 48 && b <= 57) {
                return true;
            }
            if (this.acceptSpecial) {
                if (b >= 33 && b <= 47) {
                    return true;
                }
                if (b >= 58 && b <= 64) {
                    return true;
                }
                if (b >= 123 && b <= 126) {
                    return true;
                }
            }
            if (b == 32) {
                return true;
            }
            if (this.acceptCustom != null) {
                byte[] byArray = this.acceptCustom;
                int n = this.acceptCustom.length;
                int n2 = 0;
                while (n2 < n) {
                    byte ac = byArray[n2];
                    if (b == ac) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }
    }
}

