/*
 * Decompiled with CFR 0.152.
 */
package com.huguesjohnson.dubbel.util;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public abstract class HashUtil {
    public static final String MDNAME_SHA3512 = "SHA3-512";
    public static final String MDNAME_MD5 = "MD5";

    public static String computeHash(String input, String mdName) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(mdName);
        byte[] data = md.digest(input.getBytes(StandardCharsets.UTF_8));
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < data.length) {
            int di = data[i] & 0xFF;
            if (di < 16) {
                sb.append("0");
            }
            sb.append(Integer.toHexString(di));
            ++i;
        }
        return sb.toString();
    }

    public static String computeHashSHA3512(String input) throws NoSuchAlgorithmException {
        return HashUtil.computeHash(input, MDNAME_SHA3512);
    }

    public static String computeHashMD5(String input) throws NoSuchAlgorithmException {
        return HashUtil.computeHash(input, MDNAME_MD5);
    }
}

