/*
 * Decompiled with CFR 0.152.
 */
package com.huguesjohnson.dubbel.util;

import java.util.StringTokenizer;

public abstract class NumberFormatters {
    public static final String toHexWord(int i) {
        StringBuilder hexWord = new StringBuilder(Integer.toHexString(i));
        while (hexWord.length() < 4) {
            hexWord.insert(0, "0");
        }
        hexWord.insert(0, "$");
        return hexWord.toString().toUpperCase();
    }

    public static String decimalStringToAsciiString(String decimalString) {
        String asciiString = new String("");
        StringTokenizer tokenizer = new StringTokenizer(decimalString);
        while (tokenizer.hasMoreTokens()) {
            try {
                byte b = Byte.valueOf(tokenizer.nextToken());
                asciiString = String.valueOf(asciiString) + (char)b + " ";
            }
            catch (NumberFormatException nfe) {
                asciiString = String.valueOf(asciiString) + " ";
            }
        }
        return asciiString;
    }

    public static String decimalStringToHexString(String decimalString) {
        String hexString = new String("");
        StringTokenizer tokenizer = new StringTokenizer(decimalString);
        while (tokenizer.hasMoreTokens()) {
            try {
                Long l = Long.valueOf(tokenizer.nextToken());
                hexString = String.valueOf(hexString) + Long.toHexString(l) + " ";
            }
            catch (NumberFormatException nfe) {
                hexString = String.valueOf(hexString) + " ";
            }
        }
        return hexString;
    }

    public static String decimalStringToOctalString(String decimalString) {
        String octalString = new String("");
        StringTokenizer tokenizer = new StringTokenizer(decimalString);
        while (tokenizer.hasMoreTokens()) {
            try {
                Long l = Long.valueOf(tokenizer.nextToken());
                octalString = String.valueOf(octalString) + Long.toOctalString(l) + " ";
            }
            catch (NumberFormatException nfe) {
                octalString = String.valueOf(octalString) + " ";
            }
        }
        return octalString;
    }

    public static String decimalStringToBinaryString(String decimalString) {
        String binaryString = new String("");
        StringTokenizer tokenizer = new StringTokenizer(decimalString);
        while (tokenizer.hasMoreTokens()) {
            try {
                Long l = Long.valueOf(tokenizer.nextToken());
                binaryString = String.valueOf(binaryString) + Long.toBinaryString(l) + " ";
            }
            catch (NumberFormatException nfe) {
                binaryString = String.valueOf(binaryString) + " ";
            }
        }
        return binaryString;
    }

    public static String asciiStringToDecimalString(String asciiString) {
        String decimalString = new String("");
        byte[] b = asciiString.getBytes();
        int index = 0;
        while (index < b.length) {
            decimalString = String.valueOf(decimalString) + b[index] + " ";
            ++index;
        }
        return decimalString;
    }

    public static String hexStringToDecimalString(String hexString) {
        String decimalString = new String("");
        StringTokenizer tokenizer = new StringTokenizer(hexString);
        while (tokenizer.hasMoreTokens()) {
            try {
                decimalString = String.valueOf(decimalString) + Long.toString(Long.decode("0x" + tokenizer.nextToken())) + " ";
            }
            catch (NumberFormatException nfe) {
                decimalString = String.valueOf(decimalString) + " ";
            }
        }
        return decimalString;
    }

    public static String octalStringToDecimalString(String octalString) {
        String decimalString = new String("");
        StringTokenizer tokenizer = new StringTokenizer(octalString);
        while (tokenizer.hasMoreTokens()) {
            char[] ch = tokenizer.nextToken().toCharArray();
            long decimalValue = 0L;
            int index = 0;
            while (index < ch.length) {
                long n;
                try {
                    n = Long.valueOf(String.valueOf(ch[index]));
                    if (n > 8L || n < 0L) {
                        throw new NumberFormatException();
                    }
                }
                catch (NumberFormatException nfe) {
                    n = 0L;
                }
                decimalValue = (long)((double)decimalValue + (double)n * Math.pow(8.0, ch.length - index - 1));
                ++index;
            }
            decimalString = String.valueOf(decimalString) + Long.toString(decimalValue) + " ";
        }
        return decimalString;
    }

    public static String binaryStringToDecimalString(String binaryString) {
        String decimalString = new String("");
        StringTokenizer tokenizer = new StringTokenizer(binaryString);
        while (tokenizer.hasMoreTokens()) {
            char[] ch = tokenizer.nextToken().toCharArray();
            long decimalValue = 0L;
            int index = 0;
            while (index < ch.length) {
                try {
                    long n = Long.valueOf(String.valueOf(ch[index]));
                    if (n > 1L || n < 0L) {
                        throw new NumberFormatException();
                    }
                    decimalValue = (long)((double)decimalValue + (double)n * Math.pow(2.0, ch.length - index - 1));
                }
                catch (NumberFormatException nfe) {
                    decimalString = String.valueOf(decimalString) + " ";
                }
                ++index;
            }
            decimalString = String.valueOf(decimalString) + Long.toString(decimalValue) + " ";
        }
        return decimalString;
    }
}

