/*
 * Decompiled with CFR 0.152.
 */
package com.huguesjohnson.dubbel.util;

public abstract class StringDistance {
    public static int hammingDistance(String s1, String s2) throws Exception {
        int length = s1.length();
        if (length != s2.length()) {
            throw new Exception("Strings are different lengths. s1:" + length + " s2:" + s2.length());
        }
        int hd = 0;
        int i = 0;
        while (i < length) {
            if (s1.charAt(i) != s2.charAt(i)) {
                ++hd;
            }
            ++i;
        }
        return hd;
    }

    public static int levenshteinDistance(String s1, String s2) {
        int l1 = s1.length();
        int l2 = s2.length();
        char[] c1 = s1.toCharArray();
        char[] c2 = s2.toCharArray();
        int[][] distance = new int[l1 + 1][l2 + 1];
        int i = 0;
        while (i < l1 + 1) {
            distance[i][0] = i;
            ++i;
        }
        i = 0;
        while (i < l2 + 1) {
            distance[0][i] = i;
            ++i;
        }
        i = 1;
        while (i < l1 + 1) {
            int j = 1;
            while (j < l2 + 1) {
                int cost1 = distance[i - 1][j] + 1;
                int cost2 = distance[i][j - 1] + 1;
                int cost3 = distance[i - 1][j - 1];
                if (c1[i - 1] != c2[j - 1]) {
                    ++cost3;
                }
                distance[i][j] = Math.min(Math.min(cost1, cost2), cost3);
                ++j;
            }
            ++i;
        }
        return distance[l1][l2];
    }
}

