/*
 * Decompiled with CFR 0.152.
 */
package com.huguesjohnson.dubbel.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public abstract class ZipUtil {
    private static final int BUFFER_LENGTH = 1024;

    public static boolean zip(String basePath, String[] includeFilePaths, String archiveFileName) throws Exception {
        boolean success = false;
        ZipOutputStream zout = null;
        FileInputStream fin = null;
        try {
            zout = new ZipOutputStream(new FileOutputStream(new File(String.valueOf(basePath) + archiveFileName)));
            zout.setMethod(8);
            int i = 0;
            while (i < includeFilePaths.length) {
                int length;
                String sourceFileName = String.valueOf(basePath) + includeFilePaths[i];
                File inputFile = new File(sourceFileName);
                byte[] buffer = new byte[1024];
                CRC32 crc = new CRC32();
                fin = new FileInputStream(inputFile);
                while ((length = fin.read(buffer)) > -1) {
                    crc.update(buffer, 0, length);
                }
                fin.close();
                ZipEntry entry = new ZipEntry(sourceFileName.substring(sourceFileName.lastIndexOf(File.separator) + File.separator.length()));
                entry.setSize(inputFile.length());
                entry.setTime(inputFile.lastModified());
                entry.setCrc(crc.getValue());
                zout.putNextEntry(entry);
                fin = new FileInputStream(inputFile);
                while ((length = fin.read(buffer)) > -1) {
                    zout.write(buffer, 0, length);
                }
                ++i;
            }
            success = true;
        }
        finally {
            try {
                if (zout != null) {
                    zout.closeEntry();
                    zout.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (Exception exception) {}
        }
        return success;
    }
}

