/*
 * Decompiled with CFR 0.152.
 */
package com.huguesjohnson.dubbel.util.test;

import com.huguesjohnson.dubbel.util.ArrayUtil;
import java.util.ArrayList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestArrayUtil {
    TestArrayUtil() {
    }

    @Test
    public void test_xorBytes() {
        byte[] b;
        byte[] a;
        try {
            byte[] byArray = new byte[5];
            byArray[1] = 1;
            byArray[2] = 2;
            byArray[3] = 3;
            byArray[4] = 4;
            a = byArray;
            b = new byte[]{1, 1, 1, 1, 1};
            byte[] xor = ArrayUtil.xorBytes(a, b);
            Assertions.assertEquals((int)xor[0], (int)1);
            Assertions.assertEquals((int)xor[1], (int)0);
            Assertions.assertEquals((int)xor[2], (int)3);
            Assertions.assertEquals((int)xor[3], (int)2);
            Assertions.assertEquals((int)xor[4], (int)5);
        }
        catch (Exception x) {
            Assertions.fail((String)x.getMessage());
        }
        try {
            byte[] byArray = new byte[5];
            byArray[1] = 1;
            byArray[2] = 2;
            byArray[3] = 3;
            byArray[4] = 4;
            a = byArray;
            b = new byte[]{1, 1, 1, 1};
            ArrayUtil.xorBytes(a, b);
            Assertions.fail((String)"This test should have failed.");
        }
        catch (Exception a2) {
            // empty catch block
        }
        try {
            byte[] byArray = new byte[4];
            byArray[1] = 1;
            byArray[2] = 2;
            byArray[3] = 3;
            a = byArray;
            b = new byte[]{1, 1, 1, 1, 1};
            ArrayUtil.xorBytes(a, b);
            Assertions.fail((String)"This test should have failed.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void test_pickIndex() {
        try {
            int max = 1;
            while (max < 10) {
                int i = 0;
                while (i < 20) {
                    int index = ArrayUtil.pickIndex(i, max);
                    if (i == max) {
                        Assertions.assertEquals((int)index, (int)0);
                    } else if (i < max) {
                        Assertions.assertEquals((int)index, (int)i);
                    } else {
                        Assertions.assertEquals((int)index, (int)(i % max));
                    }
                    ++i;
                }
                ++max;
            }
        }
        catch (Exception x) {
            x.printStackTrace();
            Assertions.fail((String)x.getMessage());
        }
    }

    @Test
    public void test_pickIndexWithNegatives() {
        try {
            ArrayUtil.pickIndex(-1, 1);
            Assertions.fail((String)"This test should have failed.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ArrayUtil.pickIndex(1, -1);
            Assertions.fail((String)"This test should have failed.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void test_maxElementIndex() {
        int maxIndex = ArrayUtil.maxElementIndex(new double[]{1.0, 2.0, 3.0, 4.0, 5.0});
        Assertions.assertEquals((int)4, (int)maxIndex);
        maxIndex = ArrayUtil.maxElementIndex(new double[]{1.0, -2.0, -3.0, -4.0, -5.0});
        Assertions.assertEquals((int)0, (int)maxIndex);
        maxIndex = ArrayUtil.maxElementIndex(new double[]{-1.0, -2.0, -3.0, -4.0, -5.0});
        Assertions.assertEquals((int)0, (int)maxIndex);
        maxIndex = ArrayUtil.maxElementIndex(new double[]{-1.0, -2.0, -3.0, -4.0, -5.0});
        Assertions.assertEquals((int)0, (int)maxIndex);
        maxIndex = ArrayUtil.maxElementIndex(new double[]{-1.0, 2.0, -3.0, -4.0, -5.0});
        Assertions.assertEquals((int)1, (int)maxIndex);
        maxIndex = ArrayUtil.maxElementIndex(new double[]{-1.0, -2.0, 3.0, -4.0, -5.0});
        Assertions.assertEquals((int)2, (int)maxIndex);
        maxIndex = ArrayUtil.maxElementIndex(new double[]{-1.0, -2.0, -3.0, 4.0, -5.0});
        Assertions.assertEquals((int)3, (int)maxIndex);
        maxIndex = ArrayUtil.maxElementIndex(new double[]{-1.0, -2.0, -3.0, -4.0, 5.0});
        Assertions.assertEquals((int)4, (int)maxIndex);
        maxIndex = ArrayUtil.maxElementIndex(new double[]{0.9, 0.01, 1.0, 0.9999, 0.999999});
        Assertions.assertEquals((int)2, (int)maxIndex);
    }

    @Test
    public void test_pickChar() {
        ArrayList<Character> list = new ArrayList<Character>();
        char[] chars = new char[]{'q', 'w', 'e', 'r', 't', 'y'};
        char c = ArrayUtil.pickChar(list, 0, false, chars);
        Assertions.assertEquals((char)list.get(0).charValue(), (char)c);
        int i = 0;
        while (i < chars.length) {
            Assertions.assertEquals((char)list.get(i).charValue(), (char)chars[i]);
            ++i;
        }
        c = ArrayUtil.pickChar(list, 1, true, chars);
        Assertions.assertEquals((char)'w', (char)c);
        c = ArrayUtil.pickChar(list, 1, true, chars);
        Assertions.assertEquals((char)'e', (char)c);
        c = ArrayUtil.pickChar(list, 11, true, chars);
        Assertions.assertEquals((char)'y', (char)c);
        c = ArrayUtil.pickChar(list, 0, true, chars);
        Assertions.assertEquals((char)'q', (char)c);
        c = ArrayUtil.pickChar(list, 8, true, chars);
        Assertions.assertEquals((char)'r', (char)c);
        c = ArrayUtil.pickChar(list, 6489, true, chars);
        Assertions.assertEquals((char)'t', (char)c);
        Assertions.assertEquals((int)0, (int)list.size());
        c = ArrayUtil.pickChar(list, 5, false, chars);
        Assertions.assertEquals((char)list.get(5).charValue(), (char)c);
        i = 0;
        while (i < chars.length) {
            Assertions.assertEquals((char)list.get(i).charValue(), (char)chars[i]);
            ++i;
        }
    }

    @Test
    public void test_fillArrayList() {
        char[] chars = new char[]{'b', 'l', 'a', 'h'};
        ArrayList<Character> list = new ArrayList<Character>();
        ArrayUtil.fillArrayList(list, chars);
        Assertions.assertEquals((int)list.size(), (int)chars.length);
        int i = 0;
        while (i < chars.length) {
            Assertions.assertEquals((char)list.get(i).charValue(), (char)chars[i]);
            ++i;
        }
    }
}

