/*
 * Decompiled with CFR 0.152.
 */
package com.huguesjohnson.dubbel.util.test;

import com.huguesjohnson.dubbel.util.ChecksumUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestChecksumUtil {
    TestChecksumUtil() {
    }

    @Test
    void testSumBytes() {
        byte[] b = new byte[]{66, 13, 6, 4, 89};
        Assertions.assertEquals((int)178, (int)ChecksumUtil.sumBytes(b));
        Assertions.assertEquals((int)179, (int)ChecksumUtil.sumBytes(b, 1));
        b = new byte[]{66, -13, 6, 4, 89};
        Assertions.assertEquals((int)152, (int)ChecksumUtil.sumBytes(b));
    }

    @Test
    void testSubBytes() {
        byte[] b = new byte[]{66, 13, 6, 4, 89};
        Assertions.assertEquals((int)-178, (int)ChecksumUtil.subBytes(b));
        Assertions.assertEquals((int)-177, (int)ChecksumUtil.subBytes(b, 1));
        b = new byte[]{66, -13, 6, 4, 89};
        Assertions.assertEquals((int)-152, (int)ChecksumUtil.subBytes(b));
    }

    @Test
    void testXorBytes() {
        byte[] b = new byte[]{1, 2};
        Assertions.assertEquals((int)3, (int)ChecksumUtil.xorBytes(b));
        b = new byte[]{66, 13};
        Assertions.assertEquals((int)79, (int)ChecksumUtil.xorBytes(b));
        b = new byte[]{66, 13, 6, 4, 89};
        Assertions.assertEquals((int)20, (int)ChecksumUtil.xorBytes(b));
    }
}

