/*
 * Decompiled with CFR 0.152.
 */
package com.huguesjohnson.dubbel.util.test;

import com.huguesjohnson.dubbel.util.StringDistance;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestStringDistance {
    TestStringDistance() {
    }

    @Test
    void test_hammingDistance() {
        String s2;
        String s1;
        try {
            s1 = "qwerty";
            s2 = "asdfgh";
            int hd = StringDistance.hammingDistance(s1, s2);
            Assertions.assertEquals((int)6, (int)hd);
            s2 = "qwerty";
            hd = StringDistance.hammingDistance(s1, s2);
            Assertions.assertEquals((int)0, (int)hd);
            s2 = "qxxrty";
            hd = StringDistance.hammingDistance(s1, s2);
            Assertions.assertEquals((int)2, (int)hd);
            s2 = "qwertY";
            hd = StringDistance.hammingDistance(s1, s2);
            Assertions.assertEquals((int)1, (int)hd);
        }
        catch (Exception x) {
            Assertions.fail((String)x.getMessage());
        }
        try {
            s1 = "blah";
            s2 = "blah blah";
            StringDistance.hammingDistance(s1, s2);
            Assertions.fail((String)"Expected exception to be thrown");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    void test_levenshteinDistance() {
        String s1 = "qwerty";
        String s2 = "qwerty";
        int ld = StringDistance.levenshteinDistance(s1, s2);
        Assertions.assertEquals((int)0, (int)ld);
        s2 = "qwertyu";
        ld = StringDistance.levenshteinDistance(s1, s2);
        Assertions.assertEquals((int)1, (int)ld);
        s2 = "qwert";
        ld = StringDistance.levenshteinDistance(s1, s2);
        Assertions.assertEquals((int)1, (int)ld);
        s2 = "qxxxty";
        ld = StringDistance.levenshteinDistance(s1, s2);
        Assertions.assertEquals((int)3, (int)ld);
        s2 = "qXwerty";
        ld = StringDistance.levenshteinDistance(s1, s2);
        Assertions.assertEquals((int)1, (int)ld);
    }
}

