/*
 * Decompiled with CFR 0.152.
 */
package com.huguesjohnson.narpas;

import com.huguesjohnson.dubbel.util.ArrayUtil;
import com.huguesjohnson.dubbel.util.ChecksumUtil;
import com.huguesjohnson.dubbel.util.HashUtil;
import com.huguesjohnson.narpas.CharacterSetArrayIndex;
import com.huguesjohnson.narpas.PasswordSetting;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;

public abstract class Narpas {
    static MessageDigest md5Hash = null;

    @Deprecated
    public static String computeHash(String input, int minLength) {
        if (md5Hash == null) {
            try {
                md5Hash = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
        }
        StringBuffer sBuilder = new StringBuffer();
        while (sBuilder.length() < minLength) {
            byte[] data = sBuilder.length() == 0 ? md5Hash.digest(input.getBytes()) : md5Hash.digest(sBuilder.toString().getBytes());
            int i = 0;
            while (i < data.length) {
                int di = data[i] & 0xFF;
                if (di < 16) {
                    sBuilder.append("0");
                }
                sBuilder.append(Integer.toHexString(di));
                ++i;
            }
        }
        return sBuilder.toString();
    }

    public static String passwordSettingHashString(PasswordSetting ps) throws Exception {
        char[] limitSpecialChars;
        int settingsPad = ChecksumUtil.subBytes(ps.getPasswordVersion().getBytes());
        if (settingsPad < 0) {
            settingsPad = Math.abs(settingsPad);
            settingsPad ^= 0;
        }
        if (ps.isOptionAllowDuplicateCharacters()) {
            settingsPad ^= 1;
        }
        if (ps.isOptionUseLCase()) {
            settingsPad ^= 2;
        }
        if (ps.isOptionUseUCase()) {
            settingsPad ^= 4;
        }
        if (ps.isOptionUseNumbers()) {
            settingsPad ^= 8;
        }
        if (ps.isOptionUseExtChars()) {
            settingsPad ^= 0x10;
        }
        if (ps.isOptionUseSChars()) {
            settingsPad ^= 0x20;
        }
        if ((limitSpecialChars = ps.getLimitSpecialChars()) != null && limitSpecialChars.length > 0) {
            settingsPad ^= 0x40;
        }
        StringBuilder sb = new StringBuilder(ps.getPasswordName());
        String padToString = Integer.toString(settingsPad);
        int i = 0;
        while (i < padToString.length()) {
            int insertIndex = ArrayUtil.pickIndex(settingsPad, sb.length());
            sb.insert(insertIndex, padToString.charAt(i));
            ++i;
        }
        sb.append(ps.getPasswordVersion());
        return sb.toString();
    }

    public static boolean validate(String passPhrase, PasswordSetting settings) {
        int passwordLength;
        if (passPhrase == null || settings == null || settings.getPasswordName() == null) {
            return false;
        }
        if (passPhrase.length() < 1 || settings.getPasswordName().length() < 1) {
            return false;
        }
        if (passPhrase.equals(settings.getPasswordName())) {
            return false;
        }
        int algorithmVersion = settings.getAlgorithmVersion();
        if (!(settings.isOptionUseLCase() || settings.isOptionUseNumbers() || settings.isOptionUseSChars() || settings.isOptionUseUCase())) {
            if (algorithmVersion > 1) {
                if (!settings.isOptionUseExtChars()) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (algorithmVersion > 2 || algorithmVersion < 0) {
            return false;
        }
        return algorithmVersion != 2 || (passwordLength = settings.getPasswordLength()) >= 4 && settings.getPasswordLength() <= 128;
    }

    public static String generatePassword(String passPhrase, PasswordSetting settings) throws Exception {
        if (!Narpas.validate(passPhrase, settings)) {
            return "";
        }
        if (settings.getAlgorithmVersion() <= 1) {
            return Narpas.generatePassword(passPhrase, settings.getPasswordName(), settings.isOptionUseLCase(), settings.isOptionUseUCase(), settings.isOptionUseNumbers(), settings.isOptionUseSChars(), settings.getPasswordLength());
        }
        if (settings.getAlgorithmVersion() == 2) {
            return Narpas.generatePasswordV2(passPhrase, settings);
        }
        return "";
    }

    public static String generatePassword(String passPhrase, String passwordName, boolean useLCase, boolean useUCase, boolean useNumbers, boolean useSpecialCharacters, int basePasswordLength) {
        if (passPhrase.length() < 1 || passwordName.length() < 1) {
            return "";
        }
        if (passPhrase.equals(passwordName)) {
            return "";
        }
        if (!(useLCase || useUCase || useNumbers || useSpecialCharacters)) {
            return "";
        }
        int passwordLength = 8 * basePasswordLength;
        String phraseHash = Narpas.computeHash(passPhrase, passwordLength);
        byte[] phraseBytes = phraseHash.getBytes();
        String nameHash = Narpas.computeHash(passwordName, passwordLength);
        byte[] nameBytes = nameHash.getBytes();
        byte[] xorBytes = null;
        try {
            xorBytes = ArrayUtil.xorBytes(phraseBytes, nameBytes);
        }
        catch (Exception x) {
            return "";
        }
        int selectedCharOffset = 0;
        if (useLCase) {
            selectedCharOffset ^= 1;
        }
        if (useUCase) {
            selectedCharOffset ^= 2;
        }
        if (useNumbers) {
            selectedCharOffset ^= 4;
        }
        if (useSpecialCharacters) {
            selectedCharOffset ^= 8;
        }
        int startOffset = basePasswordLength * selectedCharOffset;
        int phraseStart = ChecksumUtil.xorBytes(passPhrase.getBytes()) + startOffset;
        int phraseIndex = 0;
        try {
            phraseIndex = ArrayUtil.pickIndex(phraseStart, phraseHash.length());
        }
        catch (Exception exception) {
            // empty catch block
        }
        int nameStart = ChecksumUtil.xorBytes(passwordName.getBytes()) + startOffset;
        int nameIndex = 0;
        try {
            nameIndex = ArrayUtil.pickIndex(nameStart, phraseHash.length());
        }
        catch (Exception exception) {
            // empty catch block
        }
        int arrayIndex = basePasswordLength;
        ArrayList<Character> lowerCase = new ArrayList<Character>();
        ArrayList<Character> upperCase = new ArrayList<Character>();
        ArrayList<Character> numbers = new ArrayList<Character>();
        ArrayList<Character> specialChars = new ArrayList<Character>();
        ArrayList<Integer> arrayOrder = new ArrayList<Integer>();
        StringBuilder password = new StringBuilder();
        while (password.length() < passwordLength) {
            if (arrayOrder.size() == 0) {
                if (useLCase) {
                    arrayOrder.add(0);
                }
                if (useUCase) {
                    arrayOrder.add(1);
                }
                if (useNumbers) {
                    arrayOrder.add(2);
                }
                if (useSpecialCharacters) {
                    arrayOrder.add(3);
                }
            }
            int pickArray = 0;
            try {
                pickArray = ArrayUtil.pickIndex(xorBytes[arrayIndex], arrayOrder.size());
            }
            catch (Exception exception) {
                // empty catch block
            }
            int nextArray = (Integer)arrayOrder.get(pickArray);
            arrayOrder.remove(pickArray);
            int nextIndex = phraseBytes[phraseIndex] * nameBytes[nameIndex];
            if (nextArray == 0) {
                if (lowerCase.size() == 0) {
                    ArrayUtil.fillArrayList(lowerCase, Constants.lchars);
                }
                int lcharIndex = 0;
                try {
                    lcharIndex = ArrayUtil.pickIndex(nextIndex, lowerCase.size());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                password.append(lowerCase.get(lcharIndex));
                lowerCase.remove(lcharIndex);
            } else if (nextArray == 1) {
                if (upperCase.size() == 0) {
                    ArrayUtil.fillArrayList(upperCase, Constants.uchars);
                }
                int ucharIndex = 0;
                try {
                    ucharIndex = ArrayUtil.pickIndex(nextIndex, upperCase.size());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                password.append(upperCase.get(ucharIndex));
                upperCase.remove(ucharIndex);
            } else if (nextArray == 2) {
                if (numbers.size() == 0) {
                    ArrayUtil.fillArrayList(numbers, Constants.nums);
                }
                int numIndex = 0;
                try {
                    numIndex = ArrayUtil.pickIndex(nextIndex, numbers.size());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                password.append(numbers.get(numIndex));
                numbers.remove(numIndex);
            } else {
                if (specialChars.size() == 0) {
                    ArrayUtil.fillArrayList(specialChars, Constants.schars);
                }
                int scharIndex = 0;
                try {
                    scharIndex = ArrayUtil.pickIndex(nextIndex, specialChars.size());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                password.append(specialChars.get(scharIndex));
                specialChars.remove(scharIndex);
            }
            if (++phraseIndex == phraseBytes.length) {
                phraseIndex = 0;
            }
            if (++nameIndex == nameBytes.length) {
                nameIndex = 0;
            }
            if (++arrayIndex != xorBytes.length) continue;
            arrayIndex = 0;
        }
        return password.toString();
    }

    private static String generatePasswordV2(String passPhrase, PasswordSetting settings) throws Exception {
        int passwordLength = settings.getPasswordLength();
        boolean remove = !settings.isOptionAllowDuplicateCharacters();
        String phraseHash = HashUtil.computeHashSHA3512(passPhrase);
        byte[] phraseBytes = phraseHash.getBytes();
        int phraseBytesSum = ChecksumUtil.sumBytes(phraseBytes);
        String nameHash = HashUtil.computeHashSHA3512(Narpas.passwordSettingHashString(settings));
        byte[] nameBytes = nameHash.getBytes();
        int namesBytesSum = ChecksumUtil.sumBytes(nameBytes);
        byte[] xorBytes = ArrayUtil.xorBytes(phraseBytes, nameBytes);
        int xorBytesSum = ChecksumUtil.sumBytes(xorBytes);
        String versionHash = HashUtil.computeHashSHA3512(settings.getPasswordVersion());
        int versionBytesSum = ChecksumUtil.sumBytes(versionHash.getBytes());
        double[] nextArrayWeights = new double[CharacterSetArrayIndex.EXTCHARS.getValue() + 1];
        int i = 0;
        while (i <= CharacterSetArrayIndex.EXTCHARS.getValue()) {
            nextArrayWeights[i] = -1.0;
            ++i;
        }
        int startOffset = passwordLength;
        if (settings.isOptionUseLCase()) {
            startOffset ^= 1;
            nextArrayWeights[CharacterSetArrayIndex.LCHARS.getValue()] = settings.getWeight(CharacterSetArrayIndex.LCHARS);
        }
        if (settings.isOptionUseUCase()) {
            startOffset ^= 2;
            nextArrayWeights[CharacterSetArrayIndex.UCHARS.getValue()] = settings.getWeight(CharacterSetArrayIndex.UCHARS);
        }
        if (settings.isOptionUseNumbers()) {
            startOffset ^= 4;
            nextArrayWeights[CharacterSetArrayIndex.NUMS.getValue()] = settings.getWeight(CharacterSetArrayIndex.NUMS);
        }
        if (settings.isOptionUseSChars()) {
            startOffset ^= 8;
            nextArrayWeights[CharacterSetArrayIndex.SCHARS.getValue()] = settings.getWeight(CharacterSetArrayIndex.SCHARS);
        }
        if (settings.isOptionUseExtChars()) {
            startOffset ^= 0x10;
            nextArrayWeights[CharacterSetArrayIndex.EXTCHARS.getValue()] = settings.getWeight(CharacterSetArrayIndex.EXTCHARS);
        }
        if (settings.isOptionAllowDuplicateCharacters()) {
            startOffset ^= 0x20;
        }
        int lcaseOffset = startOffset + Math.abs(settings.getPasswordLength() * versionBytesSum);
        int ucaseOffset = startOffset + Math.abs(settings.getPasswordLength() & versionBytesSum);
        int numOffset = startOffset + Math.abs(settings.getPasswordLength() + versionBytesSum);
        int scharOffset = startOffset + Math.abs(settings.getPasswordLength() | versionBytesSum);
        int extcharOffset = startOffset + Math.abs(settings.getPasswordLength() ^ versionBytesSum);
        int phraseStart = phraseBytesSum + startOffset;
        int phraseIndex = ArrayUtil.pickIndex(phraseStart, phraseBytes.length);
        int nameStart = namesBytesSum + startOffset;
        int nameIndex = ArrayUtil.pickIndex(nameStart, nameBytes.length);
        int xorStart = xorBytesSum + startOffset;
        int xorIndex = ArrayUtil.pickIndex(xorStart, xorBytes.length);
        ArrayList<Character> lowerCase = new ArrayList<Character>();
        ArrayList upperCase = new ArrayList();
        ArrayList numbers = new ArrayList();
        ArrayList specialChars = new ArrayList();
        ArrayList extChars = new ArrayList();
        ArrayList<Integer> passwordIndexList = new ArrayList<Integer>();
        int i2 = 0;
        while (i2 < passwordLength) {
            passwordIndexList.add(i2);
            ++i2;
        }
        char[] password = new char[passwordLength];
        int currentLength = 0;
        CharacterSetArrayIndex nextArray = CharacterSetArrayIndex.LCHARS;
        while (currentLength < passwordLength) {
            int nextIndex = phraseBytes[phraseIndex] * nameBytes[nameIndex];
            int pickIndex = ArrayUtil.pickIndex(xorBytes[xorIndex], passwordIndexList.size());
            int passwordIndex = (Integer)passwordIndexList.get(pickIndex);
            passwordIndexList.remove(pickIndex);
            ArrayList<Character> nextList = lowerCase;
            char[] nextRefill = Constants.lchars;
            boolean haveNext = false;
            while (!haveNext) {
                if (nextArray == CharacterSetArrayIndex.LCHARS && settings.isOptionUseLCase()) {
                    haveNext = true;
                    nextIndex += lcaseOffset;
                } else if (nextArray == CharacterSetArrayIndex.UCHARS && settings.isOptionUseUCase()) {
                    haveNext = true;
                    nextList = upperCase;
                    nextRefill = Constants.uchars;
                    nextIndex += ucaseOffset;
                } else if (nextArray == CharacterSetArrayIndex.NUMS && settings.isOptionUseNumbers()) {
                    haveNext = true;
                    nextList = numbers;
                    nextRefill = Constants.nums;
                    nextIndex += numOffset;
                } else if (nextArray == CharacterSetArrayIndex.EXTCHARS && settings.isOptionUseExtChars()) {
                    haveNext = true;
                    nextList = extChars;
                    nextRefill = Constants.extchars;
                    nextIndex += extcharOffset;
                } else if (nextArray == CharacterSetArrayIndex.SCHARS && settings.isOptionUseSChars()) {
                    haveNext = true;
                    nextList = specialChars;
                    char[] limitSpecialChars = settings.getLimitSpecialChars();
                    nextRefill = limitSpecialChars != null && limitSpecialChars.length > 0 ? limitSpecialChars : Constants.schars;
                    nextIndex += scharOffset;
                }
                if (haveNext) continue;
                int nextArrayIndex = nextArray.getValue() + 1;
                nextArray = nextArray.getCharacterSetArrayIndex(nextArrayIndex);
            }
            if (nextIndex < 0) {
                nextIndex = Math.abs(nextIndex);
            }
            password[passwordIndex] = ArrayUtil.pickChar(nextList, nextIndex, remove, nextRefill);
            ++currentLength;
            if (++phraseIndex >= phraseBytes.length) {
                phraseIndex = 0;
            }
            if (++nameIndex >= nameBytes.length) {
                nameIndex = 0;
            }
            if (++xorIndex >= xorBytes.length) {
                xorIndex = 0;
            }
            int nextArrayWeightIndex = nextArray.getValue();
            nextArrayWeights[nextArrayWeightIndex] = !remove ? nextArrayWeights[nextArrayWeightIndex] * 0.9 : nextArrayWeights[nextArrayWeightIndex] * ((double)nextList.size() / (double)nextRefill.length);
            int nextArrayIndex = ArrayUtil.maxElementIndex(nextArrayWeights);
            nextArray = nextArray.getCharacterSetArrayIndex(nextArrayIndex);
        }
        return new String(password);
    }

    public static class Constants {
        public static final char[] lchars = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        public static final char[] uchars = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
        public static final char[] nums = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        public static final char[] schars = new char[]{'!', '@', '#', '$', '%', '^', '&', '*', '-', '=', '+', ':', ';', '?', ',', '.'};
        public static final char[] extchars = new char[]{'\u00c0', '\u00c1', '\u00c2', '\u00c3', '\u00c4', '\u00c5', '\u00c6', '\u00c7', '\u00c8', '\u00c9', '\u00ca', '\u00cb', '\u00cc', '\u00cd', '\u00ce', '\u00cf', '\u00d0', '\u00d1', '\u00d2', '\u00d3', '\u00d4', '\u00d5', '\u00d6', '\u00d8', '\u00d9', '\u00da', '\u00db', '\u00dc', '\u00dd', '\u00de', '\u00df', '\u00e0', '\u00e1', '\u00e2', '\u00e3', '\u00e4', '\u00e5', '\u00e6', '\u00e7', '\u00e8', '\u00e9', '\u00ea', '\u00eb', '\u00ec', '\u00ed', '\u00ee', '\u00ef', '\u00f0', '\u00f1', '\u00f2', '\u00f3', '\u00f4', '\u00f5', '\u00f6', '\u00f7', '\u00f8', '\u00f9', '\u00fa', '\u00fb', '\u00fc', '\u00fd', '\u00fe', '\u00ff'};
        public static final int MIN_LENGTH = 4;
        public static final int MAX_LENGTH = 128;
        public static final int CURRENT_ALGORITHM_VERSION = 2;
    }
}

