/*
 * Decompiled with CFR 0.152.
 */
package com.huguesjohnson.narpas;

import com.huguesjohnson.dubbel.util.StringComparator;
import com.huguesjohnson.narpas.PasswordSetting;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public abstract class NarpasUtil {
    public static final String DEFAULT_NO_CATEGORY = "[Unsorted]";
    public static final String DEFAULT_ALL_CATEGORY = "";

    public static List<String> getAllCategories(List<PasswordSetting> list) {
        ArrayList<String> categories = new ArrayList<String>();
        for (PasswordSetting ps : list) {
            String c = ps.getCategory();
            if (c == null || c.length() < 1) {
                c = DEFAULT_NO_CATEGORY;
            }
            if (categories.contains(c)) continue;
            categories.add(c);
        }
        categories.sort(new StringComparator());
        return categories;
    }

    public static List<PasswordSetting> prepV2Migrate(List<PasswordSetting> list) {
        long lastUsed = System.currentTimeMillis();
        for (PasswordSetting ps : list) {
            String uuid;
            String c = ps.getCategory();
            if (c == null || c.length() < 1) {
                ps.setCategory(DEFAULT_NO_CATEGORY);
            }
            if ((uuid = ps.getUuid()) == null || uuid.length() < 1) {
                ps.setUuid(UUID.randomUUID().toString());
            }
            if (ps.getLastUsed() > 0L) continue;
            ps.setLastUsed(lastUsed);
        }
        return list;
    }
}

