/*
 * Decompiled with CFR 0.152.
 */
package com.huguesjohnson.narpas;

import com.huguesjohnson.narpas.CharacterSetArrayIndex;
import java.util.UUID;

public class PasswordSetting {
    private String passwordName;
    private boolean optionUseLCase;
    private boolean optionUseUCase;
    private boolean optionUseNumbers;
    private boolean optionUseSChars;
    private boolean optionUseExtChars;
    private boolean optionAllowDuplicateCharacters;
    private int passwordLength;
    private String passwordNotes;
    private String category;
    private int algorithmVersion = 1;
    private String passwordVersion = "";
    private char[] limitSpecialChars = null;
    private long lastUsed;
    private String uuid;
    private double[] weights = new double[]{1.0, 1.0, 1.0, 1.0, 1.0};

    public int hashCode() {
        if (this.passwordName == null) {
            return 0;
        }
        return this.passwordName.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != PasswordSetting.class) {
            return false;
        }
        PasswordSetting compareToObj = (PasswordSetting)obj;
        String uuid = compareToObj.getUuid();
        if (this.uuid == null || uuid == null) {
            return false;
        }
        return this.uuid.equals(uuid);
    }

    public PasswordSetting() {
        this.lastUsed = System.currentTimeMillis();
        this.uuid = UUID.randomUUID().toString();
    }

    public double getWeight(CharacterSetArrayIndex characterSet) {
        return this.weights[characterSet.getValue()];
    }

    public void setWeight(CharacterSetArrayIndex characterSet, double weight) {
        this.weights[characterSet.getValue()] = weight;
    }

    public boolean compare(PasswordSetting setting) {
        if (setting == null) {
            return false;
        }
        if (this.optionAllowDuplicateCharacters != setting.isOptionAllowDuplicateCharacters()) {
            return false;
        }
        if (this.optionUseLCase != setting.isOptionUseLCase()) {
            return false;
        }
        if (this.optionUseUCase != setting.isOptionUseUCase()) {
            return false;
        }
        if (this.optionUseNumbers != setting.isOptionUseNumbers()) {
            return false;
        }
        if (this.optionUseSChars != setting.isOptionUseSChars()) {
            return false;
        }
        if (this.optionUseExtChars != setting.isOptionUseExtChars()) {
            return false;
        }
        if (this.passwordLength != setting.getPasswordLength()) {
            return false;
        }
        if (this.algorithmVersion != setting.getAlgorithmVersion()) {
            return false;
        }
        if (this.getWeight(CharacterSetArrayIndex.LCHARS) != setting.getWeight(CharacterSetArrayIndex.LCHARS)) {
            return false;
        }
        if (this.getWeight(CharacterSetArrayIndex.UCHARS) != setting.getWeight(CharacterSetArrayIndex.UCHARS)) {
            return false;
        }
        if (this.getWeight(CharacterSetArrayIndex.NUMS) != setting.getWeight(CharacterSetArrayIndex.NUMS)) {
            return false;
        }
        if (this.getWeight(CharacterSetArrayIndex.SCHARS) != setting.getWeight(CharacterSetArrayIndex.SCHARS)) {
            return false;
        }
        if (this.getWeight(CharacterSetArrayIndex.EXTCHARS) != setting.getWeight(CharacterSetArrayIndex.EXTCHARS)) {
            return false;
        }
        String s = setting.getPasswordName();
        if (this.passwordName == null ? s != null : !this.passwordName.equals(s)) {
            return false;
        }
        s = setting.getPasswordNotes();
        if (this.passwordNotes == null ? s != null : !this.passwordNotes.equals(s)) {
            return false;
        }
        s = setting.getPasswordVersion();
        if (this.passwordVersion == null ? s != null : !this.passwordVersion.equals(s)) {
            return false;
        }
        s = setting.getCategory();
        if (this.category == null ? s != null : !this.category.equals(s)) {
            return false;
        }
        char[] lsc = setting.getLimitSpecialChars();
        if (this.limitSpecialChars == null) {
            if (lsc != null) {
                return false;
            }
        } else {
            if (lsc == null) {
                return false;
            }
            int length = this.limitSpecialChars.length;
            if (length != lsc.length) {
                return false;
            }
            int i = 0;
            while (i < length) {
                if (this.limitSpecialChars[i] != lsc[i]) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public String toString() {
        return this.passwordName;
    }

    public String getPasswordName() {
        return this.passwordName;
    }

    public void setPasswordName(String passwordName) {
        this.passwordName = passwordName;
    }

    public boolean isOptionUseLCase() {
        return this.optionUseLCase;
    }

    public void setOptionUseLCase(boolean optionUseLCase) {
        this.optionUseLCase = optionUseLCase;
    }

    public boolean isOptionUseUCase() {
        return this.optionUseUCase;
    }

    public void setOptionUseUCase(boolean optionUseUCase) {
        this.optionUseUCase = optionUseUCase;
    }

    public boolean isOptionUseNumbers() {
        return this.optionUseNumbers;
    }

    public void setOptionUseNumbers(boolean optionUseNumbers) {
        this.optionUseNumbers = optionUseNumbers;
    }

    public boolean isOptionUseSChars() {
        return this.optionUseSChars;
    }

    public void setOptionUseSChars(boolean optionUseSChars) {
        this.optionUseSChars = optionUseSChars;
    }

    public boolean isOptionUseExtChars() {
        return this.optionUseExtChars;
    }

    public void setOptionUseExtChars(boolean optionUseExtChars) {
        this.optionUseExtChars = optionUseExtChars;
    }

    public boolean isOptionAllowDuplicateCharacters() {
        return this.optionAllowDuplicateCharacters;
    }

    public void setOptionAllowDuplicateCharacters(boolean optionAllowDuplicateCharacters) {
        this.optionAllowDuplicateCharacters = optionAllowDuplicateCharacters;
    }

    public int getPasswordLength() {
        return this.passwordLength;
    }

    public void setPasswordLength(int passwordLength) {
        this.passwordLength = passwordLength;
    }

    public String getPasswordNotes() {
        return this.passwordNotes;
    }

    public void setPasswordNotes(String passwordNotes) {
        this.passwordNotes = passwordNotes;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public int getAlgorithmVersion() {
        return this.algorithmVersion;
    }

    public void setAlgorithmVersion(int algorithmVersion) {
        this.algorithmVersion = algorithmVersion;
    }

    public char[] getLimitSpecialChars() {
        return this.limitSpecialChars;
    }

    public void setLimitSpecialChars(char[] limitSpecialChars) {
        this.limitSpecialChars = limitSpecialChars;
    }

    public long getLastUsed() {
        return this.lastUsed;
    }

    public void setLastUsed(long lastUsed) {
        this.lastUsed = lastUsed;
    }

    public PasswordSetting(String passwordName, boolean optionUseLCase, boolean optionUseUCase, boolean optionUseNumbers, boolean optionUseSChars, boolean optionUseExtChars, int passwordLength, String passwordNotes, String category, int algorithmVersion, String passwordVersion, char[] limitSpecialChars, long lastUsed) {
        this();
        this.passwordName = passwordName;
        this.optionUseLCase = optionUseLCase;
        this.optionUseUCase = optionUseUCase;
        this.optionUseNumbers = optionUseNumbers;
        this.optionUseSChars = optionUseSChars;
        this.optionUseExtChars = optionUseExtChars;
        this.passwordLength = passwordLength;
        this.passwordNotes = passwordNotes;
        this.category = category;
        this.algorithmVersion = algorithmVersion;
        this.passwordVersion = passwordVersion;
        this.limitSpecialChars = limitSpecialChars;
        this.lastUsed = lastUsed;
    }

    public PasswordSetting(String passwordName, boolean optionUseLCase, boolean optionUseUCase, boolean optionUseNumbers, boolean optionUseSChars, int passwordLength, String passwordNotes) {
        this();
        this.passwordName = passwordName;
        this.optionUseLCase = optionUseLCase;
        this.optionUseUCase = optionUseUCase;
        this.optionUseNumbers = optionUseNumbers;
        this.optionUseSChars = optionUseSChars;
        this.passwordLength = passwordLength;
        this.passwordNotes = passwordNotes;
    }

    public PasswordSetting(String passwordName, boolean optionUseLCase, boolean optionUseUCase, boolean optionUseNumbers, boolean optionUseSChars, int passwordLength) {
        this();
        this.passwordName = passwordName;
        this.optionUseLCase = optionUseLCase;
        this.optionUseUCase = optionUseUCase;
        this.optionUseNumbers = optionUseNumbers;
        this.optionUseSChars = optionUseSChars;
        this.passwordLength = passwordLength;
    }

    public String getPasswordVersion() {
        return this.passwordVersion;
    }

    public void setPasswordVersion(String passwordVersion) {
        this.passwordVersion = passwordVersion;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }
}

