/*
 * Decompiled with CFR 0.152.
 */
package com.huguesjohnson.narpas.test;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.huguesjohnson.dubbel.util.ArrayUtil;
import com.huguesjohnson.narpas.CharacterSetArrayIndex;
import com.huguesjohnson.narpas.Narpas;
import com.huguesjohnson.narpas.NarpasUtil;
import com.huguesjohnson.narpas.PasswordSetting;
import com.huguesjohnson.narpas.PasswordSettingDateComparator;
import com.huguesjohnson.narpas.PasswordSettingNameComparator;
import com.huguesjohnson.narpas.StringEncryptDecrypt;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import junit.framework.TestCase;
import org.junit.Test;

public class Narpas_FunctionalTest
extends TestCase {
    @Test
    public void test_computeHash() {
        String input = "I like pie";
        int length = 32;
        String hash = Narpas.computeHash(input, length);
        Narpas_FunctionalTest.assertEquals((String)"39d74f597a854b15819d46422e26879a", (String)hash);
        input = "Facebook";
        length = 32;
        hash = Narpas.computeHash(input, length);
        Narpas_FunctionalTest.assertEquals((String)"d85544fce402c7a2a96a48078edaf203", (String)hash);
    }

    @Test
    public void test_v1generatePassword() {
        try {
            String passPhrase = "I like pie";
            String passwordName = "Facebook";
            boolean useLCase = true;
            boolean useUCase = true;
            boolean useNumbers = true;
            boolean useSpecialCharacters = true;
            int basePasswordLength = 1;
            String password = Narpas.generatePassword(passPhrase, passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            Narpas_FunctionalTest.assertEquals((String)"Io3!1+aW", (String)password);
            PasswordSetting settings = new PasswordSetting(passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            String password2 = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)password, (String)password2);
            basePasswordLength = 2;
            password = Narpas.generatePassword(passPhrase, passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            Narpas_FunctionalTest.assertEquals((String)"S^l4$aA1f6%Ke2!C", (String)password);
            settings = new PasswordSetting(passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            password2 = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)password, (String)password2);
            basePasswordLength = 4;
            password = Narpas.generatePassword(passPhrase, passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            Narpas_FunctionalTest.assertEquals((String)"a8!L6Uy@%Bf4O.2dl*M39xS$5#Ws?I1t", (String)password);
            settings = new PasswordSetting(passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            password2 = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)password, (String)password2);
            basePasswordLength = 8;
            password = Narpas.generatePassword(passPhrase, passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            Narpas_FunctionalTest.assertEquals((String)"3Ie?$Ha9U^5ou.J04tA*2,GrlP1#!T8j6@Fk=7bL7h%S-Bi9:R6qCn0&+N3fv1;X", (String)password);
            settings = new PasswordSetting(passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            password2 = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)password, (String)password2);
            basePasswordLength = 16;
            password = Narpas.generatePassword(passPhrase, passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            Narpas_FunctionalTest.assertEquals((String)"U-0oc:R45aG?1=NjbA6%*B8l2+Yq.3dM9w@S$Eg7;O7xFv4#n8,C!1IpD&r5T6e^%Z9tHu,0=3Xh@s2Lf5-J2iW.3mV!?K0y+Pk9zQ*4a1:XA6n#^F7ly8&W8Od;$Jb6", (String)password);
            settings = new PasswordSetting(passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            password2 = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)password, (String)password2);
            passPhrase = "i like pie";
            passwordName = "Facebook";
            basePasswordLength = 1;
            password = Narpas.generatePassword(passPhrase, passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            Narpas_FunctionalTest.assertEquals((String)"5K+m3Ca?", (String)password);
            settings = new PasswordSetting(passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            password2 = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)password, (String)password2);
            basePasswordLength = 2;
            password = Narpas.generatePassword(passPhrase, passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            Narpas_FunctionalTest.assertEquals((String)"I$j0u:1L!6cDM&i2", (String)password);
            settings = new PasswordSetting(passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            password2 = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)password, (String)password2);
            basePasswordLength = 4;
            password = Narpas.generatePassword(passPhrase, passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            Narpas_FunctionalTest.assertEquals((String)"8Ai$.L6a0U!ojK:91&Ypb5Z^4q%RN2*m", (String)password);
            settings = new PasswordSetting(passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            password2 = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)password, (String)password2);
            basePasswordLength = 8;
            password = Narpas.generatePassword(passPhrase, passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            Narpas_FunctionalTest.assertEquals((String)"@I8p0H?beE,59#Zqg6A:1h&LR2;sc3+Oa4N!vY$7xU4=.d2BC5y^Dj%7F8*f3Gt-", (String)password);
            settings = new PasswordSetting(passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            password2 = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)password, (String)password2);
            basePasswordLength = 16;
            password = Narpas.generatePassword(passPhrase, passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            Narpas_FunctionalTest.assertEquals((String)"kS%60&Reb1M.5j,JN8!uz9@Ha2O$qL^4vA3#*w7BK2s-Gc+4W7=d;1Tr0:nD3?fX8.Yx%g5U6hC#E$p9i5=VyQ3?F8@lI!0m7oP&4tZ*;Au6-kU1G2^e9Yi+:E0j7K,p", (String)password);
            settings = new PasswordSetting(passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            password2 = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)password, (String)password2);
            passPhrase = "i like pie";
            passwordName = "facebook";
            basePasswordLength = 1;
            password = Narpas.generatePassword(passPhrase, passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            Narpas_FunctionalTest.assertEquals((String)"l0;MW1k?", (String)password);
            settings = new PasswordSetting(passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            password2 = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)password, (String)password2);
            basePasswordLength = 2;
            password = Narpas.generatePassword(passPhrase, passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            Narpas_FunctionalTest.assertEquals((String)"!J4lD:u7a;Q3jV0&", (String)password);
            settings = new PasswordSetting(passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            password2 = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)password, (String)password2);
            basePasswordLength = 4;
            password = Narpas.generatePassword(passPhrase, passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            Narpas_FunctionalTest.assertEquals((String)",r0J9vD+iA1:2c-V3?eSp6Z.l^E7;X4w", (String)password);
            settings = new PasswordSetting(passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            password2 = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)password, (String)password2);
            basePasswordLength = 8;
            password = Narpas.generatePassword(passPhrase, passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            Narpas_FunctionalTest.assertEquals((String)"0wA*eG4@1x,M2#tJa5B=q:T9Cu3?6k&D7-bY8W!ysH0^n%N41$vE+oQ7;K9c.d3L", (String)password);
            settings = new PasswordSetting(passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            password2 = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)password, (String)password2);
            basePasswordLength = 16;
            password = Narpas.generatePassword(passPhrase, passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            Narpas_FunctionalTest.assertEquals((String)"6e,M3!aAd5O#g&V0Tp1?2t@R4.bS9U=cyB7-u;Y82^oC+fH86*jQw1$NPs0%:Er3hW4#9Dm,!F5x-Xk70iK@+n6G*3vJ5&qIlL$7%1Zz.2cG=V4o;A9d:u8Y4hS?aB2^", (String)password);
            settings = new PasswordSetting(passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            password2 = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)password, (String)password2);
            passPhrase = "I like pie";
            passwordName = "Facebook";
            useLCase = true;
            useUCase = false;
            useNumbers = false;
            useSpecialCharacters = false;
            basePasswordLength = 1;
            password = Narpas.generatePassword(passPhrase, passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            Narpas_FunctionalTest.assertEquals((String)"aytlnfbq", (String)password);
            settings = new PasswordSetting(passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            password2 = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)password, (String)password2);
            basePasswordLength = 2;
            password = Narpas.generatePassword(passPhrase, passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            Narpas_FunctionalTest.assertEquals((String)"eaopixcbdqfyltus", (String)password);
            settings = new PasswordSetting(passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            password2 = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)password, (String)password2);
            basePasswordLength = 4;
            password = Narpas.generatePassword(passPhrase, passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            Narpas_FunctionalTest.assertEquals((String)"uaftrsmgwobjcxqelpdnyhvkizsvxhgr", (String)password);
            settings = new PasswordSetting(passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            password2 = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)password, (String)password2);
            basePasswordLength = 8;
            password = Narpas.generatePassword(passPhrase, passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            Narpas_FunctionalTest.assertEquals((String)"wopmcfvtzxksnaqbdgiujrehylwaefjzxbcqtrdugkhysnipvlmogickahbdylvp", (String)password);
            settings = new PasswordSetting(passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            password2 = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)password, (String)password2);
            basePasswordLength = 16;
            password = Narpas.generatePassword(passPhrase, passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            Narpas_FunctionalTest.assertEquals((String)"jalhygbpizfocsermuqdknxvtwcxhraslnoyjbdtpfqwguevikmzmkoecuvpltgynqhbjwrxsaifdzsvxhpenifjlaotkrmwbcqdyugzjahlfoqnbikmpwtscgrxzduy", (String)password);
            settings = new PasswordSetting(passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            password2 = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)password, (String)password2);
            passPhrase = "I like pie";
            passwordName = "Facebook";
            useLCase = false;
            useUCase = true;
            useNumbers = false;
            useSpecialCharacters = false;
            basePasswordLength = 1;
            password = Narpas.generatePassword(passPhrase, passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            Narpas_FunctionalTest.assertEquals((String)"EAOPIXCB", (String)password);
            settings = new PasswordSetting(passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            password2 = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)password, (String)password2);
            basePasswordLength = 2;
            password = Narpas.generatePassword(passPhrase, passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            Narpas_FunctionalTest.assertEquals((String)"UAFTRSMGWOBJCXQE", (String)password);
            settings = new PasswordSetting(passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            password2 = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)password, (String)password2);
            basePasswordLength = 4;
            password = Narpas.generatePassword(passPhrase, passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            Narpas_FunctionalTest.assertEquals((String)"TZSCJIVQLXAWGOBKDFMUNREHYPEAOPIX", (String)password);
            settings = new PasswordSetting(passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            password2 = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)password, (String)password2);
            basePasswordLength = 8;
            password = Narpas.generatePassword(passPhrase, passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            Narpas_FunctionalTest.assertEquals((String)"JAKHESBNYURXTCDFVOGQPILZMWCEGUWPQSVIYODZHJFRTKLXMBANCGORYENQHXID", (String)password);
            settings = new PasswordSetting(passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            password2 = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)password, (String)password2);
            basePasswordLength = 16;
            password = Narpas.generatePassword(passPhrase, passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            Narpas_FunctionalTest.assertEquals((String)"ABFQNUZVCOKWIRMPXYHEDGSJLTPDBCQMLTAJIEWHYOSXFUVRKNGZQAFMKJPVNEBCIDGZLHUYORWTSXYFAXIZDTBCJEGOQMHWNSPVKLRUIGMFZTBOUDQWEASCHYNRLPKJ", (String)password);
            settings = new PasswordSetting(passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            password2 = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)password, (String)password2);
            passPhrase = "Please no more California songs";
            passwordName = "orakio@mailinator.com";
            useLCase = true;
            useUCase = true;
            useNumbers = true;
            useSpecialCharacters = true;
            basePasswordLength = 1;
            password = Narpas.generatePassword(passPhrase, passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            Narpas_FunctionalTest.assertEquals((String)"V%v08sK+", (String)password);
            settings = new PasswordSetting(passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            password2 = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)password, (String)password2);
            basePasswordLength = 2;
            password = Narpas.generatePassword(passPhrase, passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            Narpas_FunctionalTest.assertEquals((String)"8*aVt^M6n0,ARu1&", (String)password);
            settings = new PasswordSetting(passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            password2 = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)password, (String)password2);
            basePasswordLength = 4;
            password = Narpas.generatePassword(passPhrase, passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            Narpas_FunctionalTest.assertEquals((String)"7=kFn?T5!a4Am.R3@Jh69o,Y0v&L8Wu-", (String)password);
            settings = new PasswordSetting(passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            password2 = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)password, (String)password2);
            basePasswordLength = 8;
            password = Narpas.generatePassword(passPhrase, passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            Narpas_FunctionalTest.assertEquals((String)"r!I6;a9Dj?R4@Yd03y-T1p*H2A#bC7e:$t8K5%OvP^1uZ7o=,0mG&k2S8Js+6.cX", (String)password);
            settings = new PasswordSetting(passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            password2 = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)password, (String)password2);
            basePasswordLength = 16;
            password = Narpas.generatePassword(passPhrase, passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            Narpas_FunctionalTest.assertEquals((String)"o:M7=Kb34a%C0g,N5Y$nE8u-&j6X2^UpT*9kO1f+?0lH@q1Ic4P!.2yR3rF#8v;AxS5%Z:7dL9e*6D;hw!J0B7z?i=1Qm2@G,sV5t3W#Ae$46z^B8Kq&9-dMa+U0.j8V", (String)password);
            settings = new PasswordSetting(passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            password2 = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)password, (String)password2);
            passPhrase = "Please no more california songs";
            passwordName = "orakio@mailinator.com";
            basePasswordLength = 1;
            password = Narpas.generatePassword(passPhrase, passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            Narpas_FunctionalTest.assertEquals((String)"Tm2%K?u0", (String)password);
            settings = new PasswordSetting(passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            password2 = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)password, (String)password2);
            basePasswordLength = 2;
            password = Narpas.generatePassword(passPhrase, passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            Narpas_FunctionalTest.assertEquals((String)"-c4BSa+2U!i0N6$l", (String)password);
            settings = new PasswordSetting(passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            password2 = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)password, (String)password2);
            basePasswordLength = 4;
            password = Narpas.generatePassword(passPhrase, passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            Narpas_FunctionalTest.assertEquals((String)"Or-6Uj?08i,CG=o4%5gSL#y1k2N!&3Eq", (String)password);
            settings = new PasswordSetting(passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            password2 = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)password, (String)password2);
            basePasswordLength = 8;
            password = Narpas.generatePassword(passPhrase, passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            Narpas_FunctionalTest.assertEquals((String)"Pi-14v&GE:a8@0mJU!w2r3B#f5F+kO%6$s7TA9^ye*R0=Xb1cC;8?N2n,3VoKu.9", (String)password);
            settings = new PasswordSetting(passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            password2 = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)password, (String)password2);
            basePasswordLength = 16;
            password = Narpas.generatePassword(passPhrase, passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            Narpas_FunctionalTest.assertEquals((String)"M#m7+6aUQ;h2n0X$q5Y%uH^4-b8AI1=ei*B9!Wy3cN?3:E0lr4.C@L7k,9FsdJ&1!xD8V:6ftP2?5,gZO@6vj3S*5oG$Kz+4Rp0&wT-12#iCt7S%^8QxXl.9Ay=04k;W", (String)password);
            settings = new PasswordSetting(passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            password2 = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)password, (String)password2);
            passPhrase = "Please no more California songs";
            passwordName = "orakio@mailinator.com";
            useLCase = false;
            useUCase = false;
            useNumbers = true;
            useSpecialCharacters = false;
            basePasswordLength = 1;
            password = Narpas.generatePassword(passPhrase, passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            Narpas_FunctionalTest.assertEquals((String)"27510698", (String)password);
            settings = new PasswordSetting(passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            password2 = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)password, (String)password2);
            basePasswordLength = 2;
            password = Narpas.generatePassword(passPhrase, passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            Narpas_FunctionalTest.assertEquals((String)"6345021789081327", (String)password);
            settings = new PasswordSetting(passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            password2 = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)password, (String)password2);
            basePasswordLength = 4;
            password = Narpas.generatePassword(passPhrase, passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            Narpas_FunctionalTest.assertEquals((String)"40187236954630125798275106983401", (String)password);
            settings = new PasswordSetting(passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            password2 = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)password, (String)password2);
            basePasswordLength = 8;
            password = Narpas.generatePassword(passPhrase, passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            Narpas_FunctionalTest.assertEquals((String)"4057321689984562013787019523644107623859078461235904871325961709", (String)password);
            settings = new PasswordSetting(passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            password2 = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)password, (String)password2);
            basePasswordLength = 16;
            password = Narpas.generatePassword(passPhrase, passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            Narpas_FunctionalTest.assertEquals((String)"80157429366301297548930152468704127683958641790325061374925825036198474520183679294015836716203457984705198326016234587920195364", (String)password);
            settings = new PasswordSetting(passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            password2 = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)password, (String)password2);
            passPhrase = "Please no more California songs";
            passwordName = "orakio@mailinator.com";
            useLCase = false;
            useUCase = false;
            useNumbers = true;
            useSpecialCharacters = true;
            basePasswordLength = 1;
            password = Narpas.generatePassword(passPhrase, passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            Narpas_FunctionalTest.assertEquals((String)";12?6=0#", (String)password);
            settings = new PasswordSetting(passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            password2 = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)password, (String)password2);
            basePasswordLength = 2;
            password = Narpas.generatePassword(passPhrase, passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            Narpas_FunctionalTest.assertEquals((String)"5!3$4=0*6^.1%27-", (String)password);
            settings = new PasswordSetting(passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            password2 = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)password, (String)password2);
            basePasswordLength = 4;
            password = Narpas.generatePassword(passPhrase, passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            Narpas_FunctionalTest.assertEquals((String)"4:9+0@1$.2*68^3?!75,2#-43%&60;1=", (String)password);
            settings = new PasswordSetting(passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            password2 = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)password, (String)password2);
            basePasswordLength = 8;
            password = Narpas.generatePassword(passPhrase, passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            Narpas_FunctionalTest.assertEquals((String)"4#0:!3,61@9$+57%2-^88*.73&=1?49;-6!02@#5;6+3$08%^71=&2.45*9,1:0?", (String)password);
            settings = new PasswordSetting(passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            password2 = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)password, (String)password2);
            basePasswordLength = 16;
            password = Narpas.generatePassword(passPhrase, passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            Narpas_FunctionalTest.assertEquals((String)"8!2@&73=4+?90%#15:.6,01*$6^85;-2!3*4@79:#45$,1?30-2+%96&8^7.2;=46%9&;0=8,51^3!#72-0@$75+8*.43:?9-16:4!7+*6?50%;12@3#8,9&2^0$=8.1", (String)password);
            settings = new PasswordSetting(passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            password2 = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)password, (String)password2);
            passPhrase = "Please no more California songs";
            passwordName = "orakio@mailinator.com";
            useLCase = false;
            useUCase = true;
            useNumbers = true;
            useSpecialCharacters = false;
            basePasswordLength = 1;
            password = Narpas.generatePassword(passPhrase, passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            Narpas_FunctionalTest.assertEquals((String)"2CW4E5Q7", (String)password);
            settings = new PasswordSetting(passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            password2 = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)password, (String)password2);
            basePasswordLength = 2;
            password = Narpas.generatePassword(passPhrase, passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            Narpas_FunctionalTest.assertEquals((String)"M1A0F5D8Y39K7NU6", (String)password);
            settings = new PasswordSetting(passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            password2 = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)password, (String)password2);
            basePasswordLength = 4;
            password = Narpas.generatePassword(passPhrase, passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            Narpas_FunctionalTest.assertEquals((String)"R8U5D1X24M7ZO0L36QA9T12VG50EI4B8", (String)password);
            settings = new PasswordSetting(passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            password2 = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)password, (String)password2);
            basePasswordLength = 8;
            password = Narpas.generatePassword(passPhrase, passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            Narpas_FunctionalTest.assertEquals((String)"A7B80J1RO2F45PM6E93CS60YD37H8GT41I2QX59N6K2V1WL94UZ03W5VS7P8I1H0", (String)password);
            settings = new PasswordSetting(passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            password2 = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)password, (String)password2);
            basePasswordLength = 16;
            password = Narpas.generatePassword(passPhrase, passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            Narpas_FunctionalTest.assertEquals((String)"A2C73IF4B01UN68XS95K4OM35Y7ET16J0D2Z8GL94HR30P6QV9W51TZ2Q7M8F60YE3I74J9A5KG2L81WN6C40BR1S79XO53H2DV8P2U30W9EA17QB4J8N5V6U0Z19G4C", (String)password);
            settings = new PasswordSetting(passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, basePasswordLength);
            password2 = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)password, (String)password2);
        }
        catch (Exception x) {
            x.printStackTrace();
            Narpas_FunctionalTest.fail((String)x.getMessage());
        }
    }

    @Test
    public void test_toFromJson() {
        Random r = new Random();
        ArrayList<PasswordSetting> toList = new ArrayList<PasswordSetting>();
        PasswordSetting v1name1 = new PasswordSetting(UUID.randomUUID().toString(), r.nextBoolean(), r.nextBoolean(), r.nextBoolean(), r.nextBoolean(), 32, UUID.randomUUID().toString());
        toList.add(v1name1);
        PasswordSetting v1name2 = new PasswordSetting(UUID.randomUUID().toString(), r.nextBoolean(), r.nextBoolean(), r.nextBoolean(), r.nextBoolean(), 16);
        toList.add(v1name2);
        long now = System.currentTimeMillis();
        char[] limitSpecialChars = new char[]{'!', '@', '#', '$', '%'};
        int i = 0;
        while (i < 10) {
            PasswordSetting psv2 = new PasswordSetting();
            psv2.setPasswordName(UUID.randomUUID().toString());
            psv2.setOptionUseLCase(r.nextBoolean());
            psv2.setOptionUseUCase(r.nextBoolean());
            psv2.setOptionUseNumbers(r.nextBoolean());
            psv2.setOptionUseSChars(r.nextBoolean());
            psv2.setPasswordLength(r.nextInt());
            psv2.setPasswordNotes(UUID.randomUUID().toString());
            psv2.setCategory(UUID.randomUUID().toString());
            psv2.setAlgorithmVersion(2);
            psv2.setPasswordVersion(Integer.toString(r.nextInt()));
            psv2.setLimitSpecialChars(limitSpecialChars);
            psv2.setLastUsed(now);
            toList.add(psv2);
            ++i;
        }
        String json = new Gson().toJson(toList);
        ArrayList fromList = (ArrayList)new Gson().fromJson(json, new TypeToken<List<PasswordSetting>>(){}.getType());
        Narpas_FunctionalTest.assertNotNull((Object)fromList);
        int size = toList.size();
        Narpas_FunctionalTest.assertEquals((int)fromList.size(), (int)size);
        int i2 = 0;
        while (i2 < size) {
            PasswordSetting to = (PasswordSetting)toList.get(i2);
            PasswordSetting from = (PasswordSetting)fromList.get(i2);
            Narpas_FunctionalTest.assertEquals((boolean)from.isOptionUseLCase(), (boolean)to.isOptionUseLCase());
            Narpas_FunctionalTest.assertEquals((boolean)from.isOptionUseNumbers(), (boolean)to.isOptionUseNumbers());
            Narpas_FunctionalTest.assertEquals((boolean)from.isOptionUseSChars(), (boolean)to.isOptionUseSChars());
            Narpas_FunctionalTest.assertEquals((boolean)from.isOptionUseUCase(), (boolean)to.isOptionUseUCase());
            Narpas_FunctionalTest.assertEquals((int)from.getPasswordLength(), (int)to.getPasswordLength());
            Narpas_FunctionalTest.assertEquals((String)from.getPasswordName(), (String)to.getPasswordName());
            Narpas_FunctionalTest.assertEquals((String)from.getPasswordNotes(), (String)to.getPasswordNotes());
            int av = from.getAlgorithmVersion();
            Narpas_FunctionalTest.assertEquals((int)av, (int)to.getAlgorithmVersion());
            if (av > 1) {
                Narpas_FunctionalTest.assertEquals((String)from.getCategory(), (String)to.getCategory());
                Narpas_FunctionalTest.assertEquals((long)from.getLastUsed(), (long)to.getLastUsed());
                Narpas_FunctionalTest.assertEquals((String)from.getPasswordVersion(), (String)to.getPasswordVersion());
                char[] fromchars = from.getLimitSpecialChars();
                char[] tochars = to.getLimitSpecialChars();
                if (fromchars == null) {
                    if (tochars != null) {
                        Narpas_FunctionalTest.fail((String)"fromchars==null and tochars!=null");
                    }
                } else {
                    if (tochars == null) {
                        Narpas_FunctionalTest.fail((String)"fromchars!=null and tochars==null");
                    }
                    int l = fromchars.length;
                    Narpas_FunctionalTest.assertEquals((int)l, (int)tochars.length);
                    int j = 0;
                    while (j < l) {
                        Narpas_FunctionalTest.assertEquals((char)fromchars[j], (char)tochars[j]);
                        ++j;
                    }
                }
            }
            ++i2;
        }
    }

    @Test
    public void test_validate() {
        String passPhrase = "I like pie";
        PasswordSetting settings = new PasswordSetting();
        settings.setPasswordName("whatever");
        settings.setOptionUseLCase(true);
        settings.setOptionUseUCase(true);
        settings.setOptionUseSChars(true);
        settings.setOptionUseNumbers(true);
        settings.setOptionUseExtChars(true);
        settings.setPasswordLength(4);
        settings.setAlgorithmVersion(0);
        Narpas_FunctionalTest.assertTrue((boolean)Narpas.validate(passPhrase, settings));
        settings.setAlgorithmVersion(-1);
        Narpas_FunctionalTest.assertFalse((boolean)Narpas.validate(passPhrase, settings));
        settings.setAlgorithmVersion(3);
        Narpas_FunctionalTest.assertFalse((boolean)Narpas.validate(passPhrase, settings));
        settings.setAlgorithmVersion(2);
        Narpas_FunctionalTest.assertTrue((boolean)Narpas.validate(passPhrase, settings));
        settings.setPasswordName(passPhrase);
        Narpas_FunctionalTest.assertFalse((boolean)Narpas.validate(passPhrase, settings));
        settings.setPasswordName("something else");
        Narpas_FunctionalTest.assertTrue((boolean)Narpas.validate(passPhrase, settings));
        settings.setPasswordName("something else");
        settings.setOptionUseLCase(false);
        settings.setOptionUseUCase(false);
        settings.setOptionUseSChars(false);
        settings.setOptionUseNumbers(false);
        settings.setOptionUseExtChars(false);
        Narpas_FunctionalTest.assertFalse((boolean)Narpas.validate(passPhrase, settings));
        settings.setAlgorithmVersion(1);
        Narpas_FunctionalTest.assertFalse((boolean)Narpas.validate(passPhrase, settings));
        settings.setOptionUseExtChars(true);
        Narpas_FunctionalTest.assertFalse((boolean)Narpas.validate(passPhrase, settings));
        settings.setAlgorithmVersion(2);
        Narpas_FunctionalTest.assertFalse((boolean)Narpas.validate(null, settings));
        Narpas_FunctionalTest.assertFalse((boolean)Narpas.validate(passPhrase, null));
        settings.setPasswordName(null);
        Narpas_FunctionalTest.assertFalse((boolean)Narpas.validate(passPhrase, settings));
        settings.setPasswordName("");
        Narpas_FunctionalTest.assertFalse((boolean)Narpas.validate(passPhrase, settings));
        settings.setPasswordName("whatever");
        Narpas_FunctionalTest.assertFalse((boolean)Narpas.validate("", settings));
    }

    @Test
    public void test_v2limitSpecialChars() {
        try {
            String passPhrase = "I like pie";
            String passwordName = "test_limitSpecialChars";
            PasswordSetting settings = new PasswordSetting();
            char[] limitSpecialChars = new char[]{'*'};
            settings.setPasswordName(passwordName);
            settings.setAlgorithmVersion(2);
            settings.setPasswordLength(8);
            settings.setOptionUseLCase(false);
            settings.setOptionUseUCase(false);
            settings.setOptionUseSChars(true);
            settings.setOptionUseExtChars(false);
            settings.setOptionUseNumbers(false);
            settings.setLimitSpecialChars(limitSpecialChars);
            String password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"********", (String)password);
            settings.setLimitSpecialChars(null);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertNotSame((Object)"********", (Object)password);
            char[] limitSpecialChars2 = new char[]{'*', '@', '$', '%'};
            settings.setPasswordLength(32);
            settings.setLimitSpecialChars(limitSpecialChars2);
            password = Narpas.generatePassword(passPhrase, settings);
            int i = 0;
            while (i < password.length()) {
                char c = password.charAt(i);
                Narpas_FunctionalTest.assertTrue((c == '*' || c == '@' || c == '$' || c == '%' ? 1 : 0) != 0);
                ++i;
            }
        }
        catch (Exception x) {
            x.printStackTrace();
            Narpas_FunctionalTest.fail((String)x.getMessage());
        }
    }

    @Test
    public void test_passwordSettingHashString() {
        try {
            PasswordSetting settings = new PasswordSetting();
            settings.setPasswordName("example.com");
            settings.setAlgorithmVersion(2);
            settings.setOptionUseLCase(true);
            settings.setOptionUseUCase(true);
            settings.setOptionUseSChars(true);
            settings.setOptionUseExtChars(true);
            settings.setOptionUseNumbers(true);
            settings.setPasswordVersion("1");
            String hs = Narpas.passwordSettingHashString(settings);
            Narpas_FunctionalTest.assertEquals((String)"exa5m1ple.com1", (String)hs);
            settings.setPasswordVersion("2010");
            hs = Narpas.passwordSettingHashString(settings);
            Narpas_FunctionalTest.assertEquals((String)"25exam3ple.com2010", (String)hs);
            settings.setPasswordVersion("-666");
            hs = Narpas.passwordSettingHashString(settings);
            Narpas_FunctionalTest.assertEquals((String)"e4xampl1e.co2m-666", (String)hs);
        }
        catch (Exception x) {
            x.printStackTrace();
            Narpas_FunctionalTest.fail((String)x.getMessage());
        }
    }

    @Test
    public void test_v2CharacterSets() {
        try {
            boolean selectedCharsOnly;
            ArrayList<Character> lowerCase = new ArrayList<Character>();
            ArrayList<Character> upperCase = new ArrayList<Character>();
            ArrayList<Character> numbers = new ArrayList<Character>();
            ArrayList<Character> specialChars = new ArrayList<Character>();
            ArrayList<Character> limitSpecialChars = new ArrayList<Character>();
            ArrayList<Character> extChars = new ArrayList<Character>();
            char[] lsc = new char[]{'{', '}', '`', '[', ']'};
            ArrayUtil.fillArrayList(lowerCase, Narpas.Constants.lchars);
            ArrayUtil.fillArrayList(upperCase, Narpas.Constants.uchars);
            ArrayUtil.fillArrayList(numbers, Narpas.Constants.nums);
            ArrayUtil.fillArrayList(specialChars, Narpas.Constants.schars);
            ArrayUtil.fillArrayList(limitSpecialChars, lsc);
            ArrayUtil.fillArrayList(extChars, Narpas.Constants.extchars);
            int length = 128;
            PasswordSetting settings = new PasswordSetting("some arbitrary password name", true, false, false, false, false, length, "", "", 2, "0", null, 0L);
            String password = Narpas.generatePassword("lchar only test", settings);
            int i = 0;
            while (i < length) {
                Narpas_FunctionalTest.assertTrue((boolean)lowerCase.contains(Character.valueOf(password.charAt(i))));
                ++i;
            }
            settings.setOptionUseLCase(false);
            settings.setOptionUseUCase(true);
            password = Narpas.generatePassword("uchar only test", settings);
            i = 0;
            while (i < length) {
                Narpas_FunctionalTest.assertTrue((boolean)upperCase.contains(Character.valueOf(password.charAt(i))));
                ++i;
            }
            settings.setOptionUseUCase(false);
            settings.setOptionUseNumbers(true);
            password = Narpas.generatePassword("numbers only test", settings);
            i = 0;
            while (i < length) {
                Narpas_FunctionalTest.assertTrue((boolean)numbers.contains(Character.valueOf(password.charAt(i))));
                ++i;
            }
            settings.setOptionUseNumbers(false);
            settings.setOptionUseExtChars(true);
            password = Narpas.generatePassword("extended characters only test", settings);
            i = 0;
            while (i < length) {
                Narpas_FunctionalTest.assertTrue((boolean)extChars.contains(Character.valueOf(password.charAt(i))));
                ++i;
            }
            settings.setOptionUseExtChars(false);
            settings.setOptionUseSChars(true);
            password = Narpas.generatePassword("special characters only test", settings);
            i = 0;
            while (i < length) {
                Narpas_FunctionalTest.assertTrue((boolean)specialChars.contains(Character.valueOf(password.charAt(i))));
                ++i;
            }
            settings.setLimitSpecialChars(lsc);
            password = Narpas.generatePassword("limit special characters only test", settings);
            i = 0;
            while (i < length) {
                Narpas_FunctionalTest.assertTrue((boolean)limitSpecialChars.contains(Character.valueOf(password.charAt(i))));
                ++i;
            }
            settings.setOptionUseLCase(true);
            settings.setOptionUseUCase(true);
            settings.setOptionUseNumbers(true);
            password = Narpas.generatePassword("characters+numbers+limitspecial", settings);
            boolean hasLCase = false;
            boolean hasUCase = false;
            boolean hasNumber = false;
            boolean hasSpecialChar = false;
            int i2 = 0;
            while (i2 < length) {
                selectedCharsOnly = false;
                if (limitSpecialChars.contains(Character.valueOf(password.charAt(i2)))) {
                    selectedCharsOnly = true;
                    hasSpecialChar = true;
                } else if (numbers.contains(Character.valueOf(password.charAt(i2)))) {
                    selectedCharsOnly = true;
                    hasNumber = true;
                } else if (lowerCase.contains(Character.valueOf(password.charAt(i2)))) {
                    selectedCharsOnly = true;
                    hasLCase = true;
                } else if (upperCase.contains(Character.valueOf(password.charAt(i2)))) {
                    selectedCharsOnly = true;
                    hasUCase = true;
                }
                Narpas_FunctionalTest.assertTrue((boolean)selectedCharsOnly);
                ++i2;
            }
            if (!(hasLCase && hasUCase && hasNumber && hasSpecialChar)) {
                Narpas_FunctionalTest.fail((String)("Missing expected character set. Password=" + password));
            }
            settings.setOptionUseLCase(true);
            settings.setOptionUseUCase(true);
            settings.setOptionUseNumbers(true);
            settings.setLimitSpecialChars(null);
            hasLCase = false;
            hasUCase = false;
            hasNumber = false;
            hasSpecialChar = false;
            password = Narpas.generatePassword("characters+numbers+default special chars", settings);
            i2 = 0;
            while (i2 < length) {
                selectedCharsOnly = false;
                if (specialChars.contains(Character.valueOf(password.charAt(i2)))) {
                    selectedCharsOnly = true;
                    hasSpecialChar = true;
                } else if (numbers.contains(Character.valueOf(password.charAt(i2)))) {
                    selectedCharsOnly = true;
                    hasNumber = true;
                } else if (lowerCase.contains(Character.valueOf(password.charAt(i2)))) {
                    selectedCharsOnly = true;
                    hasLCase = true;
                } else if (upperCase.contains(Character.valueOf(password.charAt(i2)))) {
                    selectedCharsOnly = true;
                    hasUCase = true;
                }
                Narpas_FunctionalTest.assertTrue((boolean)selectedCharsOnly);
                ++i2;
            }
            if (!(hasLCase && hasUCase && hasNumber && hasSpecialChar)) {
                Narpas_FunctionalTest.fail((String)("Missing expected character set. Password=" + password));
            }
            settings.setOptionAllowDuplicateCharacters(true);
            settings.setOptionUseUCase(false);
            settings.setOptionUseNumbers(false);
            settings.setOptionUseSChars(false);
            password = Narpas.generatePassword("lchar+duplicate characters test", settings);
            i2 = 0;
            while (i2 < length) {
                Narpas_FunctionalTest.assertTrue((boolean)lowerCase.contains(Character.valueOf(password.charAt(i2))));
                ++i2;
            }
            settings.setOptionUseLCase(false);
            settings.setOptionUseUCase(true);
            password = Narpas.generatePassword("uchar+duplicate characters test", settings);
            i2 = 0;
            while (i2 < length) {
                Narpas_FunctionalTest.assertTrue((boolean)upperCase.contains(Character.valueOf(password.charAt(i2))));
                ++i2;
            }
            settings.setOptionUseUCase(false);
            settings.setOptionUseNumbers(true);
            password = Narpas.generatePassword("numbers+duplicate characters test", settings);
            i2 = 0;
            while (i2 < length) {
                Narpas_FunctionalTest.assertTrue((boolean)numbers.contains(Character.valueOf(password.charAt(i2))));
                ++i2;
            }
            settings.setOptionUseNumbers(false);
            settings.setOptionUseExtChars(true);
            password = Narpas.generatePassword("extended+duplicate characters test", settings);
            i2 = 0;
            while (i2 < length) {
                Narpas_FunctionalTest.assertTrue((boolean)extChars.contains(Character.valueOf(password.charAt(i2))));
                ++i2;
            }
            settings.setOptionUseExtChars(false);
            settings.setOptionUseSChars(true);
            password = Narpas.generatePassword("special characters+duplicate characters test", settings);
            i2 = 0;
            while (i2 < length) {
                Narpas_FunctionalTest.assertTrue((boolean)specialChars.contains(Character.valueOf(password.charAt(i2))));
                ++i2;
            }
            settings.setLimitSpecialChars(lsc);
            password = Narpas.generatePassword("limit special characters+duplicate characters test", settings);
            i2 = 0;
            while (i2 < length) {
                Narpas_FunctionalTest.assertTrue((boolean)limitSpecialChars.contains(Character.valueOf(password.charAt(i2))));
                ++i2;
            }
            settings.setOptionUseLCase(true);
            settings.setOptionUseUCase(true);
            settings.setOptionUseNumbers(true);
            password = Narpas.generatePassword("characters+numbers+limitspecial+duplicate characters test", settings);
            hasLCase = false;
            hasUCase = false;
            hasNumber = false;
            hasSpecialChar = false;
            i2 = 0;
            while (i2 < length) {
                selectedCharsOnly = false;
                if (limitSpecialChars.contains(Character.valueOf(password.charAt(i2)))) {
                    selectedCharsOnly = true;
                    hasSpecialChar = true;
                } else if (numbers.contains(Character.valueOf(password.charAt(i2)))) {
                    selectedCharsOnly = true;
                    hasNumber = true;
                } else if (lowerCase.contains(Character.valueOf(password.charAt(i2)))) {
                    selectedCharsOnly = true;
                    hasLCase = true;
                } else if (upperCase.contains(Character.valueOf(password.charAt(i2)))) {
                    selectedCharsOnly = true;
                    hasUCase = true;
                }
                Narpas_FunctionalTest.assertTrue((boolean)selectedCharsOnly);
                ++i2;
            }
            if (!(hasLCase && hasUCase && hasNumber && hasSpecialChar)) {
                Narpas_FunctionalTest.fail((String)("Missing expected character set.\nPassword=" + password + "\nhasLCase=" + hasLCase + "\nhasUCase=" + hasUCase + "\nhasNumber=" + hasNumber + "\nhasSpecialChar=" + hasSpecialChar));
            }
            settings.setOptionUseLCase(true);
            settings.setOptionUseUCase(true);
            settings.setOptionUseNumbers(true);
            settings.setLimitSpecialChars(null);
            hasLCase = false;
            hasUCase = false;
            hasNumber = false;
            hasSpecialChar = false;
            password = Narpas.generatePassword("characters+numbers+default special chars", settings);
            i2 = 0;
            while (i2 < length) {
                selectedCharsOnly = false;
                if (specialChars.contains(Character.valueOf(password.charAt(i2)))) {
                    selectedCharsOnly = true;
                    hasSpecialChar = true;
                } else if (numbers.contains(Character.valueOf(password.charAt(i2)))) {
                    selectedCharsOnly = true;
                    hasNumber = true;
                } else if (lowerCase.contains(Character.valueOf(password.charAt(i2)))) {
                    selectedCharsOnly = true;
                    hasLCase = true;
                } else if (upperCase.contains(Character.valueOf(password.charAt(i2)))) {
                    selectedCharsOnly = true;
                    hasUCase = true;
                }
                Narpas_FunctionalTest.assertTrue((boolean)selectedCharsOnly);
                ++i2;
            }
            if (!(hasLCase && hasUCase && hasNumber && hasSpecialChar)) {
                Narpas_FunctionalTest.fail((String)("Missing expected character set.\nPassword=" + password + "\nhasLCase=" + hasLCase + "\nhasUCase=" + hasUCase + "\nhasNumber=" + hasNumber + "\nhasSpecialChar=" + hasSpecialChar));
            }
        }
        catch (Exception x) {
            x.printStackTrace();
            Narpas_FunctionalTest.fail((String)x.getMessage());
        }
    }

    @Test
    public void test_weights() {
        PasswordSetting ps = new PasswordSetting();
        ps.setWeight(CharacterSetArrayIndex.EXTCHARS, 0.9);
        ps.setWeight(CharacterSetArrayIndex.LCHARS, 0.8);
        ps.setWeight(CharacterSetArrayIndex.NUMS, 0.7);
        ps.setWeight(CharacterSetArrayIndex.SCHARS, 0.6);
        ps.setWeight(CharacterSetArrayIndex.UCHARS, 0.5);
        Narpas_FunctionalTest.assertEquals((Object)0.9, (Object)ps.getWeight(CharacterSetArrayIndex.EXTCHARS));
        Narpas_FunctionalTest.assertEquals((Object)0.8, (Object)ps.getWeight(CharacterSetArrayIndex.LCHARS));
        Narpas_FunctionalTest.assertEquals((Object)0.7, (Object)ps.getWeight(CharacterSetArrayIndex.NUMS));
        Narpas_FunctionalTest.assertEquals((Object)0.6, (Object)ps.getWeight(CharacterSetArrayIndex.SCHARS));
        Narpas_FunctionalTest.assertEquals((Object)0.5, (Object)ps.getWeight(CharacterSetArrayIndex.UCHARS));
    }

    @Test
    public void test_v2GeneratePassword() {
        try {
            String passPhrase = "I like pie";
            String passwordName = "Facebook";
            boolean useLCase = true;
            boolean useUCase = true;
            boolean useNumbers = true;
            boolean useSpecialCharacters = true;
            boolean useExtCharacters = false;
            int length = 8;
            String passwordNotes = "";
            String category = "";
            int algorithmVersion = 2;
            String passwordVersion = "0";
            char[] limitSpecialChars = null;
            long lastUsed = 0L;
            PasswordSetting settings = new PasswordSetting(passwordName, useLCase, useUCase, useNumbers, useSpecialCharacters, useExtCharacters, length, passwordNotes, category, algorithmVersion, passwordVersion, limitSpecialChars, lastUsed);
            String password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"V4bGt6#%", (String)password);
            settings.setPasswordLength(16);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"A6!s#v?bgpX84DH=", (String)password);
            settings.setPasswordLength(32);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"IoFGg9.4XNCl-=H*dv6rueA!5mh8?Z0$", (String)password);
            settings.setPasswordLength(64);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"^rWQ,-*2Ko8%9i&qk6hGZV7bMOpStRYTw!E@I=m$f0?4aujNPCe#Fvx3Hsc51:L;", (String)password);
            settings.setPasswordLength(128);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"Ww%UgP2v834pD6XGV:&?m5qKYvea,szh7k=Br0#Qbnh1y-u*xsntOLdAlorNbo$lqcfESklqgbpzf+jcCaysdvI@pu.ifFnRxj9ermutikixcwT^egtyHo;dZz!JjmaM", (String)password);
            settings.setPasswordName("facebook");
            settings.setPasswordLength(8);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"#2tB0,Fb", (String)password);
            settings.setPasswordLength(16);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"qXU*lZC@8!21,bft", (String)password);
            settings.setPasswordLength(32);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"jJ+pn5;NI1vLkX%8r7CH0&F,$wtSx6h:", (String)password);
            settings.setPasswordLength(64);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"?H0JdA^o:#P59+vlxS8XLY7i!&tkN4G=W1$qV,c%wMgnjU@abR-eTC2zOZ;I6pm3", (String)password);
            settings.setPasswordLength(128);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"R*s7UuhWyfd2D#;:,%oiM4K-.^L6NbXHw3vSl&rs?gke$@YBcn9AzlxPEhtd+jrTjvbqgoQuiqwluZeabfvmotxp1imrn0cqVmsJO=k8aG!pgzhFCcnyIpxyjdt5kfwa", (String)password);
            passPhrase = "i like pie";
            settings.setPasswordName("Facebook");
            settings.setPasswordLength(8);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"64NYf;k-", (String)password);
            settings.setPasswordLength(16);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"xrw*#6%5X;SKE4tp", (String)password);
            settings.setPasswordLength(32);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"G6&QIOx8sBK-Zq!Rp.3woY0?u4t^+hj1", (String)password);
            settings.setPasswordLength(64);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"lE,C12@u%-4z7=FpJ$Oim#nA0PK!8eZr6kB:5D^NvLWUVIwahQ9?Yxb+t3So&d.s", (String)password);
            settings.setPasswordLength(128);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"Hbl0j$BNGyZoO+#J=!tidgpr;n@2V6hK*aD1vXSQ^zsykMLWzAqUcc&T7lsYwd%ouhfz,gjsgtfirbajhxmPpwe8xqvRunvc.ey93me:bdmFwIn4fqiu-kE5klrp?Cta", (String)password);
            settings.setPasswordName("facebook");
            settings.setPasswordLength(8);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"yLj7-R3+", (String)password);
            settings.setPasswordLength(16);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"aZ7vX6Sh.3E!o+u;", (String)password);
            settings.setPasswordLength(32);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"29g+esGKm;=NDCu*,7P0bQxT?pw%13Ek", (String)password);
            settings.setPasswordLength(64);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"YOVl=nw2hvQ%u.H6SB@q78#9dXjk^Eys-I1U;4!gG5MDmtWi$*x0Rr:p&cZTL3,C", (String)password);
            settings.setPasswordLength(128);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"aQJjnp-zuM*6VR4,h7bN=qy3OLiUXtf8?r$wYED#5xlBsmknwStZbkirvcaoxzf+HInsxdovd&qWkPjchcyesaC1!0z@%yvgmtq^p.Kg9F2ruAfe;lTo:Gugwmbdlejh", (String)password);
            passPhrase = "I like pie";
            settings.setPasswordName("Facebook");
            settings.setOptionUseLCase(true);
            settings.setOptionUseUCase(false);
            settings.setOptionUseNumbers(false);
            settings.setOptionUseSChars(false);
            settings.setPasswordLength(8);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"kpsfzmud", (String)password);
            settings.setPasswordLength(16);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"bihltxksvmycjoqz", (String)password);
            settings.setPasswordLength(32);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"cygzvpfrqohjtldemvwxtuibjknsanbd", (String)password);
            settings.setPasswordLength(64);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"szaufmbckfgixhjrlvvqhrnyzgmnwjtmakloxoydsbjqwivwulefpdpxdutsnkce", (String)password);
            settings.setPasswordLength(128);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"hlxyofzmrabjlcjggszbhfecvnwqwmrqyungdbvsdoplxzvinyvpmbrmjuscwkztrlhqjifnbdoxueaekkhaepgpdwyczaikrtfnvmfackquxyijdopttitoxhssuegw", (String)password);
            settings.setOptionUseLCase(false);
            settings.setOptionUseUCase(true);
            settings.setOptionUseNumbers(false);
            settings.setOptionUseSChars(false);
            settings.setPasswordLength(8);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"DJZLPFEC", (String)password);
            settings.setPasswordLength(16);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"PLEYAFXIKMGOCZRB", (String)password);
            settings.setPasswordLength(32);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"OQYTKGLUJBSPFWZEVIAMKVZNXHFCDRYA", (String)password);
            settings.setPasswordLength(64);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"RDHAGBFYJSEJKDWRVCOXPHXQOITUULEVBWKFLZZCYQMEACPGSFMDWNITNINURATM", (String)password);
            settings.setPasswordLength(128);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"HMCHTEOGSLRACZBLPEMFQUDMNYFJBIRNIEVTDOCPGWOAKUPMEEHCBRGZFRJXOFTWQVBSBLIHQLYNZZQJAUIFJKUDSYUVKRGSDQMPIDXTLXNKPXXOYVYAWSWCNWAKJGZH", (String)password);
            passPhrase = "Please no more California songs";
            settings.setPasswordName("orakio@mailinator.com");
            settings.setOptionUseLCase(true);
            settings.setOptionUseUCase(true);
            settings.setOptionUseNumbers(true);
            settings.setOptionUseSChars(true);
            settings.setPasswordLength(8);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"0goB9=V*", (String)password);
            settings.setPasswordLength(16);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"T7e9.uXhb:@V=p1L", (String)password);
            settings.setPasswordLength(32);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"2Hj!7B8MPncN4$mb0arI%C-.G?Dkx,1g", (String)password);
            settings.setPasswordLength(64);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"q6N?:FBIa,i3&X5lTgd1-K90cxG=+U8H%2Ce7sQmtD@!wJbA#pkjRyS^;u4ZYOr.", (String)password);
            settings.setPasswordLength(128);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"rU?Sc:dq-X@j9R%IB1KNl$YDQmoO7C4kaqw*tzgf6gns.,hp;fltWEnevVothuTyxbraiphjywGdbamxcj+lypJifAun8beHo&Fvv=sLd0^5x3qkzPkrs#iec2z!mZuM", (String)password);
            passPhrase = "Please no more california songs";
            settings.setOptionUseLCase(true);
            settings.setOptionUseUCase(true);
            settings.setOptionUseNumbers(true);
            settings.setOptionUseSChars(true);
            settings.setPasswordLength(8);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"I$4dn9#B", (String)password);
            settings.setPasswordLength(16);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"s8VTt*?Ly#p4;7Qd", (String)password);
            settings.setPasswordLength(32);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"-!8wnMR=Zm3?qx:56tESc42A%Ha^joQW", (String)password);
            settings.setPasswordLength(64);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"GK9qjv$!VZtN.62DcTg*w4UL@JCua+b#m8Y^7:1fWx5H?sXz%E3Q=0PBy&dReko,", (String)password);
            settings.setPasswordLength(128);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)";vN%oCsZYdt6zk?y=P0Ou^+!8I3Tx#qSi$UKo:aaGJwnMvzHfphcVwxE&dAglkmfFrmiwxy.gljftblav@XQem-5ngq4cojpzRL7qrur*cnDe,9Bubhydkhsj1p2sWeb", (String)password);
            passPhrase = "Please no more California songs";
            settings.setPasswordName("orakio@mailinator.com");
            settings.setOptionUseLCase(false);
            settings.setOptionUseUCase(false);
            settings.setOptionUseNumbers(true);
            settings.setOptionUseSChars(false);
            settings.setPasswordLength(8);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"61708592", (String)password);
            settings.setPasswordLength(16);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"8079649123250376", (String)password);
            settings.setPasswordLength(32);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"58751129039227474667688084533910", (String)password);
            settings.setPasswordLength(64);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"7570349890461267062314435198206271491602087995948708287335553611", (String)password);
            settings.setPasswordLength(128);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"16775301393447401492020768127347062986108753638949043041166527221575312899488201065628289671395815091578284636026785470439435593", (String)password);
            settings.setOptionUseLCase(false);
            settings.setOptionUseUCase(false);
            settings.setOptionUseNumbers(true);
            settings.setOptionUseSChars(true);
            settings.setPasswordLength(8);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"721!;?#8", (String)password);
            settings.setPasswordLength(16);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"71;^5.26:%#@8!0,", (String)password);
            settings.setPasswordLength(32);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"62%+40;=,-5!:^*8&9@#1.$77841263?", (String)password);
            settings.setPasswordLength(64);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)":5!%?=037@64#;-23.5+8&379869$,2165042^57149125829007419*08167843", (String)password);
            settings.setPasswordLength(128);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"^=48122.67+92;4356089:3&75*85128873760959136243931018455086437652609948155006270203%4993141@97220$!?6181828,9474#7-5234606757310", (String)password);
            settings.setOptionUseLCase(false);
            settings.setOptionUseUCase(true);
            settings.setOptionUseNumbers(true);
            settings.setOptionUseSChars(false);
            settings.setPasswordLength(8);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"XYE9N70S", (String)password);
            settings.setPasswordLength(16);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"34T8HB25FPK6OUAY", (String)password);
            settings.setPasswordLength(32);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"KL3P2A6G5ZRUIM0J7WXS1TDVNCE984OF", (String)password);
            settings.setPasswordLength(64);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"Q6TSJIKV1WR724IBHSKGER0XNC8ODGFTZUCJBYQL5DYACHMAZFMVOIU93PLEWNPX", (String)password);
            settings.setPasswordLength(128);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"J1W7KP2SC3Q8THR6OLZM5IUAKZGVRGDYXPGLEJVNXHCDQQCIOUKSNYKVWQRZOMTBJUIADEWJFNLHLXQZKHFP9WECUYTM0DAPCSRVVITBFXBIYE4FLASENMOUMDOGYGFB", (String)password);
            passPhrase = "None of these passwords would work with AT&T.";
            settings.setPasswordName("AT&T");
            settings.setOptionUseLCase(true);
            settings.setOptionUseUCase(true);
            settings.setOptionUseNumbers(true);
            settings.setOptionUseSChars(true);
            settings.setOptionUseExtChars(true);
            settings.setPasswordVersion("1");
            settings.setPasswordLength(8);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"\u00ca\u00f2,PuG2k", (String)password);
            settings.setPasswordLength(16);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"kMrnJ2\u00f08%\u00f6!\u00d4\u00e3&\u00d0V", (String)password);
            settings.setPasswordLength(32);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"7S2d\u00f4n\u00c0+0\u00da!G\u00cdHtq\u00e8PuO\u00e4\u00df\u00ed@s#w\u00d48;\u00fcF", (String)password);
            settings.setPasswordLength(64);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"VC\u00d9\u00fc-d!f#\u00f4K8\u00eb\u00dbR2?0t\u00fbxpl\u00ec5\u00dcE\u00c1&6\u00eaGZeP^=\u00e1\u00f6\u00f1q\u00c7b\u00f5QTI,i4\u00ff\u00c5\u00dfJ%F\u00cd\u00fan7yh\u00e9@", (String)password);
            settings.setPasswordLength(128);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"o@A\u00ebZx-3\u00e88\u00ce\u00f8EC\u00fe\u00f7&\u00f37\u00e7a;V\u00c34\u00e1\u00de\u00fdhy\u00ec$\u00edp2\u00e56\u00df\u00d10.\u00c95t\u00e3MRznsXd^\u00cd\u00f0\u00ca\u00faPf\u00e0Ti\u00c7%BqS\u00dd\u00ff,\u00e2\u00d0\u00d6GH?w\u00dc\u00f9\u00eavmYl1b\u00d5eDIOK\u00e6\u00c6g#\u00c1W\u00d3:L+9*!\u00ef\u00da\u00c0\u00fcr\u00ccNcQ\u00c8jk\u00f5U\u00c2\u00c5=u\u00dbF\u00d8J\u00c4", (String)password);
            passPhrase = "None of these passwords would work with AT&T.";
            settings.setPasswordName("AT&T");
            settings.setOptionUseLCase(true);
            settings.setOptionUseUCase(true);
            settings.setOptionUseNumbers(true);
            settings.setOptionUseSChars(true);
            settings.setOptionUseExtChars(true);
            settings.setPasswordVersion("2");
            settings.setPasswordLength(8);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"8\u00d1w\u00eeG&Tl", (String)password);
            settings.setPasswordLength(16);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"\u00c6\u00d28dn\u00e1WIZ#%k4$\u00d6\u00d9", (String)password);
            settings.setPasswordLength(32);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"\u00e3Jv&B\u00d1i\u00c5\u00d6w@:W1\u00cbQ0\u00eeVq\u00e4D-r*\u00c7mb\u00ec27\u00c6", (String)password);
            settings.setPasswordLength(64);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)";S\u00des\u00fb\u00dd8\u00fctQ\u00ffbk0?\u00ce\u00c4z\u00c2\u00f3mBpIg@x\u00df\u00dcW\u00e8%ZK\u00e14\u00c0\u00e7\u00e5$-e6&3\u00ed!Uc\u00e0#\u00ccjl1\u00ee\u00c9G2A,YJE", (String)password);
            settings.setPasswordLength(128);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"\u00d0dZ\u00caD0\u00fd\u00fb6^\u00c62\u00eb\u00dd.\u00e8g\u00ef5Cv4\u00e0-cLI\u00dc=U9\u00f5eaJ\u00d6\u00eau\u00d9$@HlK\u00de#\u00f6A\u00f41\u00c7f3%\u00cf\u00dfN\u00c5b\u00c3khX\u00c4wE\u00d3r\u00c0zPB\u00ect\u00f28Q\u00c9M\u00e2\u00c1\u00f9\u00cbp+\u00d4j\u00dby:n\u00ee\u00f1\u00e1\u00d57\u00d2\u00f0\u00edRs,SOT&F;mxG\u00ccq\u00f8\u00daV?*\u00ceo!i\u00e5Y\u00fcW\u00c2\u00d1", (String)password);
            passPhrase = "None of these passwords would work with AT&T.";
            settings.setPasswordName("AT&T");
            settings.setOptionUseLCase(true);
            settings.setOptionUseUCase(true);
            settings.setOptionUseNumbers(true);
            settings.setOptionUseSChars(true);
            settings.setOptionUseExtChars(true);
            settings.setOptionAllowDuplicateCharacters(true);
            settings.setPasswordVersion("0");
            settings.setPasswordLength(8);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"\u00dcg2=rO4Y", (String)password);
            settings.setPasswordLength(16);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"52B^#mfK;\u00f4\u00d2l2Hk\u00de", (String)password);
            settings.setPasswordLength(32);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"=\u00e87hq-#6\u00c16\u00f0bD\u00f4^I!\u00c1B3\u00e7lsHO!2Gh4cH", (String)password);
            settings.setPasswordLength(64);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"*HyDF\u00d60F\u00d0h0=3\u00e0!tjJdW\u00e9J%jg3\u00f2IG\u00fc\u00caHy50\u00dd!Uqm$nG%%\u00c4R830,@,t\u00e8t=\u00c32\u00e0507#", (String)password);
            settings.setPasswordLength(128);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"8dTfgF.r38H%X4R!x8H=ubo\u00d8\u00c98H5\u00c2;K2La\u00dc!4\u00d6x\u00faz&Nz.\u00f90pH#D7Q$6\u00cb\u00c1d\u00c2q;d0\u00de\u00dbC&ca+;b\u00dcKB!2o\u00de\u00f97\u00f3a8\u00c296!=\u00d6nl\u00deLS&8B#J\u00favv09\u00c807,d\u00f0\u00fa%\u00ec:\u00d67-H%0P&CYJC0", (String)password);
            passPhrase = "These passwords would work with AT&T.";
            settings.setPasswordName("AT&T");
            settings.setOptionUseLCase(true);
            settings.setOptionUseUCase(true);
            settings.setOptionUseNumbers(true);
            settings.setOptionUseSChars(true);
            settings.setOptionAllowDuplicateCharacters(false);
            limitSpecialChars = new char[]{'-', '_'};
            settings.setLimitSpecialChars(limitSpecialChars);
            settings.setOptionUseExtChars(false);
            settings.setPasswordLength(6);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"-gPy2I", (String)password);
            settings.setPasswordLength(16);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"e4tFb86AzLO-arNB", (String)password);
            settings.setPasswordLength(24);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"FAaL_4sGhPC2m-fYz1Jb50yq", (String)password);
            passPhrase = "This is the strongest password settings paypal supports, wtf.";
            settings.setPasswordName("paypal");
            settings.setOptionUseLCase(true);
            settings.setOptionUseUCase(true);
            settings.setOptionUseNumbers(true);
            settings.setOptionUseSChars(true);
            limitSpecialChars = new char[]{'!', '@', '#', '$', '%', '^'};
            settings.setLimitSpecialChars(limitSpecialChars);
            settings.setOptionUseExtChars(false);
            settings.setPasswordLength(20);
            password = Narpas.generatePassword(passPhrase, settings);
            Narpas_FunctionalTest.assertEquals((String)"jMgGrV8!1Ths@xSeK9^7", (String)password);
        }
        catch (Exception x) {
            x.printStackTrace();
            Narpas_FunctionalTest.fail((String)x.getMessage());
        }
    }

    @Test
    public void test_EncryptDecrypt() {
        try {
            String testString = UUID.randomUUID().toString();
            String passphrase = UUID.randomUUID().toString();
            String encryptedString = StringEncryptDecrypt.encrypt(passphrase, testString);
            String decryptedString = StringEncryptDecrypt.decryptString(passphrase, encryptedString);
            Narpas_FunctionalTest.assertEquals((String)testString, (String)decryptedString);
            testString = UUID.randomUUID().toString();
            passphrase = "test-passphrase-1";
            String encryptedString1 = StringEncryptDecrypt.encrypt(passphrase, testString);
            passphrase = "test-passphrase-2";
            String encryptedString2 = StringEncryptDecrypt.encrypt(passphrase, testString);
            Narpas_FunctionalTest.assertFalse((boolean)encryptedString1.equals(encryptedString2));
        }
        catch (Exception x) {
            Narpas_FunctionalTest.fail((String)x.getMessage());
        }
    }

    @Test
    public void test_Compare() {
        char[] limitSpecialChars = new char[]{'!', '@'};
        PasswordSetting ps1 = new PasswordSetting();
        PasswordSetting ps2 = new PasswordSetting();
        ps1.setPasswordName("password-name");
        ps2.setPasswordName("password-name");
        ps1.setPasswordNotes("password-notes");
        ps2.setPasswordNotes("password-notes");
        ps1.setCategory("category");
        ps2.setCategory("category");
        ps1.setPasswordVersion("password-version");
        ps2.setPasswordVersion("password-version");
        ps1.setPasswordLength(32);
        ps2.setPasswordLength(32);
        ps1.setAlgorithmVersion(2);
        ps2.setAlgorithmVersion(2);
        ps1.setOptionAllowDuplicateCharacters(true);
        ps2.setOptionAllowDuplicateCharacters(true);
        ps1.setOptionUseExtChars(true);
        ps2.setOptionUseExtChars(true);
        ps1.setOptionUseLCase(true);
        ps2.setOptionUseLCase(true);
        ps1.setOptionUseUCase(true);
        ps2.setOptionUseUCase(true);
        ps1.setOptionUseNumbers(true);
        ps2.setOptionUseNumbers(true);
        ps1.setOptionUseSChars(true);
        ps2.setOptionUseSChars(true);
        ps1.setLimitSpecialChars(limitSpecialChars);
        ps2.setLimitSpecialChars(limitSpecialChars);
        Narpas_FunctionalTest.assertTrue((boolean)ps1.compare(ps2));
        Narpas_FunctionalTest.assertFalse((boolean)ps1.compare(null));
        ps1.setPasswordName(null);
        Narpas_FunctionalTest.assertFalse((boolean)ps1.compare(ps2));
        ps1.setPasswordName("password-name");
        Narpas_FunctionalTest.assertTrue((boolean)ps1.compare(ps2));
        ps2.setPasswordName(null);
        Narpas_FunctionalTest.assertFalse((boolean)ps1.compare(ps2));
        ps2.setPasswordName("password-name");
        Narpas_FunctionalTest.assertTrue((boolean)ps1.compare(ps2));
        ps2.setPasswordName("different");
        Narpas_FunctionalTest.assertFalse((boolean)ps1.compare(ps2));
        ps2.setPasswordName("password-name");
        Narpas_FunctionalTest.assertTrue((boolean)ps1.compare(ps2));
        ps1.setPasswordName(null);
        ps2.setPasswordName(null);
        Narpas_FunctionalTest.assertTrue((boolean)ps1.compare(ps2));
        ps1.setPasswordName("password-name");
        ps2.setPasswordName("password-name");
        Narpas_FunctionalTest.assertTrue((boolean)ps1.compare(ps2));
        ps1.setPasswordNotes(null);
        Narpas_FunctionalTest.assertFalse((boolean)ps1.compare(ps2));
        ps1.setPasswordNotes("password-notes");
        Narpas_FunctionalTest.assertTrue((boolean)ps1.compare(ps2));
        ps2.setPasswordNotes(null);
        Narpas_FunctionalTest.assertFalse((boolean)ps1.compare(ps2));
        ps2.setPasswordNotes("password-notes");
        Narpas_FunctionalTest.assertTrue((boolean)ps1.compare(ps2));
        ps2.setPasswordNotes("different");
        Narpas_FunctionalTest.assertFalse((boolean)ps1.compare(ps2));
        ps2.setPasswordNotes("password-notes");
        Narpas_FunctionalTest.assertTrue((boolean)ps1.compare(ps2));
        ps1.setPasswordNotes(null);
        ps2.setPasswordNotes(null);
        Narpas_FunctionalTest.assertTrue((boolean)ps1.compare(ps2));
        ps1.setPasswordNotes("password-notes");
        ps2.setPasswordNotes("password-notes");
        Narpas_FunctionalTest.assertTrue((boolean)ps1.compare(ps2));
        ps1.setCategory(null);
        Narpas_FunctionalTest.assertFalse((boolean)ps1.compare(ps2));
        ps1.setCategory("category");
        Narpas_FunctionalTest.assertTrue((boolean)ps1.compare(ps2));
        ps2.setCategory(null);
        Narpas_FunctionalTest.assertFalse((boolean)ps1.compare(ps2));
        ps2.setCategory("category");
        Narpas_FunctionalTest.assertTrue((boolean)ps1.compare(ps2));
        ps2.setCategory("different");
        Narpas_FunctionalTest.assertFalse((boolean)ps1.compare(ps2));
        ps2.setCategory("category");
        Narpas_FunctionalTest.assertTrue((boolean)ps1.compare(ps2));
        ps1.setCategory(null);
        ps2.setCategory(null);
        Narpas_FunctionalTest.assertTrue((boolean)ps1.compare(ps2));
        ps1.setCategory("category");
        ps2.setCategory("category");
        Narpas_FunctionalTest.assertTrue((boolean)ps1.compare(ps2));
        ps1.setPasswordVersion(null);
        Narpas_FunctionalTest.assertFalse((boolean)ps1.compare(ps2));
        ps1.setPasswordVersion("password-version");
        Narpas_FunctionalTest.assertTrue((boolean)ps1.compare(ps2));
        ps2.setPasswordVersion(null);
        Narpas_FunctionalTest.assertFalse((boolean)ps1.compare(ps2));
        ps2.setPasswordVersion("password-version");
        Narpas_FunctionalTest.assertTrue((boolean)ps1.compare(ps2));
        ps2.setPasswordVersion("different");
        Narpas_FunctionalTest.assertFalse((boolean)ps1.compare(ps2));
        ps2.setPasswordVersion("password-version");
        Narpas_FunctionalTest.assertTrue((boolean)ps1.compare(ps2));
        ps1.setPasswordVersion(null);
        ps2.setPasswordVersion(null);
        Narpas_FunctionalTest.assertTrue((boolean)ps1.compare(ps2));
        ps1.setPasswordVersion("password-version");
        ps2.setPasswordVersion("password-version");
        Narpas_FunctionalTest.assertTrue((boolean)ps1.compare(ps2));
        ps2.setPasswordLength(8);
        Narpas_FunctionalTest.assertFalse((boolean)ps1.compare(ps2));
        ps2.setPasswordLength(32);
        Narpas_FunctionalTest.assertTrue((boolean)ps1.compare(ps2));
        ps2.setAlgorithmVersion(1);
        Narpas_FunctionalTest.assertFalse((boolean)ps1.compare(ps2));
        ps2.setAlgorithmVersion(2);
        Narpas_FunctionalTest.assertTrue((boolean)ps1.compare(ps2));
        ps2.setOptionAllowDuplicateCharacters(false);
        Narpas_FunctionalTest.assertFalse((boolean)ps1.compare(ps2));
        ps2.setOptionAllowDuplicateCharacters(true);
        Narpas_FunctionalTest.assertTrue((boolean)ps1.compare(ps2));
        ps2.setOptionUseExtChars(false);
        Narpas_FunctionalTest.assertFalse((boolean)ps1.compare(ps2));
        ps2.setOptionUseExtChars(true);
        Narpas_FunctionalTest.assertTrue((boolean)ps1.compare(ps2));
        ps2.setOptionUseLCase(false);
        Narpas_FunctionalTest.assertFalse((boolean)ps1.compare(ps2));
        ps2.setOptionUseLCase(true);
        Narpas_FunctionalTest.assertTrue((boolean)ps1.compare(ps2));
        ps2.setOptionUseUCase(false);
        Narpas_FunctionalTest.assertFalse((boolean)ps1.compare(ps2));
        ps2.setOptionUseUCase(true);
        Narpas_FunctionalTest.assertTrue((boolean)ps1.compare(ps2));
        ps2.setOptionUseNumbers(false);
        Narpas_FunctionalTest.assertFalse((boolean)ps1.compare(ps2));
        ps2.setOptionUseNumbers(true);
        Narpas_FunctionalTest.assertTrue((boolean)ps1.compare(ps2));
        ps2.setOptionUseSChars(false);
        Narpas_FunctionalTest.assertFalse((boolean)ps1.compare(ps2));
        ps2.setOptionUseSChars(true);
        Narpas_FunctionalTest.assertTrue((boolean)ps1.compare(ps2));
        ps1.setLimitSpecialChars(null);
        Narpas_FunctionalTest.assertFalse((boolean)ps1.compare(ps2));
        ps1.setLimitSpecialChars(limitSpecialChars);
        Narpas_FunctionalTest.assertTrue((boolean)ps1.compare(ps2));
        ps2.setLimitSpecialChars(null);
        Narpas_FunctionalTest.assertFalse((boolean)ps1.compare(ps2));
        ps1.setLimitSpecialChars(null);
        ps2.setLimitSpecialChars(null);
        Narpas_FunctionalTest.assertTrue((boolean)ps1.compare(ps2));
        ps1.setLimitSpecialChars(limitSpecialChars);
        ps2.setLimitSpecialChars(new char[]{'!'});
        Narpas_FunctionalTest.assertFalse((boolean)ps1.compare(ps2));
        ps2.setLimitSpecialChars(new char[]{'!', '-'});
        Narpas_FunctionalTest.assertFalse((boolean)ps1.compare(ps2));
        ps2.setLimitSpecialChars(new char[]{'!', '@', '&'});
        Narpas_FunctionalTest.assertFalse((boolean)ps1.compare(ps2));
        ps2.setLimitSpecialChars(limitSpecialChars);
        Narpas_FunctionalTest.assertTrue((boolean)ps1.compare(ps2));
        ps2.setWeight(CharacterSetArrayIndex.LCHARS, Double.MAX_VALUE);
        Narpas_FunctionalTest.assertFalse((boolean)ps1.compare(ps2));
        ps2.setWeight(CharacterSetArrayIndex.LCHARS, 1.0);
        Narpas_FunctionalTest.assertTrue((boolean)ps1.compare(ps2));
        ps2.setWeight(CharacterSetArrayIndex.UCHARS, Double.MAX_VALUE);
        Narpas_FunctionalTest.assertFalse((boolean)ps1.compare(ps2));
        ps2.setWeight(CharacterSetArrayIndex.UCHARS, 1.0);
        Narpas_FunctionalTest.assertTrue((boolean)ps1.compare(ps2));
        ps2.setWeight(CharacterSetArrayIndex.NUMS, Double.MAX_VALUE);
        Narpas_FunctionalTest.assertFalse((boolean)ps1.compare(ps2));
        ps2.setWeight(CharacterSetArrayIndex.NUMS, 1.0);
        Narpas_FunctionalTest.assertTrue((boolean)ps1.compare(ps2));
        ps2.setWeight(CharacterSetArrayIndex.SCHARS, Double.MAX_VALUE);
        Narpas_FunctionalTest.assertFalse((boolean)ps1.compare(ps2));
        ps2.setWeight(CharacterSetArrayIndex.SCHARS, 1.0);
        Narpas_FunctionalTest.assertTrue((boolean)ps1.compare(ps2));
        ps2.setWeight(CharacterSetArrayIndex.EXTCHARS, Double.MAX_VALUE);
        Narpas_FunctionalTest.assertFalse((boolean)ps1.compare(ps2));
        ps2.setWeight(CharacterSetArrayIndex.EXTCHARS, 1.0);
        Narpas_FunctionalTest.assertTrue((boolean)ps1.compare(ps2));
    }

    @Test
    public void test_UtilGetAllCategories() {
        ArrayList<PasswordSetting> list = new ArrayList<PasswordSetting>();
        PasswordSetting ps = new PasswordSetting();
        ps.setPasswordName("name1");
        ps.setCategory("q_category");
        list.add(ps);
        ps = new PasswordSetting();
        ps.setPasswordName("name2");
        ps.setCategory("w_category");
        list.add(ps);
        ps = new PasswordSetting();
        ps.setPasswordName("name3");
        ps.setCategory("e_category");
        list.add(ps);
        ps = new PasswordSetting();
        ps.setPasswordName("name4");
        ps.setCategory("r_category");
        list.add(ps);
        List<String> categories = NarpasUtil.getAllCategories(list);
        Narpas_FunctionalTest.assertEquals((int)4, (int)categories.size());
        Narpas_FunctionalTest.assertEquals((String)categories.get(0), (String)"e_category");
        Narpas_FunctionalTest.assertEquals((String)categories.get(1), (String)"q_category");
        Narpas_FunctionalTest.assertEquals((String)categories.get(2), (String)"r_category");
        Narpas_FunctionalTest.assertEquals((String)categories.get(3), (String)"w_category");
        ps = new PasswordSetting();
        ps.setPasswordName("name5");
        ps.setCategory(null);
        list.add(ps);
        categories = NarpasUtil.getAllCategories(list);
        Narpas_FunctionalTest.assertEquals((int)5, (int)categories.size());
        Narpas_FunctionalTest.assertEquals((String)categories.get(0), (String)"[Unsorted]");
        Narpas_FunctionalTest.assertEquals((String)categories.get(1), (String)"e_category");
        Narpas_FunctionalTest.assertEquals((String)categories.get(2), (String)"q_category");
        Narpas_FunctionalTest.assertEquals((String)categories.get(3), (String)"r_category");
        Narpas_FunctionalTest.assertEquals((String)categories.get(4), (String)"w_category");
    }

    @Test
    public void test_PasswordSettingDateComparator() {
        ArrayList<PasswordSetting> list = new ArrayList<PasswordSetting>();
        PasswordSetting ps = new PasswordSetting();
        ps.setPasswordName("password_6");
        ps.setLastUsed(6L);
        list.add(ps);
        ps = new PasswordSetting();
        ps.setPasswordName("password_4");
        ps.setLastUsed(4L);
        list.add(ps);
        ps = new PasswordSetting();
        ps.setPasswordName("password_89");
        ps.setLastUsed(89L);
        list.add(ps);
        ps = new PasswordSetting();
        ps.setPasswordName("password_6489");
        ps.setLastUsed(6489L);
        list.add(ps);
        ps = new PasswordSetting();
        ps.setPasswordName("password_4689");
        ps.setLastUsed(4689L);
        list.add(ps);
        ps = new PasswordSetting();
        ps.setPasswordName("password_666");
        ps.setLastUsed(666L);
        list.add(ps);
        ps = new PasswordSetting();
        ps.setPasswordName("password_13");
        ps.setLastUsed(13L);
        list.add(ps);
        list.sort(new PasswordSettingDateComparator(false));
        ps = (PasswordSetting)list.get(0);
        Narpas_FunctionalTest.assertEquals((String)ps.getPasswordName(), (String)"password_6489");
        Narpas_FunctionalTest.assertEquals((long)ps.getLastUsed(), (long)6489L);
        ps = (PasswordSetting)list.get(1);
        Narpas_FunctionalTest.assertEquals((String)ps.getPasswordName(), (String)"password_4689");
        Narpas_FunctionalTest.assertEquals((long)ps.getLastUsed(), (long)4689L);
        ps = (PasswordSetting)list.get(2);
        Narpas_FunctionalTest.assertEquals((String)ps.getPasswordName(), (String)"password_666");
        Narpas_FunctionalTest.assertEquals((long)ps.getLastUsed(), (long)666L);
        ps = (PasswordSetting)list.get(3);
        Narpas_FunctionalTest.assertEquals((String)ps.getPasswordName(), (String)"password_89");
        Narpas_FunctionalTest.assertEquals((long)ps.getLastUsed(), (long)89L);
        ps = (PasswordSetting)list.get(4);
        Narpas_FunctionalTest.assertEquals((String)ps.getPasswordName(), (String)"password_13");
        Narpas_FunctionalTest.assertEquals((long)ps.getLastUsed(), (long)13L);
        ps = (PasswordSetting)list.get(5);
        Narpas_FunctionalTest.assertEquals((String)ps.getPasswordName(), (String)"password_6");
        Narpas_FunctionalTest.assertEquals((long)ps.getLastUsed(), (long)6L);
        ps = (PasswordSetting)list.get(6);
        Narpas_FunctionalTest.assertEquals((String)ps.getPasswordName(), (String)"password_4");
        Narpas_FunctionalTest.assertEquals((long)ps.getLastUsed(), (long)4L);
        list.sort(new PasswordSettingDateComparator(true));
        ps = (PasswordSetting)list.get(6);
        Narpas_FunctionalTest.assertEquals((String)ps.getPasswordName(), (String)"password_6489");
        Narpas_FunctionalTest.assertEquals((long)ps.getLastUsed(), (long)6489L);
        ps = (PasswordSetting)list.get(5);
        Narpas_FunctionalTest.assertEquals((String)ps.getPasswordName(), (String)"password_4689");
        Narpas_FunctionalTest.assertEquals((long)ps.getLastUsed(), (long)4689L);
        ps = (PasswordSetting)list.get(4);
        Narpas_FunctionalTest.assertEquals((String)ps.getPasswordName(), (String)"password_666");
        Narpas_FunctionalTest.assertEquals((long)ps.getLastUsed(), (long)666L);
        ps = (PasswordSetting)list.get(3);
        Narpas_FunctionalTest.assertEquals((String)ps.getPasswordName(), (String)"password_89");
        Narpas_FunctionalTest.assertEquals((long)ps.getLastUsed(), (long)89L);
        ps = (PasswordSetting)list.get(2);
        Narpas_FunctionalTest.assertEquals((String)ps.getPasswordName(), (String)"password_13");
        Narpas_FunctionalTest.assertEquals((long)ps.getLastUsed(), (long)13L);
        ps = (PasswordSetting)list.get(1);
        Narpas_FunctionalTest.assertEquals((String)ps.getPasswordName(), (String)"password_6");
        Narpas_FunctionalTest.assertEquals((long)ps.getLastUsed(), (long)6L);
        ps = (PasswordSetting)list.get(0);
        Narpas_FunctionalTest.assertEquals((String)ps.getPasswordName(), (String)"password_4");
        Narpas_FunctionalTest.assertEquals((long)ps.getLastUsed(), (long)4L);
    }

    @Test
    public void test_PasswordSettingNameComparator() {
        ArrayList<PasswordSetting> list = new ArrayList<PasswordSetting>();
        PasswordSetting ps = new PasswordSetting();
        ps.setPasswordName("qassword");
        list.add(ps);
        ps = new PasswordSetting();
        ps.setPasswordName("wassword");
        list.add(ps);
        ps = new PasswordSetting();
        ps.setPasswordName("eassword");
        list.add(ps);
        ps = new PasswordSetting();
        ps.setPasswordName("rassword");
        list.add(ps);
        ps = new PasswordSetting();
        ps.setPasswordName("tassword");
        list.add(ps);
        ps = new PasswordSetting();
        ps.setPasswordName("yassword");
        list.add(ps);
        ps = new PasswordSetting();
        ps.setPasswordName("uassword");
        list.add(ps);
        list.sort(new PasswordSettingNameComparator(false));
        ps = (PasswordSetting)list.get(0);
        Narpas_FunctionalTest.assertEquals((String)ps.getPasswordName(), (String)"eassword");
        ps = (PasswordSetting)list.get(1);
        Narpas_FunctionalTest.assertEquals((String)ps.getPasswordName(), (String)"qassword");
        ps = (PasswordSetting)list.get(2);
        Narpas_FunctionalTest.assertEquals((String)ps.getPasswordName(), (String)"rassword");
        ps = (PasswordSetting)list.get(3);
        Narpas_FunctionalTest.assertEquals((String)ps.getPasswordName(), (String)"tassword");
        ps = (PasswordSetting)list.get(4);
        Narpas_FunctionalTest.assertEquals((String)ps.getPasswordName(), (String)"uassword");
        ps = (PasswordSetting)list.get(5);
        Narpas_FunctionalTest.assertEquals((String)ps.getPasswordName(), (String)"wassword");
        ps = (PasswordSetting)list.get(6);
        Narpas_FunctionalTest.assertEquals((String)ps.getPasswordName(), (String)"yassword");
        list.sort(new PasswordSettingNameComparator(true));
        ps = (PasswordSetting)list.get(6);
        Narpas_FunctionalTest.assertEquals((String)ps.getPasswordName(), (String)"eassword");
        ps = (PasswordSetting)list.get(5);
        Narpas_FunctionalTest.assertEquals((String)ps.getPasswordName(), (String)"qassword");
        ps = (PasswordSetting)list.get(4);
        Narpas_FunctionalTest.assertEquals((String)ps.getPasswordName(), (String)"rassword");
        ps = (PasswordSetting)list.get(3);
        Narpas_FunctionalTest.assertEquals((String)ps.getPasswordName(), (String)"tassword");
        ps = (PasswordSetting)list.get(2);
        Narpas_FunctionalTest.assertEquals((String)ps.getPasswordName(), (String)"uassword");
        ps = (PasswordSetting)list.get(1);
        Narpas_FunctionalTest.assertEquals((String)ps.getPasswordName(), (String)"wassword");
        ps = (PasswordSetting)list.get(0);
        Narpas_FunctionalTest.assertEquals((String)ps.getPasswordName(), (String)"yassword");
    }
}

