/*
 * Decompiled with CFR 0.152.
 */
package com.huguesjohnson.narpas.test;

import com.huguesjohnson.dubbel.util.ArrayUtil;
import com.huguesjohnson.dubbel.util.StringDistance;
import com.huguesjohnson.narpas.CharacterSetArrayIndex;
import com.huguesjohnson.narpas.Narpas;
import com.huguesjohnson.narpas.PasswordSetting;
import java.util.ArrayList;
import java.util.Random;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;

public class Narpas_StressTest {
    @Test
    public void test_v2LengthEntropy() {
        int numPasses = 100;
        int totalPasses = 0;
        double minDifference = 1.0;
        String minDifferencePassword1 = "";
        String minDifferencePassword2 = "";
        String minDifferencePassPhrase = "";
        String minDifferencePassName = "";
        double averageDifference = 0.0;
        int i = 0;
        while (i < numPasses) {
            String passPhrase = UUID.randomUUID().toString();
            String passswordName = UUID.randomUUID().toString();
            PasswordSetting settings = new PasswordSetting();
            settings.setPasswordName(passswordName);
            settings.setAlgorithmVersion(2);
            settings.setOptionUseLCase(true);
            settings.setOptionUseUCase(true);
            settings.setOptionUseSChars(true);
            settings.setOptionUseExtChars(false);
            settings.setOptionUseNumbers(true);
            settings.setPasswordLength(4);
            int length = 4;
            while (length <= 127) {
                try {
                    settings.setPasswordLength(length);
                    String password1 = Narpas.generatePassword(passPhrase, settings);
                    settings.setPasswordLength(length + 1);
                    String password2 = Narpas.generatePassword(passPhrase, settings);
                    int ld = StringDistance.levenshteinDistance(password1, password2);
                    double difference = (double)ld / (double)length;
                    averageDifference += difference;
                    if (difference < minDifference) {
                        minDifference = difference;
                        minDifferencePassword1 = password1;
                        minDifferencePassword2 = password2;
                        minDifferencePassPhrase = passPhrase;
                        minDifferencePassName = passswordName;
                    }
                    ++totalPasses;
                }
                catch (Exception x) {
                    x.printStackTrace();
                    Assert.fail((String)x.getMessage());
                }
                ++length;
            }
            ++i;
        }
        System.out.println("test_v2LengthEntropy\n------------------------------");
        System.out.println("averageDifference:" + averageDifference / (double)totalPasses);
        System.out.println("minDifference:" + minDifference);
        System.out.println("minDifferencePassPhrase:" + minDifferencePassPhrase);
        System.out.println("minDifferencePassName:" + minDifferencePassName);
        System.out.println("minDifferencePassword1:" + minDifferencePassword1);
        System.out.println("minDifferencePassword2:" + minDifferencePassword2);
        System.out.println("");
    }

    @Test
    public void test_v2PasswordVersionEntropy() {
        int numPasses = 100;
        int totalPasses = 0;
        double minDifference = 1.0;
        String minDifferencePassword1 = "";
        String minDifferencePassword2 = "";
        String minDifferencePassPhrase = "";
        String minDifferencePassName = "";
        int minDifferenceVersion1 = 0;
        int minDifferenceVersion2 = 0;
        double averageDifference = 0.0;
        double worstDistance = 0.0;
        String worstDistancePassword1 = "";
        String worstDistancePassword2 = "";
        String worstDistancePassPhrase = "";
        String worstDistancePassName = "";
        int worstDistanceVersion1 = 0;
        int worstDistanceVersion2 = 0;
        double averageDistance = 0.0;
        Random r = new Random();
        int i = 0;
        while (i < numPasses) {
            String passPhrase = UUID.randomUUID().toString();
            String passswordName = UUID.randomUUID().toString();
            PasswordSetting settings = new PasswordSetting();
            settings.setPasswordName(passswordName);
            settings.setAlgorithmVersion(2);
            settings.setOptionUseLCase(true);
            settings.setOptionUseUCase(true);
            settings.setOptionUseSChars(true);
            settings.setOptionUseExtChars(false);
            settings.setOptionUseNumbers(true);
            settings.setPasswordLength(4);
            int length = 4;
            while (length <= 128) {
                try {
                    int v1 = r.nextInt();
                    int v2 = v1 + 1;
                    if (r.nextBoolean()) {
                        v2 -= 2;
                    }
                    settings.setPasswordLength(length);
                    settings.setPasswordVersion(Integer.toString(v1));
                    String password1 = Narpas.generatePassword(passPhrase, settings);
                    settings.setPasswordVersion(Integer.toString(v2));
                    String password2 = Narpas.generatePassword(passPhrase, settings);
                    int ld = StringDistance.levenshteinDistance(password1, password2);
                    double difference = (double)ld / (double)length;
                    averageDifference += difference;
                    if (difference < minDifference) {
                        minDifference = difference;
                        minDifferencePassword1 = password1;
                        minDifferencePassword2 = password2;
                        minDifferencePassPhrase = passPhrase;
                        minDifferencePassName = passswordName;
                        minDifferenceVersion1 = v1;
                        minDifferenceVersion2 = v2;
                    }
                    int distance = length - StringDistance.hammingDistance(password1, password2);
                    averageDistance += (double)distance;
                    if ((double)distance > worstDistance) {
                        worstDistance = distance;
                        worstDistancePassword1 = password1;
                        worstDistancePassword2 = password2;
                        worstDistancePassPhrase = passPhrase;
                        worstDistancePassName = passswordName;
                        worstDistanceVersion1 = v1;
                        worstDistanceVersion2 = v2;
                    }
                    ++totalPasses;
                }
                catch (Exception x) {
                    x.printStackTrace();
                    Assert.fail((String)x.getMessage());
                }
                ++length;
            }
            ++i;
        }
        System.out.println("test_v2PasswordVersionEntropy: Password difference\n------------------------------");
        System.out.println("averageDifference:" + averageDifference / (double)totalPasses);
        System.out.println("minDifference:" + minDifference);
        System.out.println("minDifferencePassPhrase:" + minDifferencePassPhrase);
        System.out.println("minDifferencePassName:" + minDifferencePassName);
        System.out.println("minDifferenceVersion1:" + minDifferenceVersion1);
        System.out.println("minDifferenceVersion2:" + minDifferenceVersion2);
        System.out.println("minDifferencePassword1:" + minDifferencePassword1);
        System.out.println("minDifferencePassword2:" + minDifferencePassword2);
        System.out.println("");
        System.out.println("test_v2PasswordVersionEntropy: Password distance\n------------------------------");
        System.out.println("averageDistance:" + averageDistance / (double)totalPasses);
        System.out.println("worstDistance:" + worstDistance);
        System.out.println("worstDistancePassPhrase:" + worstDistancePassPhrase);
        System.out.println("worstDistancePassName:" + worstDistancePassName);
        System.out.println("worstDistanceVersion1:" + worstDistanceVersion1);
        System.out.println("worstDistanceVersion2:" + worstDistanceVersion2);
        System.out.println("worstDistancePassword1:" + worstDistancePassword1);
        System.out.println("worstDistancePassword2:" + worstDistancePassword2);
        System.out.println("");
    }

    @Test
    public void test_v2PasswordNameEntropy() {
        int numPasses = 100;
        int totalPasses = 0;
        double minDifference = 1.0;
        String minDifferencePassword1 = "";
        String minDifferencePassword2 = "";
        String minDifferencePassPhrase = "";
        String minDifferencePasswordName1 = "";
        String minDifferencePasswordName2 = "";
        double averageDifference = 0.0;
        double worstDistance = 0.0;
        String worstDistancePassword1 = "";
        String worstDistancePassword2 = "";
        String worstDistancePassPhrase = "";
        String worstDifferencePasswordName1 = "";
        String worstDifferencePasswordName2 = "";
        double averageDistance = 0.0;
        Random r = new Random();
        int i = 0;
        while (i < numPasses) {
            String passPhrase = UUID.randomUUID().toString();
            PasswordSetting settings = new PasswordSetting();
            settings.setAlgorithmVersion(2);
            settings.setOptionUseLCase(true);
            settings.setOptionUseUCase(true);
            settings.setOptionUseSChars(true);
            settings.setOptionUseExtChars(false);
            settings.setOptionUseNumbers(true);
            settings.setPasswordLength(4);
            int length = 4;
            while (length <= 128) {
                try {
                    settings.setPasswordLength(length);
                    String passwordName1 = UUID.randomUUID().toString();
                    settings.setPasswordName(passwordName1);
                    String password1 = Narpas.generatePassword(passPhrase, settings);
                    StringBuilder sb = new StringBuilder(passwordName1);
                    int changeIndex = r.nextInt(passwordName1.length() - 1);
                    char c = sb.charAt(changeIndex);
                    c = (char)(c + '\u0001');
                    sb.setCharAt(changeIndex, c);
                    String passwordName2 = sb.toString();
                    settings.setPasswordName(passwordName2);
                    String password2 = Narpas.generatePassword(passPhrase, settings);
                    int ld = StringDistance.levenshteinDistance(password1, password2);
                    double difference = (double)ld / (double)length;
                    averageDifference += difference;
                    if (difference < minDifference) {
                        minDifference = difference;
                        minDifferencePassword1 = password1;
                        minDifferencePassword2 = password2;
                        minDifferencePassPhrase = passPhrase;
                        minDifferencePasswordName1 = passwordName1;
                        minDifferencePasswordName2 = passwordName2;
                    }
                    int distance = length - StringDistance.hammingDistance(password1, password2);
                    averageDistance += (double)distance;
                    if ((double)distance > worstDistance) {
                        worstDistance = distance;
                        worstDistancePassword1 = password1;
                        worstDistancePassword2 = password2;
                        worstDistancePassPhrase = passPhrase;
                        worstDifferencePasswordName1 = passwordName1;
                        worstDifferencePasswordName2 = passwordName2;
                    }
                    ++totalPasses;
                }
                catch (Exception x) {
                    x.printStackTrace();
                    Assert.fail((String)x.getMessage());
                }
                ++length;
            }
            ++i;
        }
        System.out.println("test_v2PasswordNameEntropy: Password difference\n------------------------------");
        System.out.println("averageDifference:" + averageDifference / (double)totalPasses);
        System.out.println("minDifference:" + minDifference);
        System.out.println("minDifferencePassPhrase:" + minDifferencePassPhrase);
        System.out.println("minDifferencePasswordName1:" + minDifferencePasswordName1);
        System.out.println("minDifferencePasswordName2:" + minDifferencePasswordName2);
        System.out.println("minDifferencePassword1:" + minDifferencePassword1);
        System.out.println("minDifferencePassword2:" + minDifferencePassword2);
        System.out.println("");
        System.out.println("test_v2PasswordNameEntropy: Password distance\n------------------------------");
        System.out.println("averageDistance:" + averageDistance / (double)totalPasses);
        System.out.println("worstDistance:" + worstDistance);
        System.out.println("worstDistancePassPhrase:" + worstDistancePassPhrase);
        System.out.println("worstDifferencePasswordName1:" + worstDifferencePasswordName1);
        System.out.println("worstDifferencePasswordName2:" + worstDifferencePasswordName2);
        System.out.println("worstDistancePassword1:" + worstDistancePassword1);
        System.out.println("worstDistancePassword2:" + worstDistancePassword2);
        System.out.println("");
    }

    @Test
    public void test_v2WeightEntropy() {
        Random r = new Random();
        int numPasses = 100;
        int totalPasses = 0;
        double minDifference = 1.0;
        String minDifferencePassword1 = "";
        String minDifferencePassword2 = "";
        String minDifferencePassPhrase = "";
        String minDifferencePassName = "";
        double averageDifference = 0.0;
        int i = 0;
        while (i < numPasses) {
            String passPhrase = UUID.randomUUID().toString();
            String passswordName = UUID.randomUUID().toString();
            PasswordSetting settings = new PasswordSetting();
            settings.setPasswordName(passswordName);
            settings.setAlgorithmVersion(2);
            settings.setOptionUseLCase(true);
            settings.setOptionUseUCase(true);
            settings.setOptionUseSChars(true);
            settings.setOptionUseExtChars(true);
            settings.setOptionUseNumbers(true);
            int length = 32;
            while (length <= 128) {
                try {
                    settings.setWeight(CharacterSetArrayIndex.EXTCHARS, 1.0);
                    settings.setWeight(CharacterSetArrayIndex.LCHARS, 1.0);
                    settings.setWeight(CharacterSetArrayIndex.NUMS, 1.0);
                    settings.setWeight(CharacterSetArrayIndex.SCHARS, 1.0);
                    settings.setWeight(CharacterSetArrayIndex.UCHARS, 1.0);
                    settings.setPasswordLength(length);
                    String password1 = Narpas.generatePassword(passPhrase, settings);
                    int rando = r.nextInt(6);
                    CharacterSetArrayIndex weightToChange = CharacterSetArrayIndex.EXTCHARS.getCharacterSetArrayIndex(rando);
                    settings.setWeight(weightToChange, 0.9);
                    String password2 = Narpas.generatePassword(passPhrase, settings);
                    int ld = StringDistance.levenshteinDistance(password1, password2);
                    double difference = (double)ld / (double)length;
                    averageDifference += difference;
                    if (difference < minDifference) {
                        minDifference = difference;
                        minDifferencePassword1 = password1;
                        minDifferencePassword2 = password2;
                        minDifferencePassPhrase = passPhrase;
                        minDifferencePassName = passswordName;
                    }
                    ++totalPasses;
                }
                catch (Exception x) {
                    x.printStackTrace();
                    Assert.fail((String)x.getMessage());
                }
                ++length;
            }
            ++i;
        }
        System.out.println("test_v2WeightEntropy\n------------------------------");
        System.out.println("averageDifference:" + averageDifference / (double)totalPasses);
        System.out.println("minDifference:" + minDifference);
        System.out.println("minDifferencePassPhrase:" + minDifferencePassPhrase);
        System.out.println("minDifferencePassName:" + minDifferencePassName);
        System.out.println("minDifferencePassword1:" + minDifferencePassword1);
        System.out.println("minDifferencePassword2:" + minDifferencePassword2);
        System.out.println("");
    }

    @Test
    public void test_v2CharacterDistributionRandomSettings() {
        int numPasses = 1000;
        int charCount = 0;
        int[] charDist = new int[256];
        int i = 0;
        while (i < 256) {
            charDist[i] = 0;
            ++i;
        }
        Random r = new Random();
        int i2 = 0;
        while (i2 < numPasses) {
            try {
                PasswordSetting settings = new PasswordSetting();
                settings.setAlgorithmVersion(2);
                settings.setOptionUseLCase(r.nextBoolean());
                settings.setOptionUseUCase(r.nextBoolean());
                settings.setOptionUseSChars(r.nextBoolean());
                settings.setOptionUseExtChars(r.nextBoolean());
                settings.setOptionUseNumbers(r.nextBoolean());
                int length = r.nextInt(125) + 4;
                settings.setPasswordLength(length);
                settings.setPasswordVersion(Integer.toString(r.nextInt()));
                settings.setPasswordName(UUID.randomUUID().toString());
                String passphrase = UUID.randomUUID().toString();
                if (Narpas.validate(passphrase, settings)) {
                    String password = Narpas.generatePassword(passphrase, settings);
                    int j = 0;
                    while (j < password.length()) {
                        char index = password.charAt(j);
                        ++charCount;
                        char c = index;
                        charDist[c] = charDist[c] + 1;
                        ++j;
                    }
                }
            }
            catch (Exception x) {
                x.printStackTrace();
                Assert.fail((String)x.getMessage());
            }
            ++i2;
        }
        System.out.println("test_v2CharacterDistributionRandomSettings\n------------------------------");
        System.out.println("Total characters counted:" + charCount);
        i2 = 0;
        while (i2 < 256) {
            if (charDist[i2] > 0) {
                char c = (char)i2;
                System.out.println(String.valueOf(i2) + "[" + c + "]=" + charDist[i2]);
            }
            ++i2;
        }
        System.out.println("");
    }

    @Test
    public void test_v2CharacterDistributionFixedSettings() {
        int numPasses = 1000;
        int charCount = 0;
        int[] charDist = new int[256];
        int i = 0;
        while (i < 256) {
            charDist[i] = 0;
            ++i;
        }
        i = 0;
        while (i < numPasses) {
            try {
                PasswordSetting settings = new PasswordSetting();
                settings.setAlgorithmVersion(2);
                settings.setOptionUseLCase(true);
                settings.setOptionUseUCase(true);
                settings.setOptionUseSChars(true);
                settings.setOptionUseExtChars(true);
                settings.setOptionUseNumbers(true);
                int length = 128;
                settings.setPasswordLength(length);
                settings.setPasswordVersion(Integer.toString(0));
                settings.setPasswordName(UUID.randomUUID().toString());
                String passphrase = UUID.randomUUID().toString();
                if (Narpas.validate(passphrase, settings)) {
                    String password = Narpas.generatePassword(passphrase, settings);
                    int j = 0;
                    while (j < password.length()) {
                        char index = password.charAt(j);
                        ++charCount;
                        char c = index;
                        charDist[c] = charDist[c] + 1;
                        ++j;
                    }
                }
            }
            catch (Exception x) {
                x.printStackTrace();
                Assert.fail((String)x.getMessage());
            }
            ++i;
        }
        System.out.println("test_v2CharacterDistributionFixedSettings\n------------------------------");
        System.out.println("Total characters counted:" + charCount);
        i = 0;
        while (i < 256) {
            if (charDist[i] > 0) {
                char c = (char)i;
                System.out.println(String.valueOf(i) + "[" + c + "]=" + charDist[i]);
            }
            ++i;
        }
        System.out.println("");
    }

    @Test
    public void test_v2CharacterSetsWithRandomValuesAllLengths() {
        try {
            Random r = new Random();
            ArrayList<Character> lowerCase = new ArrayList<Character>();
            ArrayList<Character> upperCase = new ArrayList<Character>();
            ArrayList<Character> numbers = new ArrayList<Character>();
            ArrayList<Character> specialChars = new ArrayList<Character>();
            ArrayList<Character> limitSpecialChars = new ArrayList<Character>();
            ArrayList<Character> extChars = new ArrayList<Character>();
            char[] lsc = new char[]{'{', '}', '`', '[', ']'};
            ArrayUtil.fillArrayList(lowerCase, Narpas.Constants.lchars);
            ArrayUtil.fillArrayList(upperCase, Narpas.Constants.uchars);
            ArrayUtil.fillArrayList(numbers, Narpas.Constants.nums);
            ArrayUtil.fillArrayList(specialChars, Narpas.Constants.schars);
            ArrayUtil.fillArrayList(limitSpecialChars, lsc);
            ArrayUtil.fillArrayList(extChars, Narpas.Constants.extchars);
            PasswordSetting settings = new PasswordSetting();
            settings.setAlgorithmVersion(2);
            settings.setOptionAllowDuplicateCharacters(false);
            int length = 8;
            while (length <= 128) {
                settings.setPasswordLength(length);
                settings.setOptionUseLCase(true);
                settings.setOptionUseUCase(false);
                settings.setOptionUseSChars(false);
                settings.setLimitSpecialChars(null);
                settings.setOptionUseExtChars(false);
                settings.setOptionUseNumbers(false);
                settings.setPasswordName(UUID.randomUUID().toString());
                settings.setPasswordVersion(Integer.toString(r.nextInt()));
                String password = Narpas.generatePassword(UUID.randomUUID().toString(), settings);
                int i = 0;
                while (i < length) {
                    Assert.assertTrue((boolean)lowerCase.contains(Character.valueOf(password.charAt(i))));
                    ++i;
                }
                settings.setOptionUseLCase(false);
                settings.setOptionUseUCase(true);
                settings.setOptionUseSChars(false);
                settings.setLimitSpecialChars(null);
                settings.setOptionUseExtChars(false);
                settings.setOptionUseNumbers(false);
                settings.setPasswordName(UUID.randomUUID().toString());
                settings.setPasswordVersion(Integer.toString(r.nextInt()));
                password = Narpas.generatePassword(UUID.randomUUID().toString(), settings);
                i = 0;
                while (i < length) {
                    Assert.assertTrue((boolean)upperCase.contains(Character.valueOf(password.charAt(i))));
                    ++i;
                }
                settings.setOptionUseLCase(false);
                settings.setOptionUseUCase(true);
                settings.setOptionUseSChars(false);
                settings.setLimitSpecialChars(null);
                settings.setOptionUseExtChars(false);
                settings.setOptionUseNumbers(false);
                settings.setPasswordName(UUID.randomUUID().toString());
                settings.setPasswordVersion(Integer.toString(r.nextInt()));
                password = Narpas.generatePassword(UUID.randomUUID().toString(), settings);
                i = 0;
                while (i < length) {
                    Assert.assertTrue((boolean)upperCase.contains(Character.valueOf(password.charAt(i))));
                    ++i;
                }
                settings.setOptionUseLCase(false);
                settings.setOptionUseUCase(false);
                settings.setOptionUseSChars(true);
                settings.setLimitSpecialChars(null);
                settings.setOptionUseExtChars(false);
                settings.setOptionUseNumbers(false);
                settings.setPasswordName(UUID.randomUUID().toString());
                settings.setPasswordVersion(Integer.toString(r.nextInt()));
                password = Narpas.generatePassword(UUID.randomUUID().toString(), settings);
                i = 0;
                while (i < length) {
                    Assert.assertTrue((boolean)specialChars.contains(Character.valueOf(password.charAt(i))));
                    ++i;
                }
                settings.setOptionUseLCase(false);
                settings.setOptionUseUCase(false);
                settings.setOptionUseSChars(true);
                settings.setLimitSpecialChars(lsc);
                settings.setOptionUseExtChars(false);
                settings.setOptionUseNumbers(false);
                settings.setPasswordName(UUID.randomUUID().toString());
                settings.setPasswordVersion(Integer.toString(r.nextInt()));
                password = Narpas.generatePassword(UUID.randomUUID().toString(), settings);
                i = 0;
                while (i < length) {
                    Assert.assertTrue((boolean)limitSpecialChars.contains(Character.valueOf(password.charAt(i))));
                    ++i;
                }
                settings.setOptionUseLCase(false);
                settings.setOptionUseUCase(false);
                settings.setOptionUseSChars(false);
                settings.setLimitSpecialChars(null);
                settings.setOptionUseExtChars(true);
                settings.setOptionUseNumbers(false);
                settings.setPasswordName(UUID.randomUUID().toString());
                settings.setPasswordVersion(Integer.toString(r.nextInt()));
                password = Narpas.generatePassword(UUID.randomUUID().toString(), settings);
                i = 0;
                while (i < length) {
                    Assert.assertTrue((boolean)extChars.contains(Character.valueOf(password.charAt(i))));
                    ++i;
                }
                settings.setOptionUseLCase(false);
                settings.setOptionUseUCase(false);
                settings.setOptionUseSChars(false);
                settings.setLimitSpecialChars(null);
                settings.setOptionUseExtChars(false);
                settings.setOptionUseNumbers(true);
                settings.setPasswordName(UUID.randomUUID().toString());
                settings.setPasswordVersion(Integer.toString(r.nextInt()));
                password = Narpas.generatePassword(UUID.randomUUID().toString(), settings);
                i = 0;
                while (i < length) {
                    Assert.assertTrue((boolean)numbers.contains(Character.valueOf(password.charAt(i))));
                    ++i;
                }
                boolean hasLCase = false;
                boolean hasUCase = false;
                boolean hasNumber = false;
                boolean hasSpecialChar = false;
                boolean hasExtChar = false;
                boolean selectedCharsOnly = false;
                settings.setOptionUseLCase(true);
                settings.setOptionUseUCase(true);
                settings.setOptionUseSChars(true);
                settings.setLimitSpecialChars(null);
                settings.setOptionUseExtChars(true);
                settings.setOptionUseNumbers(true);
                settings.setPasswordName(UUID.randomUUID().toString());
                settings.setPasswordVersion(Integer.toString(r.nextInt()));
                password = Narpas.generatePassword(UUID.randomUUID().toString(), settings);
                int i2 = 0;
                while (i2 < length) {
                    selectedCharsOnly = false;
                    if (lowerCase.contains(Character.valueOf(password.charAt(i2)))) {
                        selectedCharsOnly = true;
                        hasLCase = true;
                    } else if (upperCase.contains(Character.valueOf(password.charAt(i2)))) {
                        selectedCharsOnly = true;
                        hasUCase = true;
                    } else if (specialChars.contains(Character.valueOf(password.charAt(i2)))) {
                        selectedCharsOnly = true;
                        hasSpecialChar = true;
                    } else if (extChars.contains(Character.valueOf(password.charAt(i2)))) {
                        selectedCharsOnly = true;
                        hasExtChar = true;
                    } else if (numbers.contains(Character.valueOf(password.charAt(i2)))) {
                        selectedCharsOnly = true;
                        hasNumber = true;
                    }
                    Assert.assertTrue((boolean)selectedCharsOnly);
                    ++i2;
                }
                if (!(hasLCase && hasUCase && hasSpecialChar && hasExtChar && hasNumber)) {
                    Assert.fail((String)("Missing expected character set.\nPassword=" + password + "\nhasLCase=" + hasLCase + "\nhasUCase=" + hasUCase + "\nhasNumber=" + hasNumber + "\nhasSpecialChar=" + hasSpecialChar + "\nhasExtChar=" + hasExtChar));
                }
                hasLCase = false;
                hasUCase = false;
                hasNumber = false;
                hasSpecialChar = false;
                hasExtChar = false;
                selectedCharsOnly = false;
                settings.setOptionUseLCase(false);
                settings.setOptionUseUCase(true);
                settings.setOptionUseSChars(true);
                settings.setLimitSpecialChars(null);
                settings.setOptionUseExtChars(true);
                settings.setOptionUseNumbers(true);
                settings.setPasswordName(UUID.randomUUID().toString());
                settings.setPasswordVersion(Integer.toString(r.nextInt()));
                password = Narpas.generatePassword(UUID.randomUUID().toString(), settings);
                i2 = 0;
                while (i2 < length) {
                    selectedCharsOnly = false;
                    if (upperCase.contains(Character.valueOf(password.charAt(i2)))) {
                        selectedCharsOnly = true;
                        hasUCase = true;
                    } else if (specialChars.contains(Character.valueOf(password.charAt(i2)))) {
                        selectedCharsOnly = true;
                        hasSpecialChar = true;
                    } else if (extChars.contains(Character.valueOf(password.charAt(i2)))) {
                        selectedCharsOnly = true;
                        hasExtChar = true;
                    } else if (numbers.contains(Character.valueOf(password.charAt(i2)))) {
                        selectedCharsOnly = true;
                        hasNumber = true;
                    }
                    Assert.assertTrue((boolean)selectedCharsOnly);
                    ++i2;
                }
                if (!(hasUCase && hasSpecialChar && hasExtChar && hasNumber)) {
                    Assert.fail((String)("Missing expected character set.\nPassword=" + password + "\nhasLCase=" + hasLCase + "\nhasUCase=" + hasUCase + "\nhasNumber=" + hasNumber + "\nhasSpecialChar=" + hasSpecialChar + "\nhasExtChar=" + hasExtChar));
                }
                hasLCase = false;
                hasUCase = false;
                hasNumber = false;
                hasSpecialChar = false;
                hasExtChar = false;
                selectedCharsOnly = false;
                settings.setOptionUseLCase(true);
                settings.setOptionUseUCase(false);
                settings.setOptionUseSChars(true);
                settings.setLimitSpecialChars(null);
                settings.setOptionUseExtChars(true);
                settings.setOptionUseNumbers(true);
                settings.setPasswordName(UUID.randomUUID().toString());
                settings.setPasswordVersion(Integer.toString(r.nextInt()));
                password = Narpas.generatePassword(UUID.randomUUID().toString(), settings);
                i2 = 0;
                while (i2 < length) {
                    selectedCharsOnly = false;
                    if (lowerCase.contains(Character.valueOf(password.charAt(i2)))) {
                        selectedCharsOnly = true;
                        hasLCase = true;
                    } else if (specialChars.contains(Character.valueOf(password.charAt(i2)))) {
                        selectedCharsOnly = true;
                        hasSpecialChar = true;
                    } else if (extChars.contains(Character.valueOf(password.charAt(i2)))) {
                        selectedCharsOnly = true;
                        hasExtChar = true;
                    } else if (numbers.contains(Character.valueOf(password.charAt(i2)))) {
                        selectedCharsOnly = true;
                        hasNumber = true;
                    }
                    Assert.assertTrue((boolean)selectedCharsOnly);
                    ++i2;
                }
                if (!(hasLCase && hasSpecialChar && hasExtChar && hasNumber)) {
                    Assert.fail((String)("Missing expected character set.\nPassword=" + password + "\nhasLCase=" + hasLCase + "\nhasUCase=" + hasUCase + "\nhasNumber=" + hasNumber + "\nhasSpecialChar=" + hasSpecialChar + "\nhasExtChar=" + hasExtChar));
                }
                settings.setOptionUseLCase(true);
                settings.setOptionUseUCase(true);
                settings.setOptionUseSChars(true);
                settings.setLimitSpecialChars(lsc);
                settings.setOptionUseExtChars(true);
                settings.setOptionUseNumbers(true);
                settings.setPasswordName(UUID.randomUUID().toString());
                settings.setPasswordVersion(Integer.toString(r.nextInt()));
                password = Narpas.generatePassword(UUID.randomUUID().toString(), settings);
                i2 = 0;
                while (i2 < length) {
                    selectedCharsOnly = false;
                    if (lowerCase.contains(Character.valueOf(password.charAt(i2)))) {
                        selectedCharsOnly = true;
                        hasLCase = true;
                    } else if (upperCase.contains(Character.valueOf(password.charAt(i2)))) {
                        selectedCharsOnly = true;
                        hasUCase = true;
                    } else if (limitSpecialChars.contains(Character.valueOf(password.charAt(i2)))) {
                        selectedCharsOnly = true;
                        hasSpecialChar = true;
                    } else if (extChars.contains(Character.valueOf(password.charAt(i2)))) {
                        selectedCharsOnly = true;
                        hasExtChar = true;
                    } else if (numbers.contains(Character.valueOf(password.charAt(i2)))) {
                        selectedCharsOnly = true;
                        hasNumber = true;
                    }
                    Assert.assertTrue((boolean)selectedCharsOnly);
                    ++i2;
                }
                if (!(hasLCase && hasUCase && hasSpecialChar && hasExtChar && hasNumber)) {
                    Assert.fail((String)("Missing expected character set.\nPassword=" + password + "\nhasLCase=" + hasLCase + "\nhasUCase=" + hasUCase + "\nhasNumber=" + hasNumber + "\nhasSpecialChar=" + hasSpecialChar + "\nhasExtChar=" + hasExtChar));
                }
                settings.setOptionUseLCase(true);
                settings.setOptionUseUCase(true);
                settings.setOptionUseSChars(true);
                settings.setLimitSpecialChars(null);
                settings.setOptionUseExtChars(false);
                settings.setOptionUseNumbers(true);
                settings.setPasswordName(UUID.randomUUID().toString());
                settings.setPasswordVersion(Integer.toString(r.nextInt()));
                password = Narpas.generatePassword(UUID.randomUUID().toString(), settings);
                i2 = 0;
                while (i2 < length) {
                    selectedCharsOnly = false;
                    if (lowerCase.contains(Character.valueOf(password.charAt(i2)))) {
                        selectedCharsOnly = true;
                        hasLCase = true;
                    } else if (upperCase.contains(Character.valueOf(password.charAt(i2)))) {
                        selectedCharsOnly = true;
                        hasUCase = true;
                    } else if (specialChars.contains(Character.valueOf(password.charAt(i2)))) {
                        selectedCharsOnly = true;
                        hasSpecialChar = true;
                    } else if (numbers.contains(Character.valueOf(password.charAt(i2)))) {
                        selectedCharsOnly = true;
                        hasNumber = true;
                    }
                    Assert.assertTrue((boolean)selectedCharsOnly);
                    ++i2;
                }
                if (!(hasLCase && hasUCase && hasSpecialChar && hasNumber)) {
                    Assert.fail((String)("Missing expected character set.\nPassword=" + password + "\nhasLCase=" + hasLCase + "\nhasUCase=" + hasUCase + "\nhasNumber=" + hasNumber + "\nhasSpecialChar=" + hasSpecialChar + "\nhasExtChar=" + hasExtChar));
                }
                settings.setOptionUseLCase(true);
                settings.setOptionUseUCase(true);
                settings.setOptionUseSChars(true);
                settings.setLimitSpecialChars(null);
                settings.setOptionUseExtChars(true);
                settings.setOptionUseNumbers(false);
                settings.setPasswordName(UUID.randomUUID().toString());
                settings.setPasswordVersion(Integer.toString(r.nextInt()));
                password = Narpas.generatePassword(UUID.randomUUID().toString(), settings);
                i2 = 0;
                while (i2 < length) {
                    selectedCharsOnly = false;
                    if (lowerCase.contains(Character.valueOf(password.charAt(i2)))) {
                        selectedCharsOnly = true;
                        hasLCase = true;
                    } else if (upperCase.contains(Character.valueOf(password.charAt(i2)))) {
                        selectedCharsOnly = true;
                        hasUCase = true;
                    } else if (specialChars.contains(Character.valueOf(password.charAt(i2)))) {
                        selectedCharsOnly = true;
                        hasSpecialChar = true;
                    } else if (extChars.contains(Character.valueOf(password.charAt(i2)))) {
                        selectedCharsOnly = true;
                        hasExtChar = true;
                    }
                    Assert.assertTrue((boolean)selectedCharsOnly);
                    ++i2;
                }
                if (!(hasLCase && hasUCase && hasSpecialChar && hasExtChar)) {
                    Assert.fail((String)("Missing expected character set.\nPassword=" + password + "\nhasLCase=" + hasLCase + "\nhasUCase=" + hasUCase + "\nhasNumber=" + hasNumber + "\nhasSpecialChar=" + hasSpecialChar + "\nhasExtChar=" + hasExtChar));
                }
                settings.setOptionUseLCase(true);
                settings.setOptionUseUCase(true);
                settings.setOptionUseSChars(false);
                settings.setLimitSpecialChars(null);
                settings.setOptionUseExtChars(false);
                settings.setOptionUseNumbers(true);
                settings.setPasswordName(UUID.randomUUID().toString());
                settings.setPasswordVersion(Integer.toString(r.nextInt()));
                password = Narpas.generatePassword(UUID.randomUUID().toString(), settings);
                i2 = 0;
                while (i2 < length) {
                    selectedCharsOnly = false;
                    if (lowerCase.contains(Character.valueOf(password.charAt(i2)))) {
                        selectedCharsOnly = true;
                        hasLCase = true;
                    } else if (upperCase.contains(Character.valueOf(password.charAt(i2)))) {
                        selectedCharsOnly = true;
                        hasUCase = true;
                    } else if (numbers.contains(Character.valueOf(password.charAt(i2)))) {
                        selectedCharsOnly = true;
                        hasNumber = true;
                    }
                    Assert.assertTrue((boolean)selectedCharsOnly);
                    ++i2;
                }
                if (!(hasLCase && hasUCase && hasNumber)) {
                    Assert.fail((String)("Missing expected character set.\nPassword=" + password + "\nhasLCase=" + hasLCase + "\nhasUCase=" + hasUCase + "\nhasNumber=" + hasNumber + "\nhasSpecialChar=" + hasSpecialChar + "\nhasExtChar=" + hasExtChar));
                }
                hasLCase = false;
                hasUCase = false;
                hasNumber = false;
                hasSpecialChar = false;
                hasExtChar = false;
                selectedCharsOnly = false;
                settings.setOptionUseLCase(true);
                settings.setOptionUseUCase(true);
                settings.setOptionUseSChars(false);
                settings.setLimitSpecialChars(null);
                settings.setOptionUseExtChars(false);
                settings.setOptionUseNumbers(false);
                settings.setPasswordName(UUID.randomUUID().toString());
                settings.setPasswordVersion(Integer.toString(r.nextInt()));
                password = Narpas.generatePassword(UUID.randomUUID().toString(), settings);
                i2 = 0;
                while (i2 < length) {
                    selectedCharsOnly = false;
                    if (lowerCase.contains(Character.valueOf(password.charAt(i2)))) {
                        selectedCharsOnly = true;
                        hasLCase = true;
                    } else if (upperCase.contains(Character.valueOf(password.charAt(i2)))) {
                        selectedCharsOnly = true;
                        hasUCase = true;
                    }
                    Assert.assertTrue((boolean)selectedCharsOnly);
                    ++i2;
                }
                if (!hasLCase || !hasUCase) {
                    Assert.fail((String)("Missing expected character set.\nPassword=" + password + "\nhasLCase=" + hasLCase + "\nhasUCase=" + hasUCase + "\nhasNumber=" + hasNumber + "\nhasSpecialChar=" + hasSpecialChar + "\nhasExtChar=" + hasExtChar));
                }
                ++length;
            }
        }
        catch (Exception x) {
            x.printStackTrace();
            Assert.fail((String)x.getMessage());
        }
    }
}

