/*
 * Decompiled with CFR 0.152.
 */
package com.huguesjohnson.narpassword.javafx;

import com.huguesjohnson.dubbel.fx.ImageUtil;
import com.huguesjohnson.dubbel.util.DateUtil;
import com.huguesjohnson.dubbel.util.StringComparator;
import com.huguesjohnson.narpas.Narpas;
import com.huguesjohnson.narpas.NarpasUtil;
import com.huguesjohnson.narpas.PasswordSetting;
import com.huguesjohnson.narpas.PasswordSettingDateComparator;
import com.huguesjohnson.narpas.PasswordSettingNameComparator;
import com.huguesjohnson.narpassword.javafx.NARPasswordJavaFX;
import com.huguesjohnson.narpassword.javafx.NARPasswordJavaFXSaveLoadController;
import java.net.URL;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListView;
import javafx.scene.control.PasswordField;
import javafx.scene.control.Slider;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyEvent;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.util.Duration;

public class NARPasswordJavaFXController
implements Initializable {
    private ResourceBundle bundle;
    private int lastSelectionIndex;
    private boolean isRemoving = false;
    private boolean isAdding = false;
    private boolean isSorting = false;
    private boolean isEditing = false;
    private boolean isFiltered = false;
    private boolean passwordInClipboard = false;
    private long lastClipboardClear = 0L;
    private long lastPassPhraseClear = 0L;
    private String savePath;
    private SortedBy sortedBy = SortedBy.NAME;
    private boolean sortedReverse = false;
    ObservableList<PasswordSetting> items = FXCollections.observableArrayList();
    @FXML
    private ListView<PasswordSetting> passwordList;
    @FXML
    private Button openButton;
    @FXML
    private Button saveButton;
    @FXML
    private Button listAddButton;
    @FXML
    private Button listRemoveButton;
    @FXML
    private Button clearPassphraseButton;
    @FXML
    private Button clearPasswordButton;
    @FXML
    private Button sortNameButton;
    @FXML
    private Button sortLastUsedButton;
    @FXML
    private PasswordField fieldPassPhrase;
    @FXML
    private TextField fieldPasswordName;
    @FXML
    private TextField fieldPasswordNotes;
    @FXML
    private TextField fieldPassword;
    @FXML
    private TextField fieldPasswordVersion;
    @FXML
    private TextField fieldLimitSpecialCharacters;
    @FXML
    private TextField fieldLastUsed;
    @FXML
    private TextField fieldUUID;
    @FXML
    private ComboBox<String> fieldPasswordCategory;
    @FXML
    private ComboBox<String> fieldCategoryFilter;
    @FXML
    private ComboBox<String> fieldAlgorithmVersion;
    @FXML
    private Button copyButton;
    @FXML
    private CheckBox checkLowerCase;
    @FXML
    private CheckBox checkUpperCase;
    @FXML
    private CheckBox checkNumbers;
    @FXML
    private CheckBox checkSpecialCharacters;
    @FXML
    private CheckBox checkExtendedCharacters;
    @FXML
    private CheckBox checkDuplicateCharacters;
    @FXML
    private CheckBox checkLimitSpecialCharacters;
    @FXML
    private CheckBox checkClearClipboard;
    @FXML
    private Slider sliderPasswordLength;
    @FXML
    private Button editPasswordButton;
    @FXML
    private Button savePasswordButton;
    @FXML
    private Button addPasswordButton;
    @FXML
    private Button undoPasswordButton;
    @FXML
    private TextField fieldClearClipboardSeconds;
    @FXML
    private CheckBox checkClearPassphrase;
    @FXML
    private TextField fieldClearPassphraseSeconds;

    public void setSavePath(String savePath) {
        this.savePath = savePath;
    }

    public void initialize(URL url, ResourceBundle bundle) {
        this.bundle = bundle;
        this.fieldPasswordCategory.setMaxWidth(Double.MAX_VALUE);
        this.fieldCategoryFilter.setMaxWidth(Double.MAX_VALUE);
        this.passwordList.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<PasswordSetting>(){

            public void changed(ObservableValue<? extends PasswordSetting> observable, PasswordSetting oldValue, PasswordSetting newValue) {
                NARPasswordJavaFXController.this.passwordListSelectionChanged((ObservableValue<? extends PasswordSetting>)observable, oldValue, newValue);
            }
        });
        this.sliderPasswordLength.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> ov, Number old_val, Number new_val) {
                NARPasswordJavaFXController.this.sliderPasswordLength.setTooltip(new Tooltip(new_val.toString()));
                NARPasswordJavaFXController.this.generatePassword();
            }
        });
        this.fieldAlgorithmVersion.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> selected, String oldValue, String newValue) {
                NARPasswordJavaFXController.this.onAlgorithmVersionChanged();
            }
        });
        this.fieldCategoryFilter.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> selected, String oldValue, String newValue) {
                NARPasswordJavaFXController.this.onCategoryFilterChanged();
            }
        });
        this.passwordList.setItems(this.items);
        this.onAdd(null);
        this.lastSelectionIndex = 0;
        this.updateFormFields((PasswordSetting)this.passwordList.getSelectionModel().getSelectedItem());
        Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)1.0), (EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                NARPasswordJavaFXController.this.onTimer();
            }
        }, new KeyValue[0])});
        timeline.setCycleCount(-1);
        timeline.play();
        this.fieldCategoryFilter.getItems().add((Object)"[Unsorted]");
        this.fieldCategoryFilter.getItems().add((Object)"");
        this.enableDisableFields(false);
        ImageUtil.drawButtonImageIfNotLoadedFromFXML(this.listAddButton, "add.png", NARPasswordJavaFXController.class);
        ImageUtil.drawButtonImageIfNotLoadedFromFXML(this.openButton, "open.png", NARPasswordJavaFXController.class);
        ImageUtil.drawButtonImageIfNotLoadedFromFXML(this.saveButton, "save.png", NARPasswordJavaFXController.class);
        ImageUtil.drawButtonImageIfNotLoadedFromFXML(this.listRemoveButton, "remove.png", NARPasswordJavaFXController.class);
        ImageUtil.drawButtonImageIfNotLoadedFromFXML(this.clearPassphraseButton, "clear.png", NARPasswordJavaFXController.class);
        ImageUtil.drawButtonImageIfNotLoadedFromFXML(this.clearPasswordButton, "clear.png", NARPasswordJavaFXController.class);
        ImageUtil.drawButtonImageIfNotLoadedFromFXML(this.copyButton, "copy.png", NARPasswordJavaFXController.class);
        ImageUtil.drawButtonImageIfNotLoadedFromFXML(this.editPasswordButton, "edit.png", NARPasswordJavaFXController.class);
        ImageUtil.drawButtonImageIfNotLoadedFromFXML(this.savePasswordButton, "save.png", NARPasswordJavaFXController.class);
        ImageUtil.drawButtonImageIfNotLoadedFromFXML(this.addPasswordButton, "add.png", NARPasswordJavaFXController.class);
        ImageUtil.drawButtonImageIfNotLoadedFromFXML(this.undoPasswordButton, "undo.png", NARPasswordJavaFXController.class);
        ImageUtil.drawButtonImageIfNotLoadedFromFXML(this.sortLastUsedButton, "sortlastused.png", NARPasswordJavaFXController.class);
        ImageUtil.drawButtonImageIfNotLoadedFromFXML(this.sortNameButton, "sortname.png", NARPasswordJavaFXController.class);
    }

    private void setOrAddItem(PasswordSetting setting) {
        int index = this.indexOfItemByUUID(setting.getUuid());
        if (index >= 0) {
            this.items.set(index, (Object)setting);
        } else {
            this.items.add((Object)setting);
        }
    }

    private int indexOfItemByUUID(String uuid) {
        int max = this.items.size();
        int index = 0;
        while (index < max) {
            if (uuid.equals(((PasswordSetting)this.items.get(index)).getUuid())) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private int indexOfItemByName(String name) {
        int max = this.items.size();
        int index = 0;
        while (index < max) {
            if (name.equals(((PasswordSetting)this.items.get(index)).getPasswordName())) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @FXML
    private void onOpen(ActionEvent event) {
        this.showSaveLoadDialog(NARPasswordJavaFXSaveLoadController.SaveDialogMode.LOAD);
    }

    @FXML
    private void onSave(ActionEvent event) {
        this.showSaveLoadDialog(NARPasswordJavaFXSaveLoadController.SaveDialogMode.SAVE);
    }

    public void showSaveLoadDialog(NARPasswordJavaFXSaveLoadController.SaveDialogMode mode) {
        boolean save = mode == NARPasswordJavaFXSaveLoadController.SaveDialogMode.SAVE;
        try {
            Stage dialog = new Stage();
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("SaveLoadDialog.fxml"), this.bundle);
            Scene scene = new Scene((Parent)loader.load());
            NARPasswordJavaFXSaveLoadController controller = (NARPasswordJavaFXSaveLoadController)loader.getController();
            controller.setSavePath(this.savePath);
            dialog.setScene(scene);
            dialog.getIcons().add((Object)new Image(NARPasswordJavaFX.class.getResourceAsStream("narpas-icon-16.png")));
            dialog.setResizable(true);
            dialog.setScene(scene);
            dialog.initModality(Modality.APPLICATION_MODAL);
            if (save) {
                dialog.setTitle(this.bundle.getString("save_title"));
                controller.setPasswordSettingList((List<PasswordSetting>)this.items);
            } else {
                dialog.setTitle(this.bundle.getString("load_title"));
            }
            controller.setMode(mode);
            dialog.showAndWait();
            if (!save && !controller.getCancel()) {
                List<PasswordSetting> list = controller.getPasswordSettingList();
                this.items.clear();
                this.items.setAll(NarpasUtil.prepV2Migrate(list));
                List<String> categories = NarpasUtil.getAllCategories(list);
                this.fieldPasswordCategory.getItems().clear();
                this.fieldPasswordCategory.getItems().addAll(categories);
                this.fieldCategoryFilter.getItems().clear();
                this.fieldCategoryFilter.getItems().addAll(categories);
                if (!this.fieldCategoryFilter.getItems().contains((Object)"[Unsorted]")) {
                    this.fieldCategoryFilter.getItems().add((Object)"[Unsorted]");
                }
                if (!this.fieldCategoryFilter.getItems().contains((Object)"")) {
                    this.fieldCategoryFilter.getItems().add((Object)"");
                }
                this.fieldCategoryFilter.getItems().sort((Comparator)new StringComparator());
                this.passwordList.getSelectionModel().select(0);
                this.passwordList.getFocusModel().focus(0);
                this.lastSelectionIndex = 0;
                this.updateFormFields((PasswordSetting)this.passwordList.getItems().get(0));
                this.savePath = controller.getSavePath();
            } else if (save && !controller.getCancel()) {
                this.savePath = controller.getSavePath();
            }
        }
        catch (Exception x) {
            this.showErrorAlert(x);
        }
    }

    @FXML
    private void onAdd(ActionEvent event) {
        long l = 0L;
        String passwordName = "[new password " + l + "]";
        while (this.indexOfItemByName(passwordName) >= 0) {
            passwordName = "[new password " + ++l + "]";
        }
        PasswordSetting newPassword = new PasswordSetting(passwordName, true, true, true, true, 32, "");
        newPassword.setAlgorithmVersion(2);
        if (this.isFiltered) {
            newPassword.setCategory((String)this.fieldCategoryFilter.getValue());
        } else {
            newPassword.setCategory("[Unsorted]");
        }
        this.setOrAddItem(newPassword);
        this.passwordList.getSelectionModel().select(this.items.size() - 1);
        this.listRemoveButton.setDisable(false);
        this.onEditPasswordSettings(event);
    }

    @FXML
    private void onRemove(ActionEvent event) {
        if (this.items.size() < 1) {
            this.listRemoveButton.setDisable(true);
            return;
        }
        int currentSelection = this.passwordList.getSelectionModel().getSelectedIndex();
        if (currentSelection < 0) {
            this.listRemoveButton.setDisable(true);
            return;
        }
        this.isRemoving = true;
        int removeIndex = this.passwordList.getSelectionModel().getSelectedIndex();
        this.items.remove(removeIndex);
        this.isRemoving = false;
        int newSize = this.items.size();
        if (newSize < 1) {
            this.listRemoveButton.setDisable(true);
            this.lastSelectionIndex = -1;
        } else if (removeIndex == 0) {
            this.updateFormFields((PasswordSetting)this.passwordList.getItems().get(0));
        }
    }

    @FXML
    private void onSortName(ActionEvent event) {
        this.isSorting = true;
        boolean reverse = false;
        if (this.sortedBy == SortedBy.NAME) {
            reverse = !this.sortedReverse;
        }
        this.items.sort((Comparator)new PasswordSettingNameComparator(reverse));
        this.sortedBy = SortedBy.NAME;
        this.sortedReverse = reverse;
        this.isSorting = false;
        this.lastSelectionIndex = this.passwordList.getSelectionModel().getSelectedIndex();
    }

    @FXML
    private void onSortLastUsed(ActionEvent event) {
        this.isSorting = true;
        boolean reverse = false;
        if (this.sortedBy == SortedBy.DATE) {
            reverse = !this.sortedReverse;
        }
        this.items.sort((Comparator)new PasswordSettingDateComparator(reverse));
        this.sortedBy = SortedBy.DATE;
        this.sortedReverse = reverse;
        this.isSorting = false;
        this.lastSelectionIndex = this.passwordList.getSelectionModel().getSelectedIndex();
    }

    @FXML
    private void onEditPasswordSettings(ActionEvent event) {
        this.enableDisableFields(true);
        this.checkAddNew();
    }

    @FXML
    private void onSavePasswordSettings(ActionEvent event) {
        this.updateSelectedListItem();
        this.enableDisableFields(false);
    }

    @FXML
    private void onAddPasswordSettings(ActionEvent event) {
        this.isAdding = true;
        this.items.add((Object)this.getPasswordSettings());
        this.passwordList.getSelectionModel().select(this.items.size() - 1);
        this.enableDisableFields(false);
        this.isAdding = false;
    }

    @FXML
    private void onCancelPasswordSettings(ActionEvent event) {
        this.updateFormFields((PasswordSetting)this.passwordList.getSelectionModel().getSelectedItem());
        this.enableDisableFields(false);
    }

    @FXML
    private void onCopy(ActionEvent event) {
        Clipboard clipboard = Clipboard.getSystemClipboard();
        ClipboardContent content = new ClipboardContent();
        content.putString(this.fieldPassword.getText());
        clipboard.setContent((Map)content);
        this.passwordInClipboard = true;
        this.lastClipboardClear = 0L;
        long ms = System.currentTimeMillis();
        this.fieldLastUsed.setText(DateUtil.toString(ms, DateUtil.DF_YearMonthDayHourMinuteSecond));
        int index = this.indexOfItemByUUID(this.fieldUUID.getText());
        if (index >= 0) {
            ((PasswordSetting)this.items.get(index)).setLastUsed(ms);
        }
    }

    @FXML
    private void onClearPassphrase(ActionEvent event) {
        this.lastPassPhraseClear = 0L;
        this.fieldPassPhrase.setText("");
        this.generatePassword();
    }

    @FXML
    private void onClearPassword(ActionEvent event) {
        if (this.passwordInClipboard) {
            this.lastClipboardClear = 0L;
            Clipboard clipboard = Clipboard.getSystemClipboard();
            ClipboardContent content = new ClipboardContent();
            content.putString("");
            clipboard.setContent((Map)content);
            this.passwordInClipboard = false;
        }
    }

    @FXML
    private void onPasswordVersionChange(KeyEvent event) {
        this.generatePassword();
    }

    @FXML
    private void onPassphraseChange(KeyEvent event) {
        this.generatePassword();
    }

    @FXML
    private void onPasswordLimitSpecialCharactersChange(KeyEvent event) {
        this.generatePassword();
    }

    @FXML
    private void onPasswordNameChange(KeyEvent event) {
        this.generatePassword();
        this.checkAddNew();
    }

    @FXML
    private void onCheckSpecialCharacters(ActionEvent event) {
        int index = this.fieldAlgorithmVersion.getSelectionModel().getSelectedIndex();
        if (index > 0) {
            boolean selected = this.checkSpecialCharacters.isSelected();
            this.checkLimitSpecialCharacters.setDisable(!selected);
            if (!selected) {
                this.checkLimitSpecialCharacters.setSelected(false);
            }
        } else {
            this.checkLimitSpecialCharacters.setSelected(false);
            this.checkLimitSpecialCharacters.setDisable(true);
        }
        this.onPasswordSettingsCheckbox(event);
    }

    @FXML
    private void onPasswordSettingsCheckbox(ActionEvent event) {
        this.generatePassword();
        this.checkAddNew();
    }

    @FXML
    private void onPasswordNotesChange(KeyEvent event) {
        this.checkAddNew();
    }

    @FXML
    private void onPasswordCategoryChange(KeyEvent event) {
        this.checkAddNew();
    }

    @FXML
    private void onCategoryFilterChanged() {
        String filterCategory = (String)this.fieldCategoryFilter.getSelectionModel().getSelectedItem();
        if (filterCategory.equals("")) {
            this.passwordList.setItems(this.items);
            this.isFiltered = false;
        } else {
            FilteredList fl = this.items.filtered(f -> filterCategory.equals(f.getCategory()));
            this.passwordList.setItems((ObservableList)fl);
            this.isFiltered = true;
        }
    }

    @FXML
    private void onClearPassphraseTimeChange(KeyEvent event) {
        this.lastClipboardClear = 0L;
        String newText = this.fieldClearPassphraseSeconds.getText();
        String currentStyle = this.fieldClearPassphraseSeconds.getStyle();
        try {
            int value = Integer.parseInt(newText);
            if (value < 0) {
                throw new Exception("");
            }
            if (currentStyle.contains(" -fx-background-color: red;")) {
                this.fieldClearPassphraseSeconds.setStyle(currentStyle.replace(" -fx-background-color: red;", ""));
            }
        }
        catch (Exception x) {
            this.fieldClearPassphraseSeconds.setStyle(String.valueOf(currentStyle) + " -fx-background-color: red;");
        }
    }

    @FXML
    private void onClearPasswordTimeChange(KeyEvent event) {
        this.lastClipboardClear = 0L;
        String newText = this.fieldClearClipboardSeconds.getText();
        String currentStyle = this.fieldClearClipboardSeconds.getStyle();
        try {
            int value = Integer.parseInt(newText);
            if (value < 0) {
                throw new Exception("");
            }
            if (currentStyle.contains(" -fx-background-color: red;")) {
                this.fieldClearClipboardSeconds.setStyle(currentStyle.replace(" -fx-background-color: red;", ""));
            }
        }
        catch (Exception x) {
            this.fieldClearClipboardSeconds.setStyle(String.valueOf(currentStyle) + " -fx-background-color: red;");
        }
    }

    @FXML
    private void onClearPassphraseCheck(ActionEvent event) {
        this.lastPassPhraseClear = 0L;
    }

    @FXML
    private void onClearPasswordCheck(ActionEvent event) {
        this.lastClipboardClear = 0L;
    }

    private void onAlgorithmVersionChanged() {
        boolean disable = true;
        int index = this.fieldAlgorithmVersion.getSelectionModel().getSelectedIndex();
        if (index > 0) {
            disable = false;
        }
        this.checkExtendedCharacters.setDisable(disable);
        this.checkLimitSpecialCharacters.setDisable(disable);
        this.checkDuplicateCharacters.setDisable(disable);
        this.fieldPasswordVersion.setDisable(disable);
        this.fieldLimitSpecialCharacters.setDisable(disable);
        if (disable) {
            this.checkExtendedCharacters.setSelected(false);
            this.checkLimitSpecialCharacters.setSelected(false);
            this.checkDuplicateCharacters.setSelected(false);
            this.fieldPasswordVersion.setText("");
            this.fieldLimitSpecialCharacters.setText("");
            this.sliderPasswordLength.setBlockIncrement(8.0);
            this.sliderPasswordLength.setMajorTickUnit(8.0);
            this.sliderPasswordLength.setSnapToTicks(true);
            int passwordLength = (int)this.sliderPasswordLength.getValue();
            if (passwordLength % 8 != 0) {
                this.sliderPasswordLength.setValue((double)(Math.round((double)passwordLength / 8.0) * 8L));
            }
        } else {
            this.sliderPasswordLength.setBlockIncrement(1.0);
            this.sliderPasswordLength.setMajorTickUnit(8.0);
            this.sliderPasswordLength.setSnapToTicks(false);
        }
        this.generatePassword();
    }

    private void onTimer() {
        int value2;
        if (this.passwordInClipboard && this.checkClearClipboard.isSelected()) {
            try {
                value2 = Integer.parseInt(this.fieldClearClipboardSeconds.getText());
                if (this.lastClipboardClear > (long)value2) {
                    this.onClearPassword(null);
                } else {
                    ++this.lastClipboardClear;
                }
            }
            catch (Exception value2) {
                // empty catch block
            }
        }
        if (this.checkClearPassphrase.isSelected()) {
            try {
                value2 = Integer.parseInt(this.fieldClearPassphraseSeconds.getText());
                if (this.lastPassPhraseClear > (long)value2) {
                    this.onClearPassphrase(null);
                } else {
                    ++this.lastPassPhraseClear;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void passwordListSelectionChanged(ObservableValue<? extends PasswordSetting> observable, PasswordSetting oldValue, PasswordSetting newValue) {
        PasswordSetting psNew;
        PasswordSetting psSelected;
        if (newValue == null) {
            this.passwordList.getSelectionModel().select(0);
            return;
        }
        if (this.isSorting) {
            return;
        }
        int currentSelectionIndex = this.passwordList.getSelectionModel().getSelectedIndex();
        if (currentSelectionIndex == this.lastSelectionIndex) {
            return;
        }
        if (this.lastSelectionIndex >= 0 && this.lastSelectionIndex < this.items.size() && this.isEditing && (psSelected = (PasswordSetting)this.items.get(this.lastSelectionIndex)) != null && !this.isAdding && !this.isRemoving && !psSelected.compare(psNew = this.getPasswordSettings())) {
            Alert a = new Alert(Alert.AlertType.CONFIRMATION, String.valueOf(this.bundle.getString("label_savechanges")) + psNew.getPasswordName() + "?", new ButtonType[]{ButtonType.NO, ButtonType.YES});
            a.setTitle(this.bundle.getString("title_save_prompt"));
            Optional result = a.showAndWait();
            if (result.isPresent() && ((ButtonType)result.get()).equals(ButtonType.YES)) {
                this.items.set(this.lastSelectionIndex, (Object)psNew);
            }
        }
        if (currentSelectionIndex > -1) {
            this.lastSelectionIndex = currentSelectionIndex;
        } else if (this.items.size() < 0) {
            this.lastSelectionIndex = -1;
            this.listRemoveButton.setDisable(true);
        }
        this.updateFormFields(newValue);
        this.enableDisableFields(false);
        this.listRemoveButton.setDisable(false);
    }

    private void updateFormFields(PasswordSetting setting) {
        if (setting != null) {
            int index;
            this.fieldPasswordName.setText(setting.getPasswordName());
            this.fieldPasswordNotes.setText(setting.getPasswordNotes());
            this.fieldPasswordVersion.setText(setting.getPasswordVersion());
            this.fieldLastUsed.setText(DateUtil.toString(setting.getLastUsed(), DateUtil.DF_YearMonthDayHourMinuteSecond));
            this.fieldUUID.setText(setting.getUuid());
            String category = setting.getCategory();
            if (category == null || category.length() < 1) {
                category = "[Unsorted]";
            }
            if ((index = this.fieldPasswordCategory.getItems().indexOf((Object)category)) < 0) {
                this.fieldPasswordCategory.getItems().add((Object)category);
                index = this.fieldPasswordCategory.getItems().indexOf((Object)category);
            }
            this.fieldPasswordCategory.getSelectionModel().select(index);
            this.checkLowerCase.setSelected(setting.isOptionUseLCase());
            this.checkUpperCase.setSelected(setting.isOptionUseUCase());
            this.checkNumbers.setSelected(setting.isOptionUseNumbers());
            this.checkExtendedCharacters.setSelected(setting.isOptionUseExtChars());
            this.checkDuplicateCharacters.setSelected(setting.isOptionAllowDuplicateCharacters());
            boolean useSChars = setting.isOptionUseSChars();
            this.checkSpecialCharacters.setSelected(useSChars);
            char[] limitSpecialCharacters = setting.getLimitSpecialChars();
            if (limitSpecialCharacters == null || limitSpecialCharacters.length < 1) {
                this.fieldLimitSpecialCharacters.setText(new String(Narpas.Constants.schars));
                this.checkLimitSpecialCharacters.setSelected(false);
            } else {
                this.fieldLimitSpecialCharacters.setText(new String(limitSpecialCharacters));
                this.checkLimitSpecialCharacters.setSelected(true);
            }
            int algorithmVersion = setting.getAlgorithmVersion();
            if (algorithmVersion < 1) {
                algorithmVersion = 1;
            } else if (algorithmVersion > 2) {
                algorithmVersion = 2;
            }
            this.fieldAlgorithmVersion.getSelectionModel().select(algorithmVersion - 1);
            this.sliderPasswordLength.setValue((double)setting.getPasswordLength());
            this.generatePassword();
        }
    }

    private void updateSelectedListItem() {
        if (this.isRemoving) {
            return;
        }
        int size = this.items.size();
        if (this.lastSelectionIndex > -1 && size > 0 && this.lastSelectionIndex < size) {
            PasswordSetting setting = new PasswordSetting();
            long ms = System.currentTimeMillis();
            setting.setLastUsed(ms);
            this.fieldLastUsed.setText(DateUtil.toString(ms, DateUtil.DF_YearMonthDayHourMinuteSecond));
            setting.setPasswordName(this.fieldPasswordName.getText());
            setting.setPasswordNotes(this.fieldPasswordNotes.getText());
            setting.setPasswordVersion(this.fieldPasswordVersion.getText());
            setting.setUuid(this.fieldUUID.getText());
            String category = (String)this.fieldPasswordCategory.getSelectionModel().getSelectedItem();
            setting.setCategory(category);
            if (!this.fieldCategoryFilter.getItems().contains((Object)category)) {
                this.fieldCategoryFilter.getItems().add((Object)category);
            }
            if (!this.fieldPasswordCategory.getItems().contains((Object)category)) {
                this.fieldPasswordCategory.getItems().add((Object)category);
            }
            setting.setOptionAllowDuplicateCharacters(this.checkDuplicateCharacters.isSelected());
            setting.setOptionUseExtChars(this.checkExtendedCharacters.isSelected());
            setting.setOptionUseLCase(this.checkLowerCase.isSelected());
            setting.setOptionUseUCase(this.checkUpperCase.isSelected());
            setting.setOptionUseNumbers(this.checkNumbers.isSelected());
            boolean useSChars = this.checkSpecialCharacters.isSelected();
            setting.setOptionUseSChars(useSChars);
            if (useSChars) {
                String limitSpecialChars = this.fieldLimitSpecialCharacters.getText();
                if (this.checkLimitSpecialCharacters.isSelected() && limitSpecialChars != null && limitSpecialChars.length() > 0) {
                    setting.setLimitSpecialChars(limitSpecialChars.toCharArray());
                }
            }
            setting.setAlgorithmVersion(this.fieldAlgorithmVersion.getSelectionModel().getSelectedIndex() + 1);
            setting.setPasswordLength((int)this.sliderPasswordLength.getValue());
            this.setOrAddItem(setting);
        }
    }

    private void generatePassword() {
        String passPhrase = this.fieldPassPhrase.getText();
        PasswordSetting settings = this.getPasswordSettings();
        if (settings.getAlgorithmVersion() <= 1) {
            settings.setPasswordLength(settings.getPasswordLength() / 8);
        }
        String password = "";
        if (Narpas.validate(passPhrase, settings)) {
            try {
                password = Narpas.generatePassword(passPhrase, settings);
                this.copyButton.setDisable(false);
            }
            catch (Exception x) {
                this.showErrorAlert(x);
                this.copyButton.setDisable(true);
            }
        } else {
            this.copyButton.setDisable(true);
        }
        this.fieldPassword.setText(password);
    }

    private void checkAddNew() {
        PasswordSetting setting = this.getPasswordSettings();
        if (((PasswordSetting)this.passwordList.getSelectionModel().getSelectedItem()).equals(setting)) {
            this.addPasswordButton.setDisable(true);
            this.savePasswordButton.setDisable(false);
        } else if (this.items.contains((Object)setting)) {
            this.addPasswordButton.setDisable(true);
            this.savePasswordButton.setDisable(true);
        } else {
            this.addPasswordButton.setDisable(false);
            this.savePasswordButton.setDisable(false);
        }
    }

    private void enableDisableFields(boolean enabled) {
        this.fieldPasswordVersion.setDisable(!enabled);
        this.fieldPasswordName.setDisable(!enabled);
        this.checkLowerCase.setDisable(!enabled);
        this.checkUpperCase.setDisable(!enabled);
        this.checkNumbers.setDisable(!enabled);
        this.checkSpecialCharacters.setDisable(!enabled);
        this.checkLimitSpecialCharacters.setDisable(!enabled);
        this.fieldLimitSpecialCharacters.setDisable(!enabled);
        this.checkDuplicateCharacters.setDisable(!enabled);
        this.sliderPasswordLength.setDisable(!enabled);
        this.fieldPasswordNotes.setDisable(!enabled);
        this.editPasswordButton.setDisable(enabled);
        this.savePasswordButton.setDisable(!enabled);
        this.addPasswordButton.setDisable(!enabled);
        this.undoPasswordButton.setDisable(!enabled);
        this.fieldAlgorithmVersion.setDisable(!enabled);
        this.fieldPasswordCategory.setDisable(!enabled);
        if (enabled) {
            this.onAlgorithmVersionChanged();
        } else {
            this.checkExtendedCharacters.setDisable(true);
            this.fieldPasswordVersion.setDisable(true);
        }
        this.isEditing = enabled;
    }

    private PasswordSetting getPasswordSettings() {
        PasswordSetting settings = new PasswordSetting();
        int algorithmVersion = this.fieldAlgorithmVersion.getSelectionModel().getSelectedIndex() + 1;
        settings.setAlgorithmVersion(algorithmVersion);
        settings.setCategory((String)this.fieldPasswordCategory.getSelectionModel().getSelectedItem());
        settings.setLastUsed(((PasswordSetting)this.passwordList.getSelectionModel().getSelectedItem()).getLastUsed());
        settings.setOptionUseLCase(this.checkLowerCase.isSelected());
        settings.setOptionUseNumbers(this.checkNumbers.isSelected());
        boolean useSChars = this.checkSpecialCharacters.isSelected();
        settings.setOptionUseSChars(useSChars);
        settings.setOptionUseUCase(this.checkUpperCase.isSelected());
        settings.setPasswordLength((int)this.sliderPasswordLength.getValue());
        settings.setPasswordName(this.fieldPasswordName.getText());
        settings.setPasswordNotes(this.fieldPasswordNotes.getText());
        if (algorithmVersion > 1) {
            settings.setPasswordVersion(this.fieldPasswordVersion.getText());
            settings.setOptionAllowDuplicateCharacters(this.checkDuplicateCharacters.isSelected());
            settings.setOptionUseExtChars(this.checkExtendedCharacters.isSelected());
            if (useSChars) {
                if (this.checkLimitSpecialCharacters.isSelected()) {
                    String limitSpecialChars = this.fieldLimitSpecialCharacters.getText();
                    if (limitSpecialChars == null || limitSpecialChars.length() < 1) {
                        settings.setLimitSpecialChars(null);
                    } else {
                        settings.setLimitSpecialChars(limitSpecialChars.toCharArray());
                    }
                } else {
                    settings.setLimitSpecialChars(null);
                }
            }
        }
        return settings;
    }

    private void showErrorAlert(Exception x) {
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setTitle(x.getClass().getName());
        alert.setHeaderText(x.getMessage());
        alert.setResizable(true);
        StringBuilder stack = new StringBuilder();
        StackTraceElement[] st = x.getStackTrace();
        int maxLine = 10;
        if (st.length < maxLine) {
            maxLine = st.length - 1;
        }
        int i = 0;
        while (i < maxLine) {
            stack.append(st[i].getFileName());
            stack.append(" - ");
            stack.append(st[i].getMethodName());
            stack.append("[");
            stack.append(st[i].getLineNumber());
            stack.append("]\n");
            ++i;
        }
        stack.append("[.. ");
        stack.append(maxLine - st.length - 1);
        stack.append(" more lines ..]");
        alert.setContentText(stack.toString());
        alert.showAndWait();
    }

    public static enum SortedBy {
        NAME,
        DATE;

    }
}

