/*
 * Decompiled with CFR 0.152.
 */
package com.huguesjohnson.narpassword.javafx;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.huguesjohnson.dubbel.fx.ImageUtil;
import com.huguesjohnson.narpas.PasswordSetting;
import com.huguesjohnson.narpas.PasswordSettingNameComparator;
import com.huguesjohnson.narpas.StringEncryptDecrypt;
import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyEvent;
import javafx.stage.FileChooser;
import javafx.stage.Stage;

public class NARPasswordJavaFXSaveLoadController
implements Initializable {
    private ResourceBundle bundle;
    private String savePath;
    private boolean cancel = true;
    private List<PasswordSetting> passwordSettingList;
    @FXML
    private TextField fieldSavePath;
    @FXML
    private PasswordField fieldSavePassword;
    @FXML
    private PasswordField fieldConfirmSavePassword;
    @FXML
    private Label labelSaveLoadError;
    @FXML
    private Label labelConfirmPassword;
    @FXML
    private Button saveLoadButton;
    @FXML
    private Button browseButton;
    @FXML
    private Button cancelButton;
    @FXML
    private String settingsJson;
    private SaveDialogMode mode;

    public void initialize(URL url, ResourceBundle bundle) {
        this.bundle = bundle;
        ImageUtil.drawButtonImageIfNotLoadedFromFXML(this.browseButton, "open.png", NARPasswordJavaFXSaveLoadController.class);
        ImageUtil.drawButtonImageIfNotLoadedFromFXML(this.cancelButton, "cancel.png", NARPasswordJavaFXSaveLoadController.class);
    }

    public boolean getCancel() {
        return this.cancel;
    }

    public List<PasswordSetting> getPasswordSettingList() {
        return this.passwordSettingList;
    }

    public void setPasswordSettingList(List<PasswordSetting> passwordSettingList) {
        this.passwordSettingList = passwordSettingList;
    }

    public void setSavePath(String savePath) {
        this.savePath = savePath;
        this.fieldSavePath.setText(savePath);
        if (savePath != null && new File(savePath).exists()) {
            this.saveLoadButton.setDisable(false);
        }
    }

    public String getSavePath() {
        return this.savePath;
    }

    public void setMode(SaveDialogMode mode) {
        this.mode = mode;
        if (mode == SaveDialogMode.SAVE) {
            this.saveLoadButton.setText(this.bundle.getString("button_save"));
            this.saveLoadButton.setGraphic((Node)new ImageView(new Image(NARPasswordJavaFXSaveLoadController.class.getResourceAsStream("save.png"))));
            this.saveLoadButton.setTooltip(new Tooltip(this.bundle.getString("tooltip_savedialog")));
            this.labelConfirmPassword.setVisible(true);
            this.fieldConfirmSavePassword.setVisible(true);
        } else {
            this.saveLoadButton.setText(this.bundle.getString("button_load"));
            this.saveLoadButton.setGraphic((Node)new ImageView(new Image(NARPasswordJavaFXSaveLoadController.class.getResourceAsStream("open.png"))));
            this.saveLoadButton.setTooltip(new Tooltip(this.bundle.getString("tooltip_loaddialog")));
            this.labelConfirmPassword.setVisible(false);
            this.fieldConfirmSavePassword.setVisible(false);
        }
    }

    @FXML
    private void onBrowse(ActionEvent event) {
        if (this.mode == SaveDialogMode.SAVE) {
            FileChooser fileChooser = new FileChooser();
            fileChooser.setTitle(this.bundle.getString("savefc_title"));
            fileChooser.setInitialFileName(this.savePath);
            File file = fileChooser.showSaveDialog(null);
            if (file != null) {
                this.saveLoadButton.setDisable(false);
                this.savePath = file.getAbsolutePath();
                this.fieldSavePath.setText(this.savePath);
            }
            this.verifyEncryptionPasswordMatch();
        } else {
            FileChooser fileChooser = new FileChooser();
            fileChooser.setTitle(this.bundle.getString("loadfc_title"));
            fileChooser.setInitialFileName(this.savePath);
            File file = fileChooser.showOpenDialog(null);
            if (file != null) {
                this.saveLoadButton.setDisable(false);
                this.savePath = file.getAbsolutePath();
                this.fieldSavePath.setText(this.savePath);
            }
        }
    }

    @FXML
    private void onEncryptionPasswordChange(KeyEvent event) {
        this.verifyEncryptionPasswordMatch();
    }

    @FXML
    private void onSaveLoad(ActionEvent event) {
        if (this.mode == SaveDialogMode.SAVE) {
            this.settingsJson = new Gson().toJson(this.passwordSettingList);
            try {
                String encryptedString = StringEncryptDecrypt.encrypt(this.fieldSavePassword.getText(), this.settingsJson);
                PrintWriter writer = new PrintWriter(this.fieldSavePath.getText());
                writer.write(encryptedString);
                writer.flush();
                writer.close();
                this.cancel = false;
                this.closeWindow((Event)event);
            }
            catch (Exception x) {
                this.labelSaveLoadError.setText(x.getMessage());
            }
        } else {
            String encryptedString = null;
            try {
                encryptedString = Files.readString(Paths.get(this.fieldSavePath.getText(), new String[0]));
            }
            catch (Exception x) {
                this.labelSaveLoadError.setText(x.getMessage());
            }
            if (encryptedString != null) {
                try {
                    String json = StringEncryptDecrypt.decryptString(this.fieldSavePassword.getText(), encryptedString);
                    Type listType = new TypeToken<ArrayList<PasswordSetting>>(){}.getType();
                    this.passwordSettingList = (List)new Gson().fromJson(json, listType);
                    this.passwordSettingList.sort(new PasswordSettingNameComparator(false));
                    this.cancel = false;
                    this.closeWindow((Event)event);
                }
                catch (Exception x) {
                    this.labelSaveLoadError.setText("Decrypt error " + x.getMessage());
                }
            }
        }
    }

    @FXML
    private void onCancel(ActionEvent event) {
        this.cancel = true;
        this.closeWindow((Event)event);
    }

    private void closeWindow(Event event) {
        ((Stage)((Node)event.getSource()).getScene().getWindow()).close();
    }

    private void verifyEncryptionPasswordMatch() {
        if (this.mode == SaveDialogMode.SAVE) {
            if (this.fieldSavePassword.getText().equals(this.fieldConfirmSavePassword.getText())) {
                this.labelSaveLoadError.setText("");
                this.saveLoadButton.setDisable(false);
            } else {
                this.labelSaveLoadError.setText(this.bundle.getString("label_errorpasswordmatch"));
                this.saveLoadButton.setDisable(true);
            }
        }
    }

    public static enum SaveDialogMode {
        SAVE,
        LOAD;

    }
}

