/*
 * Decompiled with CFR 0.152.
 */
package com.huguesjohnson.luise;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.SystemColor;
import java.awt.Taskbar;
import java.awt.Toolkit;
import java.io.RandomAccessFile;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class LuiseMain
extends JFrame {
    private static final long serialVersionUID = 666L;
    private JTextField txtFilePath = new JTextField("<click browse to select a file>", 35);
    private List<JCheckBox> checkBoxes = new ArrayList<JCheckBox>();
    private List<String> eventTags = new ArrayList<String>();

    public LuiseMain() {
        this.setupUI();
    }

    private void setupUI() {
        this.setTitle("Luise - Phantasy Star III Event Editor");
        this.setDefaultCloseOperation(3);
        this.setLayout(new BorderLayout(10, 10));
        this.attemptToSetIcon();
        JPanel topPanel = new JPanel(new FlowLayout(0));
        JButton btnBrowse = new JButton("Browse..");
        this.txtFilePath.setEditable(false);
        this.txtFilePath.setBackground(SystemColor.control);
        topPanel.add(new JLabel("Save State File:"));
        topPanel.add(this.txtFilePath);
        topPanel.add(btnBrowse);
        JPanel gridPanel = new JPanel(new GridLayout(0, 4, 5, 5));
        this.initializeEvents(gridPanel);
        JScrollPane scrollPane = new JScrollPane(gridPanel);
        scrollPane.setBorder(BorderFactory.createTitledBorder("Game Events"));
        JPanel botPanel = new JPanel(new FlowLayout(2));
        JButton btnSave = new JButton("Save Changes and Quit");
        JButton btnQuit = new JButton("Quit Without Saving");
        botPanel.add(btnSave);
        botPanel.add(btnQuit);
        btnBrowse.addActionListener(e -> this.handleBrowse());
        btnSave.addActionListener(e -> {
            this.saveChanges();
            System.exit(0);
        });
        btnQuit.addActionListener(e -> System.exit(0));
        this.add((Component)topPanel, "North");
        this.add((Component)scrollPane, "Center");
        this.add((Component)botPanel, "South");
        this.setSize(1250, 700);
        this.setLocationRelativeTo(null);
    }

    private void attemptToSetIcon() {
        try {
            Taskbar taskbar;
            URL iconURL = this.getClass().getResource("/com/huguesjohnson/luise/icon.png");
            if (iconURL != null) {
                this.setIconImage(new ImageIcon(iconURL).getImage());
            } else {
                iconURL = this.getClass().getResource("icon.png");
                if (iconURL != null) {
                    this.setIconImage(new ImageIcon(iconURL).getImage());
                }
            }
            if (iconURL != null && Taskbar.isTaskbarSupported() && (taskbar = Taskbar.getTaskbar()).isSupported(Taskbar.Feature.ICON_IMAGE)) {
                Toolkit defaultToolkit = Toolkit.getDefaultToolkit();
                Image icon = defaultToolkit.getImage(this.getClass().getResource("/com/huguesjohnson/luise/icon.png"));
                if (icon != null) {
                    taskbar.setIconImage(icon);
                } else {
                    icon = defaultToolkit.getImage(this.getClass().getResource("icon.png"));
                    if (icon != null) {
                        taskbar.setIconImage(icon);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addEvent(JPanel panel, String caption, String tag) {
        JCheckBox cb = new JCheckBox(caption);
        panel.add(cb);
        this.checkBoxes.add(cb);
        this.eventTags.add(tag);
    }

    private void initializeEvents(JPanel p) {
        this.addEvent(p, "Sapphire can be used", "E11B");
        this.addEvent(p, "Laya's pendant active", "E144");
        this.addEvent(p, "Aqua parts active", "E146");
        this.addEvent(p, "Aero parts active", "E15A");
        this.addEvent(p, "After Miun dies,before chest opened", "E16F");
        this.addEvent(p, "After talking to Siren on Sage Isle", "E171");
        this.addEvent(p, "Twin's Ruby active", "E174");
        this.addEvent(p, "Mystery Star active", "E175");
        this.addEvent(p, "Set at beginning of Rhys' quest", "E378");
        this.addEvent(p, "Before Rhys enters dungeon", "E37A");
        this.addEvent(p, "Set after dragon disappears", "E37B");
        this.addEvent(p, "Rhys put in the dungeon", "E37C");
        this.addEvent(p, "After talking to Lena in dungeon (1)", "E37D");
        this.addEvent(p, "After talking to Lena in dungeon (2)", "E37E");
        this.addEvent(p, "Shopkeepers in Landen tech shop", "E37F");
        this.addEvent(p, "'Layan woman who never blinks'", "E380");
        this.addEvent(p, "Mieu joins party", "E381");
        this.addEvent(p, "Can use Yaata boat", "E382");
        this.addEvent(p, "After talking to Lyle in cave", "E384");
        this.addEvent(p, "'The one you seek abides...'", "E385");
        this.addEvent(p, "Wren joins party", "E386");
        this.addEvent(p, "Lyle joins party in Weather Station", "E387");
        this.addEvent(p, "Weather satellite repaired", "E388");
        this.addEvent(p, "Lena joins party", "E38A");
        this.addEvent(p, "Moons moved", "E38B");
        this.addEvent(p, "King of Cille defeated", "E38C");
        this.addEvent(p, "Selected Maia to marry", "E38D");
        this.addEvent(p, "Selected Lena to marry", "E38E");
        this.addEvent(p, "Set at beginning of 2nd generation", "E390");
        this.addEvent(p, "E391 = ????", "E391");
        this.addEvent(p, "E392 = ????", "E392");
        this.addEvent(p, "E393 = ????", "E393");
        this.addEvent(p, "E394 = ????", "E394");
        this.addEvent(p, "E395 = ????", "E395");
        this.addEvent(p, "E396 = ????", "E396");
        this.addEvent(p, "E397 = ????", "E397");
        this.addEvent(p, "Set at beginning of Ayn's quest", "E398");
        this.addEvent(p, "Set after taking control of Ayn (1)", "E399");
        this.addEvent(p, "Set after taking control of Ayn (2)", "E39A");
        this.addEvent(p, "Shusoran attacked", "E39B");
        this.addEvent(p, "Cille attacked", "E39C");
        this.addEvent(p, "Lensol gate opened", "E39D+E39E+E39F");
        this.addEvent(p, "Thea in party", "E3A0");
        this.addEvent(p, "Sari in party", "E3A1");
        this.addEvent(p, "Lyle dead", "E3A2");
        this.addEvent(p, "Azura can be entered", "E3A8+E3A9");
        this.addEvent(p, "Siren defeated", "E3AC");
        this.addEvent(p, "Set when Nial's quest begins", "E3B8");
        this.addEvent(p, "Set after taking control of Nial (1)", "E3B9");
        this.addEvent(p, "Set after taking control of Nial (2)", "E3BA");
        this.addEvent(p, "Laya in party", "E3C7");
        this.addEvent(p, "Dahlia can be entered", "E3C8+E3C9");
        this.addEvent(p, "Kara in party", "E400");
        this.addEvent(p, "Dark Force free", "E45B");
        this.addEvent(p, "Miun dead", "E45C");
        this.addEvent(p, "Siren dead", "E45D");
        this.addEvent(p, "Mieu learned Grantz", "E45E");
        this.addEvent(p, "Nei Weapons", "E45F");
        this.addEvent(p, "Rulakir dead", "E460");
        this.addEvent(p, "All legendary weapons collected", "E461");
    }

    private void handleBrowse() {
        JFileChooser chooser = new JFileChooser();
        if (chooser.showOpenDialog(this) == 0) {
            this.txtFilePath.setText(chooser.getSelectedFile().getAbsolutePath());
            this.readStuff();
        }
    }

    private void readStuff() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (RandomAccessFile raf = new RandomAccessFile(this.txtFilePath.getText(), "r");){
                int i = 0;
                while (i < this.checkBoxes.size()) {
                    String firstTag = this.eventTags.get(i).split("\\+")[0];
                    long address = Long.parseLong(firstTag, 16);
                    raf.seek(address);
                    byte b = raf.readByte();
                    this.checkBoxes.get(i).setSelected(b != 0);
                    ++i;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception x) {
            JOptionPane.showMessageDialog(this, "Error reading file: " + x.getMessage());
        }
    }

    private void saveChanges() {
        if (this.txtFilePath.getText().contains("<click")) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (RandomAccessFile raf = new RandomAccessFile(this.txtFilePath.getText(), "rw");){
                int i = 0;
                while (i < this.checkBoxes.size()) {
                    String[] addresses;
                    byte val = (byte)(this.checkBoxes.get(i).isSelected() ? 255 : 0);
                    String[] stringArray = addresses = this.eventTags.get(i).split("\\+");
                    int n = addresses.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String addrHex = stringArray[n2];
                        long address = Long.parseLong(addrHex, 16);
                        raf.seek(address);
                        raf.write(val);
                        ++n2;
                    }
                    ++i;
                }
                JOptionPane.showMessageDialog(this, "Changes saved successfully.");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception x) {
            JOptionPane.showMessageDialog(this, "Error saving file: " + x.getMessage());
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        SwingUtilities.invokeLater(() -> new LuiseMain().setVisible(true));
    }
}

